/*
 * Decompiled with CFR 0.152.
 */
package fuzs.enderzoology.world.entity.projectile;

import fuzs.enderzoology.init.ModEntityTypes;
import fuzs.enderzoology.init.ModItems;
import fuzs.enderzoology.world.entity.animal.Owl;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;

public class ThrownOwlEgg
extends ThrowableItemProjectile {
    private static final EntityDimensions ZERO_SIZED_DIMENSIONS = EntityDimensions.fixed((float)0.0f, (float)0.0f);

    public ThrownOwlEgg(EntityType<? extends ThrownOwlEgg> entityType, Level level) {
        super(entityType, level);
    }

    public ThrownOwlEgg(Level level, LivingEntity livingEntity, ItemStack itemStack) {
        super((EntityType)ModEntityTypes.OWL_EGG_ENTITY_TYPE.value(), livingEntity, level, itemStack);
    }

    public ThrownOwlEgg(Level level, double x, double y, double z, ItemStack itemStack) {
        super((EntityType)ModEntityTypes.OWL_EGG_ENTITY_TYPE.value(), x, y, z, level, itemStack);
    }

    public void handleEntityEvent(byte id) {
        if (id == 3) {
            for (int i = 0; i < 8; ++i) {
                this.level().addParticle((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, this.getItem()), this.getX(), this.getY(), this.getZ(), ((double)this.random.nextFloat() - 0.5) * 0.08, ((double)this.random.nextFloat() - 0.5) * 0.08, ((double)this.random.nextFloat() - 0.5) * 0.08);
            }
        }
    }

    protected void onHitEntity(EntityHitResult result) {
        super.onHitEntity(result);
        result.getEntity().hurt(this.damageSources().thrown((Entity)this, this.getOwner()), 0.0f);
    }

    protected void onHit(HitResult result) {
        super.onHit(result);
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.random.nextInt(8) == 0) {
                int i = 1;
                if (this.random.nextInt(32) == 0) {
                    i = 4;
                }
                for (int j = 0; j < i; ++j) {
                    Owl owl = (Owl)((EntityType)ModEntityTypes.OWL_ENTITY_TYPE.value()).create(this.level(), EntitySpawnReason.TRIGGERED);
                    if (owl == null) continue;
                    owl.setAge(-24000);
                    owl.snapTo(this.getX(), this.getY(), this.getZ(), this.getYRot(), 0.0f);
                    if (!owl.fudgePositionAfterSizeChange(ZERO_SIZED_DIMENSIONS)) break;
                    serverLevel.addFreshEntity((Entity)owl);
                }
            }
            this.level().broadcastEntityEvent((Entity)this, (byte)3);
            this.discard();
        }
    }

    protected Item getDefaultItem() {
        return (Item)ModItems.OWL_EGG_ITEM.value();
    }
}

