/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.paginatedadvancements.frames;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.dafuqs.paginatedadvancements.PaginatedAdvancementsClient;
import de.dafuqs.paginatedadvancements.frames.FrameWrapper;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AdvancementFrameDataLoader
extends SimpleJsonResourceReloadListener {
    public static final String LOCATION = "advancement_frames";
    public static final ResourceLocation ID = PaginatedAdvancementsClient.locate("advancement_frames");
    public static final AdvancementFrameDataLoader INSTANCE = new AdvancementFrameDataLoader();
    protected static final Map<ResourceLocation, FrameWrapper> ADVANCEMENT_FRAMES = new HashMap<ResourceLocation, FrameWrapper>();

    public AdvancementFrameDataLoader() {
        super(new Gson(), LOCATION);
    }

    @NotNull
    protected Map<ResourceLocation, JsonElement> prepare(@NotNull ResourceManager resourceManager, @NotNull ProfilerFiller profiler) {
        return super.prepare(resourceManager, profiler);
    }

    protected void apply(Map<ResourceLocation, JsonElement> prepared, @NotNull ResourceManager resourceManager, @NotNull ProfilerFiller profilerFiller) {
        prepared.forEach((identifier, jsonElement) -> {
            for (JsonElement entry : jsonElement.getAsJsonArray()) {
                JsonObject jsonObject = entry.getAsJsonObject();
                ResourceLocation advancement = ResourceLocation.tryParse((String)jsonObject.get("advancement").getAsString());
                ResourceLocation frame = ResourceLocation.tryParse((String)jsonObject.get("frame").getAsString());
                @Nullable FrameWrapper frameWrapper = FrameWrapper.of(frame);
                if (frameWrapper == null) {
                    PaginatedAdvancementsClient.LOGGER.error("Advancement Frame '" + String.valueOf(frame) + "' for advancement  '" + String.valueOf(advancement) + "' is unknown");
                    continue;
                }
                ADVANCEMENT_FRAMES.put(advancement, frameWrapper);
            }
        });
    }

    @Nullable
    public static FrameWrapper get(ResourceLocation id) {
        return ADVANCEMENT_FRAMES.getOrDefault(id, null);
    }
}

