/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.paginatedadvancements.frames;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.dafuqs.paginatedadvancements.PaginatedAdvancementsClient;
import de.dafuqs.paginatedadvancements.client.PaginatedAdvancementFrame;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AdvancementFrameTypeDataLoader
extends SimpleJsonResourceReloadListener {
    public static final String LOCATION = "advancement_frame_types";
    public static final ResourceLocation ID = PaginatedAdvancementsClient.locate("advancement_frame_types");
    public static final AdvancementFrameTypeDataLoader INSTANCE = new AdvancementFrameTypeDataLoader();
    protected static final Map<ResourceLocation, PaginatedAdvancementFrame> FRAMES = new HashMap<ResourceLocation, PaginatedAdvancementFrame>();

    public AdvancementFrameTypeDataLoader() {
        super(new Gson(), LOCATION);
    }

    @NotNull
    protected Map<ResourceLocation, JsonElement> prepare(@NotNull ResourceManager resourceManager, @NotNull ProfilerFiller profiler) {
        return super.prepare(resourceManager, profiler);
    }

    protected void apply(Map<ResourceLocation, JsonElement> prepared, @NotNull ResourceManager resourceManager, @NotNull ProfilerFiller profilerFiller) {
        prepared.forEach((identifier, jsonElement) -> {
            JsonObject object = jsonElement.getAsJsonObject();
            for (JsonElement frameEntry : object.get("frames").getAsJsonArray()) {
                JsonObject jsonObject = frameEntry.getAsJsonObject();
                String name = jsonObject.get("name").getAsString();
                ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)identifier.getNamespace(), (String)name);
                int itemOffsetX = GsonHelper.getAsInt((JsonObject)jsonObject, (String)"item_offset_x", (int)0);
                int itemOffsetY = GsonHelper.getAsInt((JsonObject)jsonObject, (String)"item_offset_y", (int)0);
                String formattingString = GsonHelper.getAsString((JsonObject)jsonObject, (String)"formatting", (String)"green");
                ChatFormatting formatting = ChatFormatting.getByName((String)formattingString);
                if (formatting == null) {
                    PaginatedAdvancementsClient.LOGGER.error("Formatting for frame '{}' is invalid: '{}'. Will use default 'green'", (Object)id, (Object)formattingString);
                    formatting = ChatFormatting.GREEN;
                }
                ResourceLocation textureObtained = ResourceLocation.fromNamespaceAndPath((String)identifier.getNamespace(), (String)("advancements/" + name + "_obtained"));
                ResourceLocation textureUnobtained = ResourceLocation.fromNamespaceAndPath((String)identifier.getNamespace(), (String)("advancements/" + name + "_unobtained"));
                PaginatedAdvancementFrame frame = new PaginatedAdvancementFrame(id, textureObtained, textureUnobtained, itemOffsetX, itemOffsetY, formatting);
                FRAMES.put(id, frame);
            }
        });
    }

    @Nullable
    public static PaginatedAdvancementFrame getFrameForAdvancement(ResourceLocation id) {
        return FRAMES.getOrDefault(id, null);
    }
}

