/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.paginatedadvancements.client;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.systems.RenderSystem;
import de.dafuqs.paginatedadvancements.PaginatedAdvancementsClient;
import de.dafuqs.paginatedadvancements.client.PaginatedAdvancementTab;
import de.dafuqs.paginatedadvancements.client.PaginatedAdvancementTabType;
import de.dafuqs.paginatedadvancements.client.PinnedAdvancementTabType;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementNode;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.advancements.AdvancementTab;
import net.minecraft.client.gui.screens.advancements.AdvancementWidget;
import net.minecraft.client.gui.screens.advancements.AdvancementsScreen;
import net.minecraft.client.multiplayer.ClientAdvancements;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PaginatedAdvancementScreen
extends AdvancementsScreen
implements ClientAdvancements.Listener {
    public static final ResourceLocation PAGINATION_TEXTURE = PaginatedAdvancementsClient.locate("textures/gui/buttons.png");
    public static final ResourceLocation WINDOW_TEXTURE = ResourceLocation.tryParse((String)"textures/gui/advancements/window.png");
    private static final Component SAD_LABEL_TEXT = Component.translatable((String)"advancements.sad_label");
    private static final Component EMPTY_TEXT = Component.translatable((String)"advancements.empty");
    private static final Component ADVANCEMENTS_TEXT = Component.translatable((String)"gui.advancements");
    private final ClientAdvancements advancementHandler;
    private final Map<AdvancementHolder, PaginatedAdvancementTab> tabs = Maps.newLinkedHashMap();
    private final Map<AdvancementHolder, PaginatedAdvancementTab> pinnedTabs = Maps.newLinkedHashMap();
    @Nullable
    private PaginatedAdvancementTab selectedTab;
    private boolean movingTab;
    private int currentPage = 0;
    public static final int ADDITIONAL_PADDING_TOP = 20;
    public static final int BORDER_PADDING = 32;
    public static final int ELEMENT_WIDTH = 15;
    public static final int TOP_ELEMENT_HEIGHT = 22;
    public static final int BOTTOM_ELEMENT_HEIGHT = 15;
    public static final int FAVOURITES_BUTTON_WIDTH = 18;
    public static final int FAVOURITES_BUTTON_HEIGHT = 18;
    public static final int FAVOURITES_BUTTON_OFFSET_X = 32;
    public static final int FAVOURITES_BUTTON_OFFSET_Y = 8;

    public PaginatedAdvancementScreen(ClientAdvancements advancementHandler) {
        super(advancementHandler);
        this.advancementHandler = advancementHandler;
    }

    protected void init() {
        super.init();
        this.tabs.clear();
        this.selectedTab = null;
        this.advancementHandler.setListener((ClientAdvancements.Listener)this);
        if (this.selectedTab == null && !this.tabs.isEmpty()) {
            boolean tabSelected = false;
            if (PaginatedAdvancementsClient.CONFIG.SaveLastSelectedTab && !PaginatedAdvancementsClient.CONFIG.LastSelectedTab.isEmpty()) {
                ResourceLocation savedTabResourceLocation = ResourceLocation.tryParse((String)PaginatedAdvancementsClient.CONFIG.LastSelectedTab);
                for (AdvancementTab advancementTab : this.tabs.values()) {
                    if (!advancementTab.getRootNode().holder().id().equals((Object)savedTabResourceLocation)) continue;
                    this.advancementHandler.setSelectedTab(advancementTab.getRootNode().holder(), true);
                    tabSelected = true;
                    break;
                }
            }
            if (!tabSelected) {
                this.advancementHandler.setSelectedTab(this.tabs.values().iterator().next().getRoot().holder(), true);
            }
        } else {
            this.advancementHandler.setSelectedTab(this.selectedTab == null ? null : this.selectedTab.getRoot().holder(), true);
        }
        if (!this.tabs.isEmpty() && PaginatedAdvancementsClient.hasPins()) {
            block1: for (String pinnedTabString : PaginatedAdvancementsClient.getPinnedTabs()) {
                ResourceLocation pinnedTabResourceLocation = ResourceLocation.tryParse((String)pinnedTabString);
                for (PaginatedAdvancementTab advancementTab : this.tabs.values()) {
                    if (!advancementTab.getRoot().holder().id().equals((Object)pinnedTabResourceLocation)) continue;
                    this.pinnedTabs.put(advancementTab.getRoot().holder(), advancementTab);
                    continue block1;
                }
            }
        }
    }

    public void removed() {
        super.removed();
    }

    public void drawWindow(GuiGraphics context, int mouseX, int mouseY, int minWidth, int minHeight, int maxWidth, int maxHeight) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)WINDOW_TEXTURE);
        this.drawFrame(context, minWidth, minHeight, maxWidth, maxHeight);
        context.drawString(this.getMinecraft().font, ADVANCEMENTS_TEXT, minWidth + 8, minHeight + 6, 0x404040, false);
    }

    public void drawPinButtonAndHeader(GuiGraphics context, int mouseX, int mouseY, int startX, int startY, int endX, int endY, boolean hasPins) {
        if (this.selectedTab != null && PaginatedAdvancementsClient.CONFIG.PinningEnabled) {
            if (this.isClickOnFavouritesButton(mouseX, mouseY, startY, endX)) {
                if (PaginatedAdvancementsClient.isPinned(this.selectedTab.getRoot().holder().id())) {
                    context.blit(PAGINATION_TEXTURE, endX - 32, startY + 8, 18.0f, 64.0f, 18, 18, 256, 256);
                } else {
                    context.blit(PAGINATION_TEXTURE, endX - 32, startY + 8, 0.0f, 64.0f, 18, 18, 256, 256);
                }
            } else if (PaginatedAdvancementsClient.isPinned(this.selectedTab.getRoot().holder().id())) {
                context.blit(PAGINATION_TEXTURE, endX - 32, startY + 8, 18.0f, 46.0f, 18, 18, 256, 256);
            } else {
                context.blit(PAGINATION_TEXTURE, endX - 32, startY + 8, 0.0f, 46.0f, 18, 18, 256, 256);
            }
            if (hasPins) {
                context.blit(PAGINATION_TEXTURE, endX + PinnedAdvancementTabType.getTabX() + 1, startY + 6, 46.0f, 0.0f, 32, 15, 256, 256);
            }
        }
    }

    public boolean isClickOnFavouritesButton(double mouseX, double mouseY, int minHeight, int maxWidth) {
        return PaginatedAdvancementsClient.CONFIG.PinningEnabled && mouseX > (double)(maxWidth - 32) && mouseX < (double)(maxWidth - 32 + 18) && mouseY > (double)(minHeight + 8) && mouseY < (double)(minHeight + 8 + 18);
    }

    public int getMaxPaginatedTabsToRender(int startX, int endXTitle, int endXWindow, boolean paginated) {
        if (paginated) {
            int usableWidth = endXTitle - startX;
            return (usableWidth - 58) / PaginatedAdvancementTabType.getWidthWithSpacing();
        }
        int usableWidth = endXWindow - startX;
        return (usableWidth - 28) / PaginatedAdvancementTabType.getWidthWithSpacing();
    }

    public int getMaxPinnedTabsToRender(int startY, int endY) {
        int usableHeight = endY - startY;
        return (usableHeight - 56 + PaginatedAdvancementTabType.getWidthWithSpacing()) / PinnedAdvancementTabType.getHeightWithSpacing();
    }

    private boolean isPaginated(int startX, int endXWindow) {
        if (this.tabs.size() < 3) {
            return false;
        }
        return endXWindow - startX < this.tabs.size() * PaginatedAdvancementTabType.getWidthWithSpacing();
    }

    private void renderPaginatedTabs(GuiGraphics context, int startX, int startY, int endXTitle, int endXWindow, boolean paginated) {
        int displayedPosition;
        Iterator<PaginatedAdvancementTab> tabIterator = this.tabs.values().iterator();
        int maxAdvancementTabsToRender = this.getMaxPaginatedTabsToRender(startX, endXTitle, endXWindow, paginated);
        int index = 0;
        while (tabIterator.hasNext()) {
            PaginatedAdvancementTab advancementTab = tabIterator.next();
            if (paginated) {
                if (advancementTab.getPaginatedDisplayedPage(maxAdvancementTabsToRender) != this.currentPage) continue;
                displayedPosition = advancementTab.getPaginatedDisplayedPosition(maxAdvancementTabsToRender, this.currentPage);
                advancementTab.drawBackground(context, startX, startY, advancementTab == this.selectedTab, displayedPosition);
                continue;
            }
            advancementTab.drawBackground(context, startX, startY, advancementTab == this.selectedTab, index);
            ++index;
        }
        RenderSystem.defaultBlendFunc();
        index = 0;
        for (PaginatedAdvancementTab advancementTab : this.tabs.values()) {
            if (paginated) {
                if (advancementTab.getPaginatedDisplayedPage(maxAdvancementTabsToRender) != this.currentPage) continue;
                displayedPosition = advancementTab.getPaginatedDisplayedPosition(maxAdvancementTabsToRender, this.currentPage);
                advancementTab.drawIcon(context, startX, startY, displayedPosition);
                continue;
            }
            advancementTab.drawIcon(context, startX, startY, index);
            ++index;
        }
        RenderSystem.disableBlend();
    }

    private void renderPinnedTabs(GuiGraphics context, int startX, int startY, int endX, int endY) {
        int maxPinnedTabs = this.getMaxPinnedTabsToRender(startY, endY);
        for (PaginatedAdvancementTab advancementTab : this.pinnedTabs.values()) {
            advancementTab.drawPinnedBackground(context, endX, startY, advancementTab == this.selectedTab, maxPinnedTabs);
        }
        RenderSystem.defaultBlendFunc();
        for (PaginatedAdvancementTab advancementTab : this.pinnedTabs.values()) {
            advancementTab.drawPinnedIcon(context, endX, startY, maxPinnedTabs);
        }
        RenderSystem.disableBlend();
    }

    public void drawPaginationButtons(GuiGraphics context, int mouseX, int mouseY, int startX, int endX) {
        if (PaginatedAdvancementScreen.isClickOnBackTab(mouseX, mouseY, startX, endX)) {
            context.blit(PAGINATION_TEXTURE, startX + 4, 27, 0.0f, 23.0f, 23, 23, 256, 256);
        } else {
            context.blit(PAGINATION_TEXTURE, startX + 4, 27, 0.0f, 0.0f, 23, 23, 256, 256);
        }
        if (PaginatedAdvancementScreen.isClickOnForwardTab(mouseX, mouseY, startX, endX)) {
            context.blit(PAGINATION_TEXTURE, endX - startX + 4, 27, 23.0f, 23.0f, 23, 23, 256, 256);
        } else {
            context.blit(PAGINATION_TEXTURE, endX - startX + 4, 27, 23.0f, 0.0f, 23, 23, 256, 256);
        }
    }

    public static boolean isClickOnBackTab(double mouseX, double mouseY, int startX, int enX) {
        int buttonStartX = startX + 4;
        int buttonStartY = 27;
        return mouseX > (double)buttonStartX && mouseX < (double)(buttonStartX + 23) && mouseY > (double)buttonStartY && mouseY < (double)(buttonStartY + 23);
    }

    public static boolean isClickOnForwardTab(double mouseX, double mouseY, int startX, int endX) {
        int buttonStartX = endX - startX + 4;
        int buttonStartY = 27;
        return mouseX > (double)buttonStartX && mouseX < (double)(buttonStartX + 23) && mouseY > (double)buttonStartY && mouseY < (double)(buttonStartY + 23);
    }

    private void drawFrame(GuiGraphics context, int startX, int startY, int endX, int endY) {
        context.blit(WINDOW_TEXTURE, startX, startY, 0.0f, 0.0f, 15, 22, 256, 256);
        context.blit(WINDOW_TEXTURE, endX - 15, startY, 237.0f, 0.0f, 15, 22, 256, 256);
        context.blit(WINDOW_TEXTURE, startX, endY - 15, 0.0f, 125.0f, 15, 15, 256, 256);
        context.blit(WINDOW_TEXTURE, endX - 15, endY - 15, 237.0f, 125.0f, 15, 15, 256, 256);
        int maxTopHeightInOneDrawCall = 100;
        int middleHeight = endY - startY - 22 - 15;
        int currentY = startY + 22;
        while (middleHeight > 0) {
            int currentDrawHeight = Math.min(middleHeight, maxTopHeightInOneDrawCall);
            context.blit(WINDOW_TEXTURE, startX, currentY, 0.0f, 22.0f, 15, currentDrawHeight, 256, 256);
            context.blit(WINDOW_TEXTURE, endX - 15, currentY, 237.0f, 22.0f, 15, currentDrawHeight, 256, 256);
            middleHeight -= currentDrawHeight;
            currentY += currentDrawHeight;
        }
        int maxTopWidthInOneDrawCall = 220;
        int middleWidth = endX - startX - 15 - 15;
        int currentX = startX + 15;
        while (middleWidth > 0) {
            int currentDrawWidth = Math.min(middleWidth, maxTopWidthInOneDrawCall);
            context.blit(WINDOW_TEXTURE, currentX, startY, 15.0f, 0.0f, currentDrawWidth, 22, 256, 256);
            context.blit(WINDOW_TEXTURE, currentX, endY - 15, 15.0f, 125.0f, currentDrawWidth, 15, 256, 256);
            middleWidth -= currentDrawWidth;
            currentX += currentDrawWidth;
        }
    }

    public void onAddAdvancementRoot(AdvancementNode root) {
        int pinnedIndex = PaginatedAdvancementsClient.getPinIndex(root.holder().id());
        PaginatedAdvancementTab advancementTab = PaginatedAdvancementTab.create(this.getMinecraft(), this, this.tabs.size(), pinnedIndex, root);
        if (advancementTab != null) {
            this.tabs.put(root.holder(), advancementTab);
            if (PaginatedAdvancementsClient.isPinned(root.holder().id())) {
                this.pinnedTabs.put(root.holder(), advancementTab);
            }
        }
    }

    public void onRemoveAdvancementRoot(@NotNull AdvancementNode root) {
    }

    public void onAddAdvancementTask(@NotNull AdvancementNode dependent) {
        PaginatedAdvancementTab advancementTab = this.getTab(dependent);
        if (advancementTab != null) {
            advancementTab.addAdvancement(dependent);
        }
    }

    public void onRemoveAdvancementTask(@NotNull AdvancementNode dependent) {
    }

    @Nullable
    private PaginatedAdvancementTab getTab(AdvancementNode advancement) {
        AdvancementNode placedAdvancement = advancement.root();
        return this.tabs.get(placedAdvancement.holder());
    }

    public void onAdvancementsCleared() {
        this.tabs.clear();
        this.pinnedTabs.clear();
        this.selectedTab = null;
    }

    public void onSelectedTabChanged(@Nullable AdvancementHolder advancement) {
        this.selectedTab = this.tabs.get(advancement);
        if (this.selectedTab != null) {
            PaginatedAdvancementsClient.saveSelectedTab(this.selectedTab.getRoot().holder().id());
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (button == 0) {
            int startX = 32;
            int endXWindow = !this.pinnedTabs.isEmpty() ? this.width - 32 - 32 : this.width - 32;
            int endXTitle = this.width - 32;
            int startY = 52;
            int endY = this.height - 32;
            boolean isPaginated = this.isPaginated(startX, endXWindow);
            if (this.selectedTab != null && this.isClickOnFavouritesButton(mouseX, mouseY, startY, endXWindow)) {
                ResourceLocation pageResourceLocation = this.selectedTab.getRoot().holder().id();
                if (PaginatedAdvancementsClient.isPinned(pageResourceLocation)) {
                    this.unpinTab(pageResourceLocation);
                } else {
                    this.pinTab(pageResourceLocation);
                }
            }
            if (isPaginated) {
                if (PaginatedAdvancementScreen.isClickOnBackTab(mouseX, mouseY, startX, endXTitle)) {
                    this.pageBackward(startX, endXTitle, endXWindow);
                } else if (PaginatedAdvancementScreen.isClickOnForwardTab(mouseX, mouseY, startX, endXTitle)) {
                    this.pageForward(startX, endXTitle, endXWindow);
                }
            }
            int maxDisplayedTabs = this.getMaxPaginatedTabsToRender(startX, endXTitle, endXWindow, isPaginated);
            for (PaginatedAdvancementTab paginatedAdvancementTab : this.tabs.values()) {
                if (!paginatedAdvancementTab.isClickOnTab(32, 52, mouseX, mouseY, isPaginated, maxDisplayedTabs, this.currentPage)) continue;
                this.advancementHandler.setSelectedTab(paginatedAdvancementTab.getRoot().holder(), true);
                break;
            }
            if (!this.pinnedTabs.isEmpty()) {
                int maxPinnedTabs = this.getMaxPinnedTabsToRender(startY, endY);
                for (PaginatedAdvancementTab paginatedAdvancementTab : this.pinnedTabs.values()) {
                    if (!paginatedAdvancementTab.isClickOnPinnedTab(endXWindow, startY, mouseX, mouseY, maxPinnedTabs)) continue;
                    this.advancementHandler.setSelectedTab(paginatedAdvancementTab.getRoot().holder(), true);
                }
            }
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    private void pinTab(ResourceLocation pageResourceLocation) {
        this.selectedTab.setPinIndex(this.pinnedTabs.size());
        this.pinnedTabs.put(this.selectedTab.getRoot().holder(), this.selectedTab);
        PaginatedAdvancementsClient.pinTab(pageResourceLocation);
    }

    private void unpinTab(ResourceLocation pageResourceLocation) {
        int oldPinIndex = this.selectedTab.getPinIndex();
        this.selectedTab.setPinIndex(-1);
        this.pinnedTabs.remove(this.selectedTab.getRoot().holder());
        PaginatedAdvancementsClient.unpinTab(pageResourceLocation);
        for (PaginatedAdvancementTab tab : this.pinnedTabs.values()) {
            int currentPinIndex = tab.getPinIndex();
            if (currentPinIndex <= oldPinIndex) continue;
            tab.setPinIndex(currentPinIndex - 1);
        }
    }

    public int getMaxPageIndex(int startX, int endXTitle, int endXWindow) {
        int maxDisplayedTabsPerPage = this.getMaxPaginatedTabsToRender(startX, endXTitle, endXWindow, true);
        return (this.tabs.size() - 1) / maxDisplayedTabsPerPage;
    }

    public void clampCurrentPage(int startX, int endXTitle, int endXWindow) {
        this.currentPage = Math.min(this.currentPage, this.getMaxPageIndex(startX, endXTitle, endXWindow));
    }

    public void pageForward(int startX, int endXTitle, int endXWindow) {
        ++this.currentPage;
        this.currentPage %= this.getMaxPageIndex(startX, endXTitle, endXWindow) + 1;
    }

    public void pageBackward(int startX, int endXTitle, int endXWindow) {
        int maxPageIndex = this.getMaxPageIndex(startX, endXTitle, endXWindow);
        this.currentPage = this.currentPage == 0 ? maxPageIndex : --this.currentPage;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.getMinecraft().options.keyAdvancements.matches(keyCode, scanCode)) {
            this.getMinecraft().setScreen(null);
            this.getMinecraft().mouseHandler.grabMouse();
            return true;
        }
        if (this.selectedTab != null && keyCode == 67 && modifiers == 2) {
            this.selectedTab.copyHoveredAdvancementID();
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        if (this.selectedTab != null) {
            return this.selectedTab.scrollDebug(-((int)verticalAmount));
        }
        return false;
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (button != 0) {
            this.movingTab = false;
            return false;
        }
        if (!this.movingTab) {
            this.movingTab = true;
        } else if (this.selectedTab != null) {
            int endX = !this.pinnedTabs.isEmpty() ? this.width - 32 - 32 - 4 : this.width - 32;
            int endY = this.height - 32;
            this.selectedTab.move(deltaX, deltaY, endX - 60 + 5, endY - 84);
        }
        return true;
    }

    private void drawWidgetTooltip(GuiGraphics context, int mouseX, int mouseY, int startX, int startY, int endXTitle, int endXWindow, int endY) {
        if (this.selectedTab != null) {
            context.pose().pushPose();
            context.pose().translate((double)(startX + 9), (double)(startY + 18), 400.0);
            this.selectedTab.drawWidgetTooltip(context, mouseX - startX - 9, mouseY - startY - 18, startX, startY, endXWindow, endY);
            context.pose().translate(0.0, 0.0, 400.0);
            if (PaginatedAdvancementsClient.CONFIG.shouldShowAdvancementDebug(this.getMinecraft())) {
                this.selectedTab.drawDebugInfo(context, startX, startY, endXWindow, endY);
            }
            context.pose().popPose();
        }
        if (this.tabs.size() > 1) {
            boolean isPaginated = this.isPaginated(startX, endXWindow);
            int maxDisplayedTabs = this.getMaxPaginatedTabsToRender(startX, endXTitle, endXWindow, isPaginated);
            for (PaginatedAdvancementTab paginatedAdvancementTab : this.tabs.values()) {
                if (!paginatedAdvancementTab.isClickOnTab(startX, startY, mouseX, mouseY, isPaginated, maxDisplayedTabs, this.currentPage)) continue;
                context.renderTooltip(this.font, paginatedAdvancementTab.getTitle(), mouseX, mouseY);
            }
        }
        if (!this.pinnedTabs.isEmpty()) {
            int maxPinnedTabs = this.getMaxPinnedTabsToRender(startY, endY);
            for (PaginatedAdvancementTab paginatedAdvancementTab : this.pinnedTabs.values()) {
                if (!paginatedAdvancementTab.isClickOnPinnedTab(endXWindow, startY, mouseX, mouseY, maxPinnedTabs)) continue;
                context.renderTooltip(this.font, paginatedAdvancementTab.getTitle(), mouseX, mouseY);
            }
        }
    }

    public void render(@NotNull GuiGraphics context, int mouseX, int mouseY, float delta) {
        boolean hasPins = !this.pinnedTabs.isEmpty();
        int startX = 32;
        int startY = 52;
        int endXWindow = hasPins ? this.width - 32 - 32 : this.width - 32;
        int endXTitle = this.width - 32;
        int endY = this.height - 32;
        this.clampCurrentPage(startX, endXTitle, endXWindow);
        this.renderBackground(context, mouseX, mouseY, delta);
        this.drawAdvancementTree(context, startX, startY, endXWindow, endY);
        this.drawWindow(context, mouseX, mouseY, startX, startY, endXWindow, endY);
        if (this.tabs.size() > 1) {
            if (this.isPaginated(startX, endXWindow)) {
                this.drawPaginationButtons(context, mouseX, mouseY, startX, endXTitle);
                this.renderPaginatedTabs(context, startX, startY, endXTitle, endXWindow, true);
            } else {
                this.renderPaginatedTabs(context, startX, startY, endXTitle, endXWindow, false);
            }
        }
        if (hasPins) {
            this.renderPinnedTabs(context, startX, startY, endXWindow, endY);
        }
        this.drawPinButtonAndHeader(context, mouseX, mouseY, startX, startY, endXWindow, endY, hasPins);
        this.drawWidgetTooltip(context, mouseX, mouseY, startX, startY, endXTitle, endXWindow, endY);
    }

    private void drawAdvancementTree(GuiGraphics context, int startX, int startY, int endX, int endY) {
        PaginatedAdvancementTab advancementTab = this.selectedTab;
        if (advancementTab == null) {
            context.fill(startX + 9, startY + 18, endX, endY, -16777216);
            int textCenterX = startX + (endX - startX) / 2;
            int textY = startY + (endY - startY) / 2;
            context.drawCenteredString(this.font, EMPTY_TEXT, textCenterX, textY, -1);
            context.drawCenteredString(this.font, SAD_LABEL_TEXT, textCenterX, textY + 16, -1);
        } else {
            advancementTab.render(context, startX, startY, endX, endY);
        }
    }

    @Nullable
    public AdvancementWidget getAdvancementWidget(@NotNull AdvancementNode advancement) {
        PaginatedAdvancementTab advancementTab = this.getTab(advancement);
        return advancementTab == null ? null : advancementTab.getWidget(advancement.holder());
    }
}

