/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.paginatedadvancements.client;

import com.google.common.collect.Maps;
import de.dafuqs.paginatedadvancements.PaginatedAdvancementsClient;
import de.dafuqs.paginatedadvancements.client.PaginatedAdvancementScreen;
import de.dafuqs.paginatedadvancements.client.PaginatedAdvancementTabType;
import de.dafuqs.paginatedadvancements.client.PaginatedAdvancementWidget;
import de.dafuqs.paginatedadvancements.client.PinnedAdvancementTabType;
import de.dafuqs.paginatedadvancements.mixin.AdvancementWidgetAccessor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementNode;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.advancements.DisplayInfo;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.advancements.AdvancementTab;
import net.minecraft.client.gui.screens.advancements.AdvancementTabType;
import net.minecraft.client.gui.screens.advancements.AdvancementWidget;
import net.minecraft.client.gui.screens.advancements.AdvancementsScreen;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PaginatedAdvancementTab
extends AdvancementTab {
    private final Minecraft client;
    private final PaginatedAdvancementScreen screen;
    private final int index;
    private int pinnedIndex;
    private final AdvancementNode root;
    private final DisplayInfo display;
    private final ItemStack icon;
    private final Component title;
    private final AdvancementWidget rootWidget;
    private final Map<AdvancementHolder, AdvancementWidget> widgets = Maps.newLinkedHashMap();
    private double originX;
    private double originY;
    private int minPanX = Integer.MAX_VALUE;
    private int minPanY = Integer.MAX_VALUE;
    private int maxPanX = Integer.MIN_VALUE;
    private int maxPanY = Integer.MIN_VALUE;
    private float alpha;
    private boolean initialized;
    @Nullable
    private AdvancementWidget hoveredWidget;

    public PaginatedAdvancementTab(Minecraft client, PaginatedAdvancementScreen screen, int index, int pinnedIndex, AdvancementNode root, DisplayInfo display) {
        super(client, (AdvancementsScreen)screen, AdvancementTabType.ABOVE, index, root, display);
        this.client = client;
        this.screen = screen;
        this.index = index;
        this.pinnedIndex = pinnedIndex;
        this.root = root;
        this.display = display;
        this.icon = display.getIcon();
        this.title = display.getTitle();
        this.rootWidget = new PaginatedAdvancementWidget(this, client, root, display);
        this.addWidget(this.rootWidget, root.holder());
    }

    @NotNull
    public AdvancementTabType getType() {
        return AdvancementTabType.ABOVE;
    }

    public int getIndex() {
        return this.index;
    }

    public AdvancementNode getRoot() {
        return this.root;
    }

    @NotNull
    public Component getTitle() {
        return this.title;
    }

    @NotNull
    public DisplayInfo getDisplay() {
        return this.display;
    }

    public void drawBackground(GuiGraphics context, int x, int y, boolean selected, int atIndex) {
        PaginatedAdvancementTabType.drawBackground(context, x, y, selected, atIndex);
    }

    public void drawIcon(GuiGraphics context, int x, int y, int index) {
        PaginatedAdvancementTabType.drawIcon(context, x, y, index, this.icon);
    }

    public void drawPinnedBackground(GuiGraphics context, int x, int y, boolean selected, int maxPinnedIndex) {
        if (this.pinnedIndex <= maxPinnedIndex) {
            PinnedAdvancementTabType.drawBackground(context, x, y, selected, this.pinnedIndex);
        }
    }

    public void drawPinnedIcon(GuiGraphics context, int x, int y, int maxPinnedIndex) {
        if (this.pinnedIndex <= maxPinnedIndex) {
            PinnedAdvancementTabType.drawIcon(context, x, y, this.pinnedIndex, this.icon);
        }
    }

    public void render(GuiGraphics context, int startX, int startY, int endX, int endY) {
        int advancementTreeWindowWidth = endX - (startX += 9) + 32;
        int advancementTreeWindowHeight = endY - (startY += 18) + 61;
        if (!this.initialized) {
            this.originX = (double)(advancementTreeWindowWidth / 2 - (this.maxPanX + this.minPanX) / 2) - 22.0;
            this.originY = (double)(advancementTreeWindowHeight / 2 - (this.maxPanY + this.minPanY) / 2) - 32.0;
            this.initialized = true;
        }
        context.enableScissor(startX, startY, advancementTreeWindowWidth, advancementTreeWindowHeight);
        context.pose().pushPose();
        context.pose().translate((float)startX, (float)startY, 0.0f);
        ResourceLocation identifier = this.display.getBackground().orElse(TextureManager.INTENTIONAL_MISSING_TEXTURE);
        int i = Mth.floor((double)this.originX);
        int j = Mth.floor((double)this.originY);
        int k = i % 16;
        int l = j % 16;
        int textureCountX = advancementTreeWindowWidth / 16 + 1;
        int textureCountY = advancementTreeWindowHeight / 16 + 2;
        for (int m = -1; m < textureCountX; ++m) {
            for (int n = -1; n < textureCountY; ++n) {
                context.blit(identifier, k + 16 * m, l + 16 * n, 0.0f, 0.0f, 16, 16, 16, 16);
            }
        }
        this.rootWidget.drawConnectivity(context, i, j, true);
        this.rootWidget.drawConnectivity(context, i, j, false);
        this.rootWidget.draw(context, i, j);
        context.pose().popPose();
        context.disableScissor();
    }

    public void drawWidgetTooltip(GuiGraphics context, int mouseX, int mouseY, int startX, int startY, int endXWindow, int endY) {
        context.pose().pushPose();
        context.pose().translate(0.0f, 0.0f, -200.0f);
        if (PaginatedAdvancementsClient.CONFIG.FadeOutBackgroundOnAdvancementHover) {
            context.fill(0, 0, endXWindow - startX - 18, endY - startY - 26, Mth.floor((float)(this.alpha * 255.0f)) << 24);
        }
        boolean hoversWidget = false;
        int i = Mth.floor((double)this.originX);
        int j = Mth.floor((double)this.originY);
        if (mouseX > 0 && mouseX < endXWindow - startX - 10 && mouseY > 0 && mouseY < endY - startY) {
            for (AdvancementWidget advancementWidget : this.widgets.values()) {
                if (!advancementWidget.isMouseOver(i, j, mouseX, mouseY)) continue;
                hoversWidget = true;
                advancementWidget.drawHover(context, i, j, this.alpha, startX, startY);
                this.hoveredWidget = advancementWidget;
                break;
            }
        }
        context.pose().popPose();
        if (hoversWidget) {
            this.alpha = Mth.clamp((float)(this.alpha + 0.02f), (float)0.0f, (float)0.3f);
        } else {
            this.hoveredWidget = null;
            this.alpha = Mth.clamp((float)(this.alpha - 0.04f), (float)0.0f, (float)1.0f);
        }
    }

    public void drawDebugInfo(GuiGraphics context, int startX, int startY, int endX, int endY) {
        if (this.hoveredWidget != null) {
            int displayedRequirementLines;
            AdvancementWidgetAccessor advancementWidgetAccessor = (AdvancementWidgetAccessor)this.hoveredWidget;
            AdvancementProgress progress = advancementWidgetAccessor.getProgress();
            endY -= 60;
            startY -= 72;
            List<MutableComponent> requirements = this.getRequirements(startX -= 36, (endX -= 46) - 10, advancementWidgetAccessor.getAdvancement().advancement(), progress);
            boolean overflow = false;
            if (!PaginatedAdvancementScreen.hasShiftDown()) {
                overflow = requirements.size() > PaginatedAdvancementsClient.CONFIG.MaxCriterionEntries;
                displayedRequirementLines = Math.min(requirements.size(), PaginatedAdvancementsClient.CONFIG.MaxCriterionEntries);
            } else {
                displayedRequirementLines = requirements.size();
            }
            startY = Math.max(startY, endY - Math.max(18, 8 + 10 * displayedRequirementLines) - (PaginatedAdvancementsClient.CONFIG.ShowAdvancementIDInDebugTooltip ? 10 : 0));
            this.drawDebugFrame(context, startX, startY, endX, endY);
            int requirementY = startY + 15;
            if (PaginatedAdvancementsClient.CONFIG.ShowAdvancementIDInDebugTooltip) {
                MutableComponent idText = Component.literal((String)("ID: " + advancementWidgetAccessor.getAdvancement().holder().id() + " ")).append((Component)Component.translatable((String)"text.paginated_advancements.copy_to_clipboard"));
                context.drawString(this.client.font, (Component)idText, startX + 5, startY + 5, 0xFFFFFF, true);
            } else {
                requirementY = startY + 5;
            }
            if (overflow) {
                this.drawRequirementsWithOverflow(context, startX + 5, requirementY, endX - 5, endY, requirements, displayedRequirementLines);
            } else {
                this.drawRequirements(context, startX + 5, requirementY, endX - 5, endY, requirements);
            }
        }
    }

    private List<MutableComponent> getRequirements(int startX, int endX, Advancement advancement, AdvancementProgress progress) {
        Iterable obtainedCriteria = progress == null ? List.of() : progress.getCompletedCriteria();
        List requirements = advancement.requirements().requirements();
        ArrayList<MutableComponent> requirementsDone = new ArrayList<MutableComponent>();
        ArrayList requirementsLeft = new ArrayList();
        for (List requirementGroup : requirements) {
            ArrayList<MutableComponent> lines = new ArrayList<MutableComponent>();
            lines.add(Component.translatable((String)"text.paginated_advancements.group").withStyle(ChatFormatting.DARK_RED));
            boolean anyDone = false;
            for (String requirementString : requirementGroup) {
                int newWidth;
                ChatFormatting formatting = ChatFormatting.DARK_RED;
                for (String s : obtainedCriteria) {
                    if (!s.equals(requirementString)) continue;
                    formatting = ChatFormatting.DARK_GREEN;
                    anyDone = true;
                    break;
                }
                if ((newWidth = this.client.font.width((FormattedText)lines.get(lines.size() - 1)) + this.client.font.width(requirementString)) > endX - startX) {
                    Object indent = "";
                    while (this.client.font.width((String)indent) < this.client.font.width((FormattedText)Component.translatable((String)"text.paginated_advancements.group"))) {
                        indent = (String)indent + " ";
                    }
                    lines.add(Component.literal((String)indent).withStyle(ChatFormatting.DARK_RED));
                }
                ((MutableComponent)lines.get(lines.size() - 1)).append((Component)Component.literal((String)(requirementString + " ")).withStyle(formatting));
            }
            if (anyDone) {
                for (MutableComponent line : lines) {
                    line.withStyle(ChatFormatting.DARK_GREEN);
                    requirementsDone.add(line);
                }
                continue;
            }
            requirementsLeft.addAll(lines);
        }
        ArrayList<MutableComponent> combined = new ArrayList<MutableComponent>();
        combined.addAll(requirementsLeft);
        combined.addAll(requirementsDone);
        return combined;
    }

    protected void drawDebugFrame(GuiGraphics context, int startX, int startY, int endX, int endY) {
        context.pose().pushPose();
        int TOP_ELEMENT_HEIGHT = 15;
        context.blit(PaginatedAdvancementScreen.WINDOW_TEXTURE, startX, startY, 0.0f, 0.0f, 15, TOP_ELEMENT_HEIGHT, 256, 256);
        context.blit(PaginatedAdvancementScreen.WINDOW_TEXTURE, endX - 15, startY, 237.0f, 0.0f, 15, TOP_ELEMENT_HEIGHT, 256, 256);
        context.blit(PaginatedAdvancementScreen.WINDOW_TEXTURE, startX, endY - 15, 0.0f, 125.0f, 15, 15, 256, 256);
        context.blit(PaginatedAdvancementScreen.WINDOW_TEXTURE, endX - 15, endY - 15, 237.0f, 125.0f, 15, 15, 256, 256);
        int maxTopHeightInOneDrawCall = 100;
        int middleHeight = endY - startY - TOP_ELEMENT_HEIGHT - 15;
        int currentY = startY + TOP_ELEMENT_HEIGHT;
        while (middleHeight > 0) {
            int currentDrawHeight = Math.min(middleHeight, maxTopHeightInOneDrawCall);
            context.blit(PaginatedAdvancementScreen.WINDOW_TEXTURE, startX, currentY, 0.0f, (float)TOP_ELEMENT_HEIGHT, 15, currentDrawHeight, 256, 256);
            context.blit(PaginatedAdvancementScreen.WINDOW_TEXTURE, endX - 15, currentY, 237.0f, (float)TOP_ELEMENT_HEIGHT, 15, currentDrawHeight, 256, 256);
            middleHeight -= currentDrawHeight;
            currentY += currentDrawHeight;
        }
        int maxTopWidthInOneDrawCall = 220;
        int middleWidth = endX - startX - 15 - 15;
        int currentX = startX + 15;
        while (middleWidth > 0) {
            int currentDrawWidth = Math.min(middleWidth, maxTopWidthInOneDrawCall);
            context.blit(PaginatedAdvancementScreen.WINDOW_TEXTURE, currentX, startY, 15.0f, 0.0f, currentDrawWidth, TOP_ELEMENT_HEIGHT, 256, 256);
            context.blit(PaginatedAdvancementScreen.WINDOW_TEXTURE, currentX, endY - 15, 15.0f, 125.0f, currentDrawWidth, 15, 256, 256);
            middleWidth -= currentDrawWidth;
            currentX += currentDrawWidth;
        }
        int centerStartX = startX + 6;
        int centerEndX = endX - 6;
        int centerStartY = startY + 3;
        int centerEndY = endY - 6;
        int drawStartY = centerStartY;
        int drawHeight = centerEndY - centerStartY;
        while (drawHeight > 0) {
            int drawStartX = centerStartX;
            int currentHeight = Math.min(drawHeight, 10);
            int drawWidth = centerEndX - centerStartX;
            while (drawWidth > 0) {
                int currentWidth = Math.min(200, drawWidth);
                context.blit(PaginatedAdvancementScreen.WINDOW_TEXTURE, drawStartX, drawStartY, 4.0f, 4.0f, currentWidth, currentHeight, 256, 256);
                drawWidth -= currentWidth;
                drawStartX += currentWidth;
            }
            drawHeight -= currentHeight;
            drawStartY += currentHeight;
        }
        context.pose().popPose();
    }

    protected void drawRequirementsWithOverflow(GuiGraphics context, int startX, int startY, int endX, int endY, List<MutableComponent> requirements, int lines) {
        for (int i = 0; i < lines; ++i) {
            if (i == lines - 1) {
                context.drawString(this.client.font, (Component)Component.translatable((String)"text.paginated_advancements.expand_debug"), startX, startY, 0x999999, false);
            } else {
                context.drawString(this.client.font, (Component)requirements.get(i), startX, startY, 65280, false);
            }
            startY += 10;
        }
    }

    protected void drawRequirements(GuiGraphics context, int startX, int startY, int endX, int endY, List<MutableComponent> requirements) {
        int scrollAmount = 0;
        assert (this.hoveredWidget != null);
        AdvancementWidget advancementWidget = this.hoveredWidget;
        if (advancementWidget instanceof PaginatedAdvancementWidget) {
            PaginatedAdvancementWidget paginatedAdvancementWidget = (PaginatedAdvancementWidget)advancementWidget;
            scrollAmount = paginatedAdvancementWidget.getDebugScrollAmount();
            int maxLines = (endY - startY) / 10;
            scrollAmount = Math.max(0, Math.min(requirements.size() - maxLines, scrollAmount));
            paginatedAdvancementWidget.setDebugScrollAmount(scrollAmount);
        }
        if (scrollAmount > 0) {
            context.drawString(this.client.font, (Component)Component.translatable((String)"text.paginated_advancements.scroll_debug"), startX, startY, 0x999999, false);
            ++scrollAmount;
            startY += 10;
        }
        for (int i = scrollAmount; i < requirements.size() && startY + 10 < endY; ++i) {
            if (startY + 20 >= endY && i + 1 != requirements.size()) {
                context.drawString(this.client.font, (Component)Component.translatable((String)"text.paginated_advancements.scroll_debug"), startX, startY, 0x999999, false);
                break;
            }
            context.drawString(this.client.font, (Component)requirements.get(i), startX, startY, 65280, false);
            startY += 10;
        }
    }

    public boolean scrollDebug(int diff) {
        AdvancementWidget advancementWidget;
        if (this.hoveredWidget != null && (advancementWidget = this.hoveredWidget) instanceof PaginatedAdvancementWidget) {
            PaginatedAdvancementWidget paginatedAdvancementWidget = (PaginatedAdvancementWidget)advancementWidget;
            int value = paginatedAdvancementWidget.getDebugScrollAmount();
            paginatedAdvancementWidget.setDebugScrollAmount(value + diff);
            return true;
        }
        return false;
    }

    public int getPaginatedDisplayedPage(int maxDisplayedTabs) {
        return this.index / maxDisplayedTabs;
    }

    public int getPaginatedDisplayedPosition(int maxDisplayedTabs, int currentPage) {
        return 1 + this.index - maxDisplayedTabs * currentPage;
    }

    public boolean isClickOnTab(int screenX, int screenY, double mouseX, double mouseY, boolean paginated, int maxDisplayedTabs, int currentPage) {
        if (paginated) {
            if (this.getPaginatedDisplayedPage(maxDisplayedTabs) != currentPage) {
                return false;
            }
            int pageIndex = this.getPaginatedDisplayedPosition(maxDisplayedTabs, currentPage);
            if (pageIndex <= maxDisplayedTabs) {
                return PaginatedAdvancementTabType.isClickOnTab(screenX, screenY, pageIndex, mouseX, mouseY);
            }
        } else {
            return PaginatedAdvancementTabType.isClickOnTab(screenX, screenY, this.index, mouseX, mouseY);
        }
        return false;
    }

    public boolean isClickOnPinnedTab(int screenX, int screenY, double mouseX, double mouseY, int maxPinnedTabs) {
        if (this.pinnedIndex > -1 && this.pinnedIndex <= maxPinnedTabs) {
            return PinnedAdvancementTabType.isClickOnTab(screenX, screenY, this.pinnedIndex, mouseX, mouseY);
        }
        return false;
    }

    @Nullable
    public static PaginatedAdvancementTab create(Minecraft client, PaginatedAdvancementScreen screen, int index, int pinnedIndex, AdvancementNode root) {
        if (root.advancement().display().isPresent()) {
            return new PaginatedAdvancementTab(client, screen, index, pinnedIndex, root, (DisplayInfo)root.advancement().display().get());
        }
        return null;
    }

    public void move(double offsetX, double offsetY, int endX, int endY) {
        if (this.maxPanX - this.minPanX > endX) {
            this.originX = Mth.clamp((double)(this.originX + offsetX), (double)(-(this.maxPanX - endX)), (double)0.0);
        }
        if (this.maxPanY - this.minPanY > endY) {
            this.originY = Mth.clamp((double)(this.originY + offsetY), (double)(-(this.maxPanY - endY)), (double)0.0);
        }
    }

    public void addAdvancement(AdvancementNode advancement) {
        Optional optional = advancement.advancement().display();
        if (optional.isPresent()) {
            PaginatedAdvancementWidget advancementWidget = new PaginatedAdvancementWidget(this, this.client, advancement, (DisplayInfo)optional.get());
            this.addWidget(advancementWidget, advancement.holder());
        }
    }

    private void addWidget(AdvancementWidget widget, AdvancementHolder advancement) {
        this.widgets.put(advancement, widget);
        for (AdvancementWidget advancementWidget : this.widgets.values()) {
            advancementWidget.attachToParent();
        }
        this.calculatePan();
    }

    public void calculatePan() {
        for (AdvancementWidget widget : this.widgets.values()) {
            int widgetStartX = widget.getX();
            int widgetEndX = widgetStartX + 28;
            int widgetStartY = widget.getY();
            int widgetEndY = widgetStartY + 27;
            this.minPanX = Math.min(this.minPanX, widgetStartX);
            this.maxPanX = Math.max(this.maxPanX, widgetEndX);
            this.minPanY = Math.min(this.minPanY, widgetStartY);
            this.maxPanY = Math.max(this.maxPanY, widgetEndY);
        }
    }

    @Nullable
    public AdvancementWidget getWidget(@NotNull AdvancementHolder advancement) {
        return this.widgets.get(advancement);
    }

    @NotNull
    public PaginatedAdvancementScreen getScreen() {
        return this.screen;
    }

    public void setPinIndex(int index) {
        this.pinnedIndex = index;
    }

    public int getPinIndex() {
        return this.pinnedIndex;
    }

    public void copyHoveredAdvancementID() {
        if (this.hoveredWidget != null) {
            AdvancementWidgetAccessor awa = (AdvancementWidgetAccessor)this.hoveredWidget;
            Minecraft.getInstance().keyboardHandler.setClipboard(awa.getAdvancement().holder().id().toString());
            Minecraft.getInstance().gui.setOverlayMessage((Component)Component.translatable((String)"text.paginated_advancements.copied_to_clipboard"), false);
        }
    }
}

