/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.paginatedadvancements.client;

import com.mojang.blaze3d.systems.RenderSystem;
import de.dafuqs.paginatedadvancements.frames.AdvancementFrameDataLoader;
import de.dafuqs.paginatedadvancements.frames.FrameWrapper;
import de.dafuqs.paginatedadvancements.mixin.AdvancementWidgetAccessor;
import java.util.List;
import net.minecraft.advancements.AdvancementNode;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.advancements.DisplayInfo;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.advancements.AdvancementTab;
import net.minecraft.client.gui.screens.advancements.AdvancementWidget;
import net.minecraft.client.gui.screens.advancements.AdvancementWidgetType;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class PaginatedAdvancementWidget
extends AdvancementWidget {
    private static final ResourceLocation TITLE_BOX_TEXTURE = ResourceLocation.tryParse((String)"advancements/title_box");
    protected List<FormattedCharSequence> description;
    @Nullable
    protected FrameWrapper frameWrapper;
    private final Minecraft client;
    private int debugScrollAmount;

    public PaginatedAdvancementWidget(AdvancementTab tab, Minecraft client, AdvancementNode placedAdvancement, DisplayInfo display) {
        super(tab, client, placedAdvancement, display);
        this.client = client;
        AdvancementWidgetAccessor accessor = (AdvancementWidgetAccessor)((Object)this);
        this.frameWrapper = AdvancementFrameDataLoader.get(accessor.getAdvancement().holder().id());
        int requirementCount = placedAdvancement.advancement().requirements().size();
        int k = requirementCount > 1 ? client.font.width("  ") + client.font.width("0") * String.valueOf(requirementCount).length() * 2 + client.font.width("/") : 0;
        int l = 29 + client.font.width(accessor.getTitle()) + k;
        this.description = this.frameWrapper != null ? Language.getInstance().getVisualOrder(accessor.invokeWrapDescription((Component)ComponentUtils.mergeStyles((MutableComponent)display.getDescription().copy(), (Style)Style.EMPTY.withColor(this.frameWrapper.getFormatting())), l)) : accessor.getDescription();
        for (FormattedCharSequence orderedText : this.description) {
            l = Math.max(l, client.font.width(orderedText));
        }
        this.setDebugScrollAmount(0);
    }

    public void draw(@NotNull GuiGraphics context, int x, int y) {
        AdvancementWidgetAccessor accessor = (AdvancementWidgetAccessor)((Object)this);
        if (!accessor.getDisplay().isHidden() || accessor.getProgress() != null && accessor.getProgress().isDone()) {
            float f = accessor.getProgress() == null ? 0.0f : accessor.getProgress().getPercent();
            AdvancementWidgetType advancementObtainedStatus = f >= 1.0f ? AdvancementWidgetType.OBTAINED : AdvancementWidgetType.UNOBTAINED;
            ResourceLocation advancementID = accessor.getAdvancement().holder().id();
            @Nullable FrameWrapper frameWrapper = AdvancementFrameDataLoader.get(advancementID);
            if (frameWrapper != null) {
                context.blitSprite(frameWrapper.getTexture(advancementObtainedStatus, accessor.getDisplay().getType()), x + accessor.getX() + 3, y + accessor.getY(), 26, 26);
                context.renderItem(accessor.getDisplay().getIcon(), x + accessor.getX() + 8 + frameWrapper.getItemOffsetX(), y + accessor.getY() + 5 + frameWrapper.getItemOffsetY());
            } else {
                context.blitSprite(advancementObtainedStatus.frameSprite(accessor.getDisplay().getType()), x + accessor.getX() + 3, y + accessor.getY(), 26, 26);
                context.renderItem(accessor.getDisplay().getIcon(), x + accessor.getX() + 8, y + accessor.getY() + 5);
            }
        }
        for (AdvancementWidget advancementWidget : accessor.getChildren()) {
            advancementWidget.draw(context, x, y);
        }
    }

    public void drawHover(@NotNull GuiGraphics context, int originX, int originY, float alpha, int x, int y) {
        AdvancementWidgetType advancementObtainedStatus3;
        AdvancementWidgetType advancementObtainedStatus2;
        AdvancementWidgetType advancementObtainedStatus;
        AdvancementWidgetAccessor accessor = (AdvancementWidgetAccessor)((Object)this);
        Font textRenderer = this.client.font;
        boolean shouldRenderToTheLeft = x + originX + accessor.getX() + accessor.getWidth() + 26 >= accessor.getTab().getScreen().width;
        AdvancementProgress progress = accessor.getProgress();
        Component progressText = progress == null ? null : progress.getProgressText();
        String string = progressText == null ? null : progressText.getString();
        int i = progressText == null ? 0 : textRenderer.width((FormattedText)progressText);
        int var10000 = 113 - originY - accessor.getY() - 26;
        int var10002 = this.description.size();
        boolean bl2 = var10000 <= 6 + var10002 * 9;
        float f = progress == null ? 0.0f : progress.getPercent();
        int j = Mth.floor((float)(f * (float)accessor.getWidth()));
        if (f >= 1.0f) {
            j = accessor.getWidth() / 2;
            advancementObtainedStatus = AdvancementWidgetType.OBTAINED;
            advancementObtainedStatus2 = AdvancementWidgetType.OBTAINED;
            advancementObtainedStatus3 = AdvancementWidgetType.OBTAINED;
        } else if (j < 2) {
            j = accessor.getWidth() / 2;
            advancementObtainedStatus = AdvancementWidgetType.UNOBTAINED;
            advancementObtainedStatus2 = AdvancementWidgetType.UNOBTAINED;
            advancementObtainedStatus3 = AdvancementWidgetType.UNOBTAINED;
        } else if (j > accessor.getWidth() - 2) {
            j = accessor.getWidth() / 2;
            advancementObtainedStatus = AdvancementWidgetType.OBTAINED;
            advancementObtainedStatus2 = AdvancementWidgetType.OBTAINED;
            advancementObtainedStatus3 = AdvancementWidgetType.UNOBTAINED;
        } else {
            advancementObtainedStatus = AdvancementWidgetType.OBTAINED;
            advancementObtainedStatus2 = AdvancementWidgetType.UNOBTAINED;
            advancementObtainedStatus3 = AdvancementWidgetType.UNOBTAINED;
        }
        int k = accessor.getWidth() - j;
        RenderSystem.enableBlend();
        int l = originY + accessor.getY();
        int startX = shouldRenderToTheLeft ? originX + accessor.getX() - accessor.getWidth() + 26 + 6 : originX + accessor.getX();
        int n = 32 + this.description.size() * 9;
        if (!this.description.isEmpty()) {
            if (bl2) {
                context.blitSprite(TITLE_BOX_TEXTURE, startX, l + 26 - n, accessor.getWidth(), n);
            } else {
                context.blitSprite(TITLE_BOX_TEXTURE, startX, l, accessor.getWidth(), n);
            }
        }
        context.blitSprite(advancementObtainedStatus.boxSprite(), 200, 26, 0, 0, startX, l, j, 26);
        context.blitSprite(advancementObtainedStatus2.boxSprite(), 200, 26, 200 - k, 0, startX + j, l, k, 26);
        if (this.frameWrapper != null) {
            context.blitSprite(this.frameWrapper.getTexture(advancementObtainedStatus3, accessor.getDisplay().getType()), originX + accessor.getX() + 3, originY + accessor.getY(), 26, 26);
        } else {
            context.blitSprite(advancementObtainedStatus3.frameSprite(accessor.getDisplay().getType()), originX + accessor.getX() + 3, originY + accessor.getY(), 26, 26);
        }
        if (shouldRenderToTheLeft) {
            context.drawString(textRenderer, accessor.getTitle(), startX + 5, originY + accessor.getY() + 9, -1);
            if (string != null) {
                context.drawString(textRenderer, string, originX + accessor.getX() - i, originY + accessor.getY() + 9, -1);
            }
        } else {
            context.drawString(textRenderer, accessor.getTitle(), originX + accessor.getX() + 32, originY + accessor.getY() + 9, -1);
            if (string != null) {
                context.drawString(textRenderer, string, originX + accessor.getX() + accessor.getWidth() - i - 5, originY + accessor.getY() + 9, -1);
            }
        }
        if (bl2) {
            for (int o = 0; o < this.description.size(); ++o) {
                FormattedCharSequence orderedDescription = this.description.get(o);
                context.drawString(textRenderer, orderedDescription, startX + 5, l + 26 - n + 7 + o * 9, -5592406, false);
            }
        } else {
            for (int o = 0; o < this.description.size(); ++o) {
                FormattedCharSequence orderedDescription = this.description.get(o);
                context.drawString(textRenderer, orderedDescription, startX + 5, originY + accessor.getY() + 9 + 17 + o * 9, -5592406, false);
            }
        }
        if (this.frameWrapper == null) {
            context.renderItem(accessor.getDisplay().getIcon(), originX + accessor.getX() + 8, originY + accessor.getY() + 5);
        } else {
            context.renderItem(accessor.getDisplay().getIcon(), originX + accessor.getX() + 8 + this.frameWrapper.getItemOffsetX(), originY + accessor.getY() + 5 + this.frameWrapper.getItemOffsetY());
        }
    }

    public int getDebugScrollAmount() {
        return this.debugScrollAmount;
    }

    public void setDebugScrollAmount(int debugScrollAmount) {
        this.debugScrollAmount = debugScrollAmount;
    }
}

