/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.paginatedadvancements.client;

import de.dafuqs.paginatedadvancements.PaginatedAdvancementsClient;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.advancements.AdvancementTabType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class PinnedAdvancementTabType {
    public static final int TOP_SPACING = 24;
    public static final int WIDTH = 32;
    public static final int HEIGHT = 28;
    protected static final ResourceLocation RIGHT_TOP_TEXTURE_SELECTED = ResourceLocation.tryParse((String)"advancements/tab_right_top_selected");
    protected static final ResourceLocation RIGHT_MIDDLE_TEXTURE_SELECTED = ResourceLocation.tryParse((String)"advancements/tab_right_middle_selected");
    protected static final ResourceLocation RIGHT_TOP_TEXTURE = ResourceLocation.tryParse((String)"advancements/tab_right_top");
    protected static final ResourceLocation RIGHT_MIDDLE_TEXTURE = ResourceLocation.tryParse((String)"advancements/tab_right_middle");

    public static int getHeightWithSpacing() {
        return 28 + PaginatedAdvancementsClient.CONFIG.SpacingBetweenPinnedTabs;
    }

    public static void drawBackground(GuiGraphics context, int x, int y, boolean selected, int index) {
        ResourceLocation identifier = index == 0 ? (selected ? RIGHT_TOP_TEXTURE_SELECTED : RIGHT_TOP_TEXTURE) : (selected ? RIGHT_MIDDLE_TEXTURE_SELECTED : RIGHT_MIDDLE_TEXTURE);
        context.blitSprite(identifier, x + PinnedAdvancementTabType.getTabX(), y + PinnedAdvancementTabType.getTabY(index), 32, 28);
        AdvancementTabType.RIGHT.draw(context, x + PinnedAdvancementTabType.getTabX(), y + PinnedAdvancementTabType.getTabY(index), selected, index);
    }

    public static void drawIcon(GuiGraphics context, int x, int y, int index, ItemStack stack) {
        int i = x + PinnedAdvancementTabType.getTabX() + 6;
        int j = y + PinnedAdvancementTabType.getTabY(index) + 5;
        context.renderItem(stack, i, j);
    }

    public static int getTabX() {
        return -4;
    }

    public static int getTabY(int index) {
        return 24 + PinnedAdvancementTabType.getHeightWithSpacing() * index;
    }

    public static boolean isClickOnTab(int screenX, int screenY, int index, double mouseX, double mouseY) {
        int i = screenX + PinnedAdvancementTabType.getTabX();
        int j = screenY + PinnedAdvancementTabType.getTabY(index);
        return mouseX > (double)i && mouseX < (double)(i + 32) && mouseY > (double)j && mouseY < (double)(j + 28);
    }
}

