package me.pajic.accessorify.accessories;

import io.wispforest.accessories.api.attributes.AccessoryAttributeBuilder;
import io.wispforest.accessories.api.slot.SlotReference;
import me.pajic.accessorify.Accessorify;
import me.pajic.accessorify.util.AccessoryUtil;
import net.minecraft.class_1799;
import net.minecraft.class_9334;

public class ElytraAccessory implements AccessoryExtension {

    @Override
    public String getAttributePath() {
        return "add_cape";
    }

    @Override
    public String getDefaultSlot() {
        return "cape";
    }

    @Override
    public void getDynamicModifiers(class_1799 stack, SlotReference reference, AccessoryAttributeBuilder builder) {
        //? if 1.21.1
        //if (CompatFlags.AILERON_LOADED) AileronCompat.addModifiers(builder, stack, reference.entity().level().registryAccess().lookupOrThrow(Registries.ENCHANTMENT));
    }

    @Override
    public boolean canEquip(class_1799 stack, SlotReference reference) {
        return !AccessoryUtil.isAnotherEquipped(stack, reference,
                //? if <= 1.21.1
                //itemStack -> itemStack.getItem() instanceof ElytraItem
                //? if > 1.21.1
                itemStack -> itemStack.method_57826(class_9334.field_54197)
        );
    }

	@Override
	public boolean canEquipFromUse(class_1799 stack, SlotReference reference) {
		return !Accessorify.CONFIG.preventElytraRightClickEquip.get() && AccessoryExtension.super.canEquipFromUse(stack, reference);
	}
}
