package me.pajic.accessorify.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.AccessoriesContainer;
import io.wispforest.accessories.data.SlotTypeLoader;
import io.wispforest.accessories.impl.core.ExpandedContainer;
import me.pajic.accessorify.Accessorify;
import me.pajic.accessorify.util.GameplayUtil;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1665;
import net.minecraft.class_1676;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_3489;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;

import java.util.Optional;

@Mixin(class_1665.class)
public abstract class AbstractArrowMixin extends class_1676 {
    public AbstractArrowMixin(class_1299<? extends class_1676> entityType, class_1937 level) {
        super(entityType, level);
    }

    @WrapOperation(
            method = "tryPickup",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/world/entity/player/Inventory;add(Lnet/minecraft/world/item/ItemStack;)Z"
            )
    )
    private boolean addArrowToAccessorySlots(
            class_1661 instance, class_1799 itemStack, Operation<Boolean> original, @Local(argsOnly = true) class_1657 player
    ) {
        if (itemStack.method_31573(class_3489.field_18317) && Accessorify.CONFIG.accessorySettings.arrowAccessory.get()) {
            Optional<AccessoriesCapability> ac = AccessoriesCapability.getOptionally(player);
            if (ac.isPresent()) {
                AccessoriesContainer container = ac.get().getContainer(SlotTypeLoader.getSlotType(player, "arrow"));
                if (container != null) {
					ExpandedContainer arrows = container.getAccessories();
                    if (!GameplayUtil.getContainerItems(arrows).stream().allMatch(class_1799::method_7960) && arrows.canAddItem(itemStack)) {
                        class_1665 itemEntity = (class_1665) (Object) this;
                        class_1799 updated = arrows.addItem(itemStack);
                        if (updated.method_7960()) {
                            player.method_6103(itemEntity, 1);
                            method_31472();
                            return false;
                        }
                        else return original.call(instance, updated);
                    }
                }
            }
        }
        return original.call(instance, itemStack);
    }
}
