package me.pajic.accessorify.mixin;

import me.pajic.accessorify.util.PlayerExtension;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1657;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_1657.class)
public class PlayerExtensionDataMixin implements PlayerExtension {
    @Unique private int shulkerSlot;
    @Unique private int arrowSlot;

    @Override
    public int accessorify$getShulkerSlot() {
        return shulkerSlot;
    }

    @Override
    public void accessorify$setShulkerSlot(int value) {
        shulkerSlot = value;
    }

    @Override
    public int accessorify$getArrowSlot() {
        return arrowSlot;
    }

    @Override
    public void accessorify$setArrowSlot(int value) {
        arrowSlot = value;
    }

    //? if < 1.21.10 {
    /*@Inject(
            method = "addAdditionalSaveData",
            at = @At("TAIL")
    )
    private void addArrowSlot(CompoundTag compound, CallbackInfo ci) {
        compound.putInt("ShulkerSlot", shulkerSlot);
        compound.putInt("ArrowSlot", arrowSlot);
    }

    @Inject(
            method = "readAdditionalSaveData",
            at = @At("TAIL")
    )
    private void readArrowSlot(CompoundTag compound, CallbackInfo ci) {
        shulkerSlot = compound.getInt("ShulkerSlot");
        arrowSlot = compound.getInt("ArrowSlot");
    }
    *///?} else {
    @Inject(
            method = "addAdditionalSaveData",
            at = @At("TAIL")
    )
    private void addArrowSlot(class_11372 output, CallbackInfo ci) {
        output.method_71465("ShulkerSlot", shulkerSlot);
        output.method_71465("ArrowSlot", arrowSlot);
    }

    @Inject(
            method = "readAdditionalSaveData",
            at = @At("TAIL")
    )
    private void readArrowSlot(class_11368 input, CallbackInfo ci) {
        shulkerSlot = input.method_71424("ShulkerSlot", 0);
        arrowSlot = input.method_71424("ArrowSlot", 0);
    }
    //?}
}
