package me.pajic.accessorify.util.compat;

import it.unimi.dsi.fastutil.objects.ObjectIntImmutablePair;
import me.pajic.accessorify.AccessorifyClient;
import me.pajic.accessorify.util.AccessoryUtil;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import sereneseasons.api.SSItems;
import sereneseasons.api.season.Season;
import sereneseasons.api.season.SeasonHelper;

public class SereneSeasonsCompat {
    public static ObjectIntImmutablePair<class_2561> getSeasonStringData(class_1937 level) {
        Season.SubSeason subSeason = SeasonHelper.getSeasonState(level).getSubSeason();
        return ObjectIntImmutablePair.of(
                switch (subSeason) {
                    case EARLY_SPRING -> class_2561.method_43471("gui.accessorify.early_spring");
                    case MID_SPRING -> class_2561.method_43471("gui.accessorify.mid_spring");
                    case LATE_SPRING -> class_2561.method_43471("gui.accessorify.late_spring");
                    case EARLY_SUMMER -> class_2561.method_43471("gui.accessorify.early_summer");
                    case MID_SUMMER -> class_2561.method_43471("gui.accessorify.mid_summer");
                    case LATE_SUMMER -> class_2561.method_43471("gui.accessorify.late_summer");
                    case EARLY_AUTUMN -> class_2561.method_43471("gui.accessorify.early_autumn");
                    case MID_AUTUMN -> class_2561.method_43471("gui.accessorify.mid_autumn");
                    case LATE_AUTUMN -> class_2561.method_43471("gui.accessorify.late_autumn");
                    case EARLY_WINTER -> class_2561.method_43471("gui.accessorify.early_winter");
                    case MID_WINTER -> class_2561.method_43471("gui.accessorify.mid_winter");
                    case LATE_WINTER -> class_2561.method_43471("gui.accessorify.late_winter");
                },
                switch (subSeason.getSeason()) {
                    case /*? if >= 1.21.1 {*/Season./*?}*/SPRING -> AccessorifyClient.CONFIG.infoOverlaySettings.overlayColors.spring.get().argb();
                    case /*? if >= 1.21.1 {*/Season./*?}*/SUMMER -> AccessorifyClient.CONFIG.infoOverlaySettings.overlayColors.summer.get().argb();
                    case /*? if >= 1.21.1 {*/Season./*?}*/AUTUMN -> AccessorifyClient.CONFIG.infoOverlaySettings.overlayColors.autumn.get().argb();
                    case /*? if >= 1.21.1 {*/Season./*?}*/WINTER -> AccessorifyClient.CONFIG.infoOverlaySettings.overlayColors.winter.get().argb();
                }
        );
    }

    public static boolean calendarAccessoryEquipped(class_1309 entity) {
        return AccessoryUtil.isAccessoryEquipped(entity, SSItems.CALENDAR);
    }
}
