/*
 * Decompiled with CFR 0.152.
 */
package me.pajic.accessorify.util;

import com.google.common.collect.HashMultimap;
import io.wispforest.accessories.api.AccessoriesAPI;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.AccessoriesContainer;
import io.wispforest.accessories.api.Accessory;
import io.wispforest.accessories.api.client.AccessoriesRendererRegistry;
import io.wispforest.accessories.api.slot.SlotEntryReference;
import io.wispforest.accessories.api.slot.SlotReference;
import it.unimi.dsi.fastutil.booleans.BooleanObjectImmutablePair;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import me.pajic.accessorify.Accessorify;
import me.pajic.accessorify.renderer.LanternAccessoryRenderer;
import me.pajic.accessorify.util.GameplayUtil;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_1770;
import net.minecraft.class_1792;
import net.minecraft.class_1799;

public class AccessoryUtil {
    public static class_1799 getAccessoryStack(class_1309 entity, class_1792 item) {
        SlotEntryReference itemRef;
        Optional ac = AccessoriesCapability.getOptionally((class_1309)entity);
        if (ac.isPresent() && ((AccessoriesCapability)ac.get()).isEquipped(item) && (itemRef = ((AccessoriesCapability)ac.get()).getFirstEquipped(item)) != null) {
            return itemRef.stack();
        }
        return class_1799.field_8037;
    }

    public static class_1799 getAccessoryStack(class_1309 entity, Predicate<class_1799> predicate) {
        List matchingItems;
        Optional ac = AccessoriesCapability.getOptionally((class_1309)entity);
        if (ac.isPresent() && !(matchingItems = ((AccessoriesCapability)ac.get()).getEquipped(predicate)).isEmpty()) {
            return ((SlotEntryReference)matchingItems.get(0)).stack();
        }
        return class_1799.field_8037;
    }

    public static BooleanObjectImmutablePair<class_1799> getAccessoryStackWithRenderState(class_1309 entity, Predicate<class_1799> predicate) {
        SlotEntryReference itemRef;
        Optional ac = AccessoriesCapability.getOptionally((class_1309)entity);
        if (ac.isPresent() && ((AccessoriesCapability)ac.get()).isEquipped(predicate) && (itemRef = ((AccessoriesCapability)ac.get()).getFirstEquipped(predicate)) != null) {
            AccessoriesContainer container = itemRef.reference().slotContainer();
            boolean visible = true;
            if (container != null) {
                visible = (Boolean)container.renderOptions().get(0);
            }
            return new BooleanObjectImmutablePair(visible, (Object)itemRef.stack());
        }
        return new BooleanObjectImmutablePair(false, (Object)class_1799.field_8037);
    }

    public static boolean isAccessoryEquipped(class_1309 entity, class_1792 item) {
        Optional playerCapability = AccessoriesCapability.getOptionally((class_1309)entity);
        return playerCapability.map(accessoriesCapability -> accessoriesCapability.isEquipped(item)).orElse(false);
    }

    public static boolean isAccessoryEquipped(class_1309 entity, Predicate<class_1799> predicate) {
        Optional playerCapability = AccessoriesCapability.getOptionally((class_1309)entity);
        return playerCapability.map(accessoriesCapability -> accessoriesCapability.isEquipped(predicate)).orElse(false);
    }

    public static boolean isAnotherEquipped(class_1799 stack, SlotReference slot, class_1792 item) {
        return slot.capability().isAnotherEquipped(stack, slot, item);
    }

    public static boolean isAnotherEquipped(class_1799 stack, SlotReference slot, Predicate<class_1799> predicate) {
        return slot.capability().isAnotherEquipped(stack, slot, predicate);
    }

    public static void putAddAttributeModifier(HashMultimap<String, class_1322> map, String slot, String path) {
        map.put((Object)slot, (Object)new class_1322(Accessorify.id(path), 1.0, AccessoryUtil.operationAdd()));
    }

    public static class_1322.class_1323 operationAdd() {
        return class_1322.class_1323.field_6328;
    }

    public static void registerAccessory(class_1792 item, Accessory accessory) {
        AccessoriesAPI.registerAccessory((class_1792)item, (Accessory)accessory);
    }

    public static void registerEmptyRenderer(class_1792 ... items) {
        for (class_1792 item : items) {
            AccessoriesRendererRegistry.registerNoRenderer((class_1792)item);
        }
    }

    public static void bindItemToLanternRenderer(class_1792 item) {
        AccessoriesRendererRegistry.registerRenderer((class_1792)item, LanternAccessoryRenderer::new);
    }

    public static boolean moddedElytraCheck(class_1799 stack, class_1309 livingEntity, boolean original) {
        if (!AccessoryUtil.getAccessoryStack(livingEntity, GameplayUtil::isElytra).method_7960() && !(livingEntity.method_6118(class_1304.field_6174).method_7909() instanceof class_1770)) {
            return stack.method_7909() instanceof class_1770;
        }
        return original;
    }
}

