/*
 * Decompiled with CFR 0.152.
 */
package me.pajic.accessorify.menu;

import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.ContainerUser;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ShulkerBoxMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShulkerBoxAccessoryContainerMenu
implements Container,
MenuProvider {
    private final ItemStack shulker;
    protected NonNullList<ItemStack> items;

    public ShulkerBoxAccessoryContainerMenu(ItemStack shulker) {
        this.shulker = shulker;
        this.items = NonNullList.withSize((int)27, (Object)ItemStack.EMPTY);
    }

    public void startOpen(@NotNull ContainerUser user) {
        if (user instanceof Player) {
            Player player = (Player)user;
            ((ItemContainerContents)this.shulker.getOrDefault(DataComponents.CONTAINER, (Object)ItemContainerContents.EMPTY)).copyInto(this.items);
            player.playSound(SoundEvents.SHULKER_BOX_OPEN);
        }
    }

    public void stopOpen(@NotNull ContainerUser user) {
        if (user instanceof Player) {
            Player player = (Player)user;
            this.shulker.set(DataComponents.CONTAINER, (Object)ItemContainerContents.fromItems(this.items));
            player.playSound(SoundEvents.SHULKER_BOX_CLOSE);
        }
    }

    public int getContainerSize() {
        return this.items.size();
    }

    public boolean isEmpty() {
        return this.items.isEmpty();
    }

    @NotNull
    public ItemStack getItem(int slot) {
        return (ItemStack)this.items.get(slot);
    }

    @NotNull
    public ItemStack removeItem(int slot, int amount) {
        return ContainerHelper.removeItem(this.items, (int)slot, (int)amount);
    }

    @NotNull
    public ItemStack removeItemNoUpdate(int slot) {
        return ContainerHelper.takeItem(this.items, (int)slot);
    }

    public void setItem(int slot, @Nullable ItemStack stack) {
        this.items.set(slot, (Object)(stack == null ? ItemStack.EMPTY : stack));
        if (stack != null && stack.getCount() > this.getMaxStackSize()) {
            stack.setCount(this.getMaxStackSize());
        }
    }

    public void setChanged() {
    }

    public boolean stillValid(@NotNull Player player) {
        return true;
    }

    public void clearContent() {
        this.items.clear();
    }

    @NotNull
    public Component getDisplayName() {
        return this.shulker.getHoverName();
    }

    @Nullable
    public AbstractContainerMenu createMenu(int i, @NotNull Inventory inventory, @NotNull Player player) {
        return new ShulkerBoxMenu(i, inventory, (Container)this);
    }
}

