/*
 * Decompiled with CFR 0.152.
 */
package me.pajic.accessorify.util;

import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.AccessoriesContainer;
import io.wispforest.accessories.api.slot.SlotEntryReference;
import it.unimi.dsi.fastutil.booleans.BooleanObjectImmutablePair;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import me.pajic.accessorify.Main;
import me.pajic.accessorify.util.compat.CompatFlags;
import me.pajic.accessorify.util.compat.SereneSeasonsCompat;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ProjectileWeaponItem;

public class ModUtil {
    public static boolean shouldScope = false;
    public static float zoomModifier = 1.0f;
    public static final List<Item> SHULKER_BOXES = List.of(Items.SHULKER_BOX, Items.WHITE_SHULKER_BOX, Items.ORANGE_SHULKER_BOX, Items.MAGENTA_SHULKER_BOX, Items.LIGHT_BLUE_SHULKER_BOX, Items.YELLOW_SHULKER_BOX, Items.LIME_SHULKER_BOX, Items.PINK_SHULKER_BOX, Items.GRAY_SHULKER_BOX, Items.LIGHT_GRAY_SHULKER_BOX, Items.CYAN_SHULKER_BOX, Items.PURPLE_SHULKER_BOX, Items.BLUE_SHULKER_BOX, Items.BROWN_SHULKER_BOX, Items.GREEN_SHULKER_BOX, Items.RED_SHULKER_BOX, Items.BLACK_SHULKER_BOX);
    public static final List<Item> LANTERNS = new ArrayList<Item>(List.of(Items.LANTERN, Items.SOUL_LANTERN));

    public static BooleanObjectImmutablePair<ItemStack> getAccessoryStack(LivingEntity entity, Item item) {
        SlotEntryReference itemRef;
        Optional ac = AccessoriesCapability.getOptionally((LivingEntity)entity);
        if (ac.isPresent() && ((AccessoriesCapability)ac.get()).isEquipped(item) && (itemRef = ((AccessoriesCapability)ac.get()).getFirstEquipped(item)) != null) {
            AccessoriesContainer container = itemRef.reference().slotContainer();
            boolean visible = true;
            if (container != null) {
                visible = (Boolean)container.renderOptions().get(0);
            }
            return new BooleanObjectImmutablePair(visible, (Object)itemRef.stack());
        }
        return new BooleanObjectImmutablePair(false, (Object)ItemStack.EMPTY);
    }

    public static boolean accessoryEquipped(LivingEntity entity, Item item) {
        Optional playerCapability = AccessoriesCapability.getOptionally((LivingEntity)entity);
        return playerCapability.map(accessoriesCapability -> accessoriesCapability.isEquipped(item)).orElse(false);
    }

    public static boolean calendarAccessoryEquipped(LivingEntity entity) {
        if (CompatFlags.SERENE_SEASONS_LOADED) {
            return SereneSeasonsCompat.calendarAccessoryEquipped(entity);
        }
        return false;
    }

    public static boolean isLanternEquipped(LivingEntity entity) {
        for (Item item : LANTERNS) {
            if (!ModUtil.accessoryEquipped(entity, item)) continue;
            return true;
        }
        return false;
    }

    public static boolean elytraEquipped(LivingEntity entity) {
        Optional playerCapability = AccessoriesCapability.getOptionally((LivingEntity)entity);
        return playerCapability.map(accessoriesCapability -> accessoriesCapability.isEquipped(stack -> stack.has(DataComponents.GLIDER))).orElse(false);
    }

    public static BooleanObjectImmutablePair<ItemStack> tryGetElytraAccessory(LivingEntity livingEntity) {
        BooleanObjectImmutablePair<ItemStack> pair = new BooleanObjectImmutablePair<ItemStack>(false, (Object)ItemStack.EMPTY);
        if (((ItemStack)pair.right()).isEmpty()) {
            pair = ModUtil.getAccessoryStack(livingEntity, Items.ELYTRA);
        }
        return pair;
    }

    public static boolean isTotem(ItemStack stack) {
        return stack.has(DataComponents.DEATH_PROTECTION);
    }

    public static ItemStack tryGetTotemAccessory(LivingEntity livingEntity) {
        List totems;
        Optional ac = AccessoriesCapability.getOptionally((LivingEntity)livingEntity);
        if (ac.isPresent() && !(totems = ((AccessoriesCapability)ac.get()).getEquipped(ModUtil::isTotem)).isEmpty()) {
            return ((SlotEntryReference)totems.getFirst()).stack();
        }
        return ItemStack.EMPTY;
    }

    public static boolean isLantern(ItemStack stack) {
        return LANTERNS.stream().anyMatch(arg_0 -> ((ItemStack)stack).is(arg_0));
    }

    public static boolean isHoldingProjectileWeapon(Player player) {
        return player.getMainHandItem().getItem() instanceof ProjectileWeaponItem || player.getOffhandItem().getItem() instanceof ProjectileWeaponItem;
    }

    public static boolean calendarUsedForSeasonInfo() {
        return (Boolean)Main.CONFIG.accessorySettings.calendarAccessory.get() != false && CompatFlags.SERENE_SEASONS_LOADED;
    }
}

