/*
 * Decompiled with CFR 0.152.
 */
package me.pajic.accessorify.util;

import com.google.common.collect.HashMultimap;
import com.mojang.blaze3d.opengl.GlStateManager;
import io.wispforest.accessories.api.client.AccessoriesRendererRegistry;
import io.wispforest.accessories.api.core.Accessory;
import io.wispforest.accessories.api.core.AccessoryRegistry;
import io.wispforest.accessories.api.slot.SlotPath;
import io.wispforest.accessories.api.slot.SlotReference;
import io.wispforest.accessories.impl.core.ExpandedContainer;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.client.network.ClientPacketDistributor;

public class MultiVersionUtil {
    public static ResourceLocation parse(String location) {
        return ResourceLocation.parse((String)location);
    }

    public static ResourceLocation withDefaultNamespace(String path) {
        return ResourceLocation.withDefaultNamespace((String)path);
    }

    public static ResourceLocation withModNamespace(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)"accessorify", (String)path);
    }

    public static AttributeModifier.Operation operationAdd() {
        return AttributeModifier.Operation.ADD_VALUE;
    }

    public static void registerAccessory(Item item, Accessory accessory) {
        AccessoryRegistry.register((Item)item, (Accessory)accessory);
    }

    public static void noRenderer(Item item) {
        AccessoriesRendererRegistry.bindItemToEmptyRenderer((Item)item);
    }

    public static boolean isAnotherEquipped(ItemStack stack, SlotReference slot, Item item) {
        return slot.capability().isAnotherEquipped(stack, (SlotPath)slot, item);
    }

    public static boolean isAnotherEquipped(ItemStack stack, SlotReference slot, Predicate<ItemStack> predicate) {
        return slot.capability().isAnotherEquipped(stack, (SlotPath)slot, predicate);
    }

    public static void putAddAttributeModifier(HashMultimap<String, AttributeModifier> map, String slot, String path) {
        map.put((Object)slot, (Object)new AttributeModifier(MultiVersionUtil.withModNamespace(path), 1.0, MultiVersionUtil.operationAdd()));
    }

    public static List<ItemStack> getItems(ExpandedContainer container) {
        return container.getItems();
    }

    public static void sendToServer(CustomPacketPayload payload) {
        ClientPacketDistributor.sendToServer((CustomPacketPayload)payload, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static int color(int a, int r, int g, int b) {
        return ARGB.color((int)a, (int)r, (int)g, (int)b);
    }

    public static int as8BitChannel(float value) {
        return ARGB.as8BitChannel((float)value);
    }

    public static boolean debugScreenShown() {
        return Minecraft.getInstance().gui.getDebugOverlay().showDebugScreen();
    }

    public static void startRender(GuiGraphics guiGraphics) {
        guiGraphics.nextStratum();
        GlStateManager._enableBlend();
    }

    public static void stopRender(GuiGraphics guiGraphics) {
        GlStateManager._disableBlend();
    }
}

