/*
 * Decompiled with CFR 0.152.
 */
package me.pajic.accessorify.network;

import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.AccessoriesContainer;
import java.util.Optional;
import me.pajic.accessorify.menu.ShulkerBoxAccessoryContainerMenu;
import me.pajic.accessorify.util.PlayerExtension;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.inventory.PlayerEnderChestContainer;
import net.minecraft.world.item.ItemStack;

public class NetworkEvents {
    public static void openShulkerBox(ServerPlayer player, int index) {
        Optional ac = AccessoriesCapability.getOptionally((LivingEntity)player);
        if (ac.isPresent()) {
            ItemStack shulker = ((AccessoriesContainer)((AccessoriesCapability)ac.get()).getContainers().get("shulker")).getAccessories().getItem(index);
            player.openMenu((MenuProvider)new ShulkerBoxAccessoryContainerMenu(shulker, 27));
            player.awardStat(Stats.OPEN_SHULKER_BOX);
        }
    }

    public static void openEnderContainer(ServerPlayer player) {
        player.playSound(SoundEvents.ENDER_CHEST_OPEN);
        PlayerEnderChestContainer container = player.getEnderChestInventory();
        player.openMenu((MenuProvider)new SimpleMenuProvider((i, inventory, player1) -> ChestMenu.threeRows((int)i, (Inventory)inventory, (Container)container), (Component)Component.translatable((String)"container.enderchest")));
        player.awardStat(Stats.OPEN_ENDERCHEST);
    }

    public static void syncShulkerSlotToServer(ServerPlayer player, int slot) {
        ((PlayerExtension)player).accessorify$setShulkerSlot(slot);
    }

    public static void syncArrowSlotToServer(ServerPlayer player, int slot) {
        ((PlayerExtension)player).accessorify$setArrowSlot(slot);
    }
}

