/*
 * Decompiled with CFR 0.152.
 */
package me.pajic.accessorify.util;

import com.google.common.collect.HashMultimap;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.AccessoriesContainer;
import io.wispforest.accessories.api.client.AccessoriesRendererRegistry;
import io.wispforest.accessories.api.core.Accessory;
import io.wispforest.accessories.api.core.AccessoryRegistry;
import io.wispforest.accessories.api.slot.SlotEntryReference;
import io.wispforest.accessories.api.slot.SlotPath;
import io.wispforest.accessories.api.slot.SlotReference;
import it.unimi.dsi.fastutil.booleans.BooleanObjectImmutablePair;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import me.pajic.accessorify.Accessorify;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class AccessoryUtil {
    public static ItemStack getAccessoryStack(LivingEntity entity, Item item) {
        SlotEntryReference itemRef;
        Optional ac = AccessoriesCapability.getOptionally((LivingEntity)entity);
        if (ac.isPresent() && ((AccessoriesCapability)ac.get()).isEquipped(item) && (itemRef = ((AccessoriesCapability)ac.get()).getFirstEquipped(item)) != null) {
            return itemRef.stack();
        }
        return ItemStack.EMPTY;
    }

    public static ItemStack getAccessoryStack(LivingEntity entity, Predicate<ItemStack> predicate) {
        List matchingItems;
        Optional ac = AccessoriesCapability.getOptionally((LivingEntity)entity);
        if (ac.isPresent() && !(matchingItems = ((AccessoriesCapability)ac.get()).getEquipped(predicate)).isEmpty()) {
            return ((SlotEntryReference)matchingItems.get(0)).stack();
        }
        return ItemStack.EMPTY;
    }

    public static BooleanObjectImmutablePair<ItemStack> getAccessoryStackWithRenderState(LivingEntity entity, Predicate<ItemStack> predicate) {
        SlotEntryReference itemRef;
        Optional ac = AccessoriesCapability.getOptionally((LivingEntity)entity);
        if (ac.isPresent() && ((AccessoriesCapability)ac.get()).isEquipped(predicate) && (itemRef = ((AccessoriesCapability)ac.get()).getFirstEquipped(predicate)) != null) {
            AccessoriesContainer container = itemRef.reference().slotContainer();
            boolean visible = true;
            if (container != null) {
                visible = (Boolean)container.renderOptions().get(0);
            }
            return new BooleanObjectImmutablePair(visible, (Object)itemRef.stack());
        }
        return new BooleanObjectImmutablePair(false, (Object)ItemStack.EMPTY);
    }

    public static boolean isAccessoryEquipped(LivingEntity entity, Item item) {
        Optional playerCapability = AccessoriesCapability.getOptionally((LivingEntity)entity);
        return playerCapability.map(accessoriesCapability -> accessoriesCapability.isEquipped(item)).orElse(false);
    }

    public static boolean isAccessoryEquipped(LivingEntity entity, Predicate<ItemStack> predicate) {
        Optional playerCapability = AccessoriesCapability.getOptionally((LivingEntity)entity);
        return playerCapability.map(accessoriesCapability -> accessoriesCapability.isEquipped(predicate)).orElse(false);
    }

    public static boolean isAnotherEquipped(ItemStack stack, SlotReference slot, Item item) {
        return slot.capability().isAnotherEquipped(stack, (SlotPath)slot, item);
    }

    public static boolean isAnotherEquipped(ItemStack stack, SlotReference slot, Predicate<ItemStack> predicate) {
        return slot.capability().isAnotherEquipped(stack, (SlotPath)slot, predicate);
    }

    public static void putAddAttributeModifier(HashMultimap<String, AttributeModifier> map, String slot, String path) {
        map.put((Object)slot, (Object)new AttributeModifier(Accessorify.id(path), 1.0, AccessoryUtil.operationAdd()));
    }

    public static AttributeModifier.Operation operationAdd() {
        return AttributeModifier.Operation.ADD_VALUE;
    }

    public static void registerAccessory(Item item, Accessory accessory) {
        AccessoryRegistry.register((Item)item, (Accessory)accessory);
    }

    public static void registerEmptyRenderer(Item ... items) {
        for (Item item : items) {
            AccessoriesRendererRegistry.bindItemToEmptyRenderer((Item)item);
        }
    }

    public static void bindItemToLanternRenderer(Item item) {
        AccessoriesRendererRegistry.bindItemToRenderer((Item)item, (ResourceLocation)Accessorify.id("lantern_renderer"));
    }
}

