package me.pajic.accessorify.mixin;

import com.google.common.base.Strings;
import dev.kikugie.fletching_table.annotation.MixinEnvironment;
import me.pajic.accessorify.Accessorify;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_340;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.List;

@MixinEnvironment(type = MixinEnvironment.Env.CLIENT)
@Mixin(class_340.class)
public class DebugScreenOverlayMixin {

    @Shadow @Final private class_310 minecraft;

    @Inject(
            method = "renderLines",
            at = @At("HEAD")
    )
    private void filterLines(class_332 guiGraphics, List<String> lines, boolean leftSide, CallbackInfo ci) {
        if (Accessorify.CONFIG.hideDebugInfoInSurvival.get() && minecraft.method_1555()) {
            lines.removeIf(text -> !Strings.isNullOrEmpty(text) && text.startsWith(/*? < 1.21.10 {*//*"Chunk-relative: "*//*?} else {*/"Section-relative: "/*?}*/));
            lines.removeIf(text -> !Strings.isNullOrEmpty(text) && text.startsWith("hunger: "));
        }
    }
}
