package me.pajic.accessorify.mixin;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.injector.v2.WrapWithCondition;
import com.llamalad7.mixinextras.injector.wrapmethod.WrapMethod;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.Share;
import com.llamalad7.mixinextras.sugar.ref.LocalBooleanRef;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.AccessoriesContainer;
import io.wispforest.accessories.data.SlotTypeLoader;
import me.pajic.accessorify.Accessorify;
import me.pajic.accessorify.util.PlayerExtension;
import net.minecraft.class_1309;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_1811;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;

import java.util.Optional;

@Mixin(class_1811.class)
public class ProjectileWeaponItemMixin {

    @ModifyReturnValue(
            method = "getHeldProjectile",
            at = @At(value = "RETURN")
    )
    private static class_1799 getAmmoFromAccessorySlot(class_1799 original, @Local(argsOnly = true) class_1309 shooter) {
        if (Accessorify.CONFIG.accessorySettings.arrowAccessory.get() && original.method_7960()) {
            Optional<AccessoriesCapability> ac = AccessoriesCapability.getOptionally(shooter);
            if (ac.isPresent()) {
                AccessoriesContainer container = ac.get().getContainer(SlotTypeLoader.getSlotType(shooter, "arrow"));
                if (container != null) {
                    int slot = ((PlayerExtension) shooter).accessorify$getArrowSlot();
                    class_1799 arrows = container.getAccessories().method_5438(slot);
                    if (!arrows.method_7960()) {
                        return arrows;
                    }
                }
            }
        }
        return original;
    }

    //? if >= 1.21.1 {
    @WrapMethod(method = "useAmmo")
    private static class_1799 useAmmoFromAccessorySlot(
            class_1799 weapon,
            class_1799 ammo,
            class_1309 shooter,
            boolean intangable,
            Operation<class_1799> original,
            @Share("accessorySlotUsed") LocalBooleanRef accessorySlotUsed
    ) {
        if (Accessorify.CONFIG.accessorySettings.arrowAccessory.get()) {
            Optional<AccessoriesCapability> ac = AccessoriesCapability.getOptionally(shooter);
            if (ac.isPresent()) {
                AccessoriesContainer container = ac.get().getContainer(SlotTypeLoader.getSlotType(shooter, "arrow"));
                if (container != null) {
                    int slot = ((PlayerExtension) shooter).accessorify$getArrowSlot();
                    class_1799 arrows = container.getAccessories().method_5438(slot);
					Accessorify.debugLog("useAmmoFromAccessorySlot {}", arrows.toString());
                    if (!arrows.method_7960()) {
                        accessorySlotUsed.set(true);
                        //noinspection MixinExtrasOperationParameters
                        return original.call(weapon, container.getAccessories().method_5438(slot), shooter, intangable);
                    }
                }
            }
        }
        accessorySlotUsed.set(false);
        return original.call(weapon, ammo, shooter, intangable);
    }

    @WrapWithCondition(
            method = "useAmmo",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/world/entity/player/Inventory;removeItem(Lnet/minecraft/world/item/ItemStack;)V"
            )
    )
    private static boolean emptyAccessorySlot(
            class_1661 instance,
            class_1799 stack,
            @Share("accessorySlotUsed") LocalBooleanRef accessorySlotUsed
    ) {
        return !accessorySlotUsed.get();
    }
    //?}
}
