package me.pajic.accessorify.gui;

import it.unimi.dsi.fastutil.ints.IntIntImmutablePair;
import it.unimi.dsi.fastutil.objects.ObjectIntImmutablePair;
import me.pajic.accessorify.Accessorify;
import me.pajic.accessorify.AccessorifyClient;
import me.pajic.accessorify.util.AccessoryUtil;
import me.pajic.accessorify.util.ClientUtil;
import me.pajic.accessorify.util.CompatFlags;
import me.pajic.accessorify.util.GameplayUtil;
import me.pajic.accessorify.util.compat.RaisedCompat;
import me.pajic.accessorify.util.compat.SereneSeasonsCompat;
import net.minecraft.class_124;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4208;
import net.minecraft.class_5250;
//? if < 1.21.10 && fabric
import me.pajic.accessorify.util.compat.FabricSeasonsCompat;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@SuppressWarnings("ConstantConditions")
public class InfoOverlays {
    private static final List<ObjectIntImmutablePair<class_2561>> renderList = new ArrayList<>();
    private static final class_310 MC = class_310.method_1551();

    public static void render(class_332 guiGraphics) {
        if (
                MC.field_1724 != null && MC.field_1687 != null &&
                !MC.field_1690.field_1842 && !ClientUtil.debugScreenShown()
        ) {
            boolean shouldObfuscateCompass = Accessorify.CONFIG.infoOverlaySettings.obfuscateCompassIfNotOverworld.get() && MC.field_1687.method_27983() != class_1937.field_25179;
            boolean shouldObfuscateClock = Accessorify.CONFIG.infoOverlaySettings.obfuscateClockIfNotOverworld.get() && MC.field_1687.method_27983() != class_1937.field_25179;
            if (Accessorify.CONFIG.accessorySettings.compassAccessory.get() && AccessoryUtil.isAccessoryEquipped(MC.field_1724, class_1802.field_8251) && !CompatFlags.IMMERSIVE_OVERLAYS_LOADED) {
                prepareCompassOverlay(shouldObfuscateCompass);
            }
            if (Accessorify.CONFIG.accessorySettings.clockAccessory.get() && AccessoryUtil.isAccessoryEquipped(MC.field_1724, class_1802.field_8557) && !CompatFlags.IMMERSIVE_OVERLAYS_LOADED) {
                prepareClockOverlay(shouldObfuscateClock);
            }
            if (GameplayUtil.calendarUsedForSeasonInfo() && GameplayUtil.calendarAccessoryEquipped(MC.field_1724) && !CompatFlags.IMMERSIVE_OVERLAYS_LOADED) {
                prepareSeasonString(shouldObfuscateClock);
            }
            if (Accessorify.CONFIG.accessorySettings.recoveryCompassAccessory.get() && AccessoryUtil.isAccessoryEquipped(MC.field_1724, class_1802.field_38747)) {
                prepareRecoveryCompassOverlay();
            }
            if (!renderList.isEmpty()) {
                renderLines(guiGraphics);
                renderList.clear();
            }
        }
    }

    @SuppressWarnings("resource")
	private static void prepareCompassOverlay(boolean shouldObfuscate) {
        if (shouldObfuscate) {
            if (Accessorify.CONFIG.infoOverlaySettings.useObfuscationEffect.get()) {
                class_2561 obfuscatedText = class_2561.method_43470("" + class_124.field_1068 + class_124.field_1051 + "XXXXXXXX".substring(0, MC.field_1687.field_9229.method_43048(4) + 3));
                if (Accessorify.CONFIG.infoOverlaySettings.overlayFields.coordinates.get())
                    renderList.add(new ObjectIntImmutablePair<>(obfuscatedText, 0xffffffff));
                if (Accessorify.CONFIG.infoOverlaySettings.overlayFields.direction.get())
                    renderList.add(new ObjectIntImmutablePair<>(obfuscatedText, 0xffffffff));
                if (Accessorify.CONFIG.infoOverlaySettings.overlayFields.biome.get())
                    renderList.add(new ObjectIntImmutablePair<>(obfuscatedText, 0xffffffff));
            }
        } else {
            class_2338 blockPos = MC.field_1724.method_24515();

            if (Accessorify.CONFIG.infoOverlaySettings.overlayFields.coordinates.get()) {
                class_2561 coordinates;
                if (Accessorify.CONFIG.infoOverlaySettings.showYCoordinate.get()) {
                    coordinates = class_2561.method_43469(
                            "gui.accessorify.coordinates_xyz",
                            blockPos.method_10263(), blockPos.method_10264(), blockPos.method_10260()
                    );
                } else {
                    coordinates = class_2561.method_43469(
                            "gui.accessorify.coordinates_xz",
                            blockPos.method_10263(), blockPos.method_10260()
                    );
                }
                renderList.add(new ObjectIntImmutablePair<>(coordinates, 0xffffffff));
            }

            if (Accessorify.CONFIG.infoOverlaySettings.overlayFields.direction.get()) {
                class_2561 direction = class_2561.method_43469("gui.accessorify.facing", MC.field_1724.method_5735().method_10151());
                renderList.add(new ObjectIntImmutablePair<>(direction, 0xffffffff));
            }

            if (Accessorify.CONFIG.infoOverlaySettings.overlayFields.biome.get()) {
                class_2960 biome = MC.field_1724.method_37908().method_23753(blockPos).method_40229().map(
                        key -> key != null ? key.method_29177() : null, unknown -> null
                );
                class_2561 biomeName = class_2561.method_43471("biome." + biome.method_12836() + "." + biome.method_12832());
                renderList.add(new ObjectIntImmutablePair<>(biomeName, 0xffffffff));
            }
        }
    }

    private static void prepareClockOverlay(boolean shouldObfuscate) {
        if (shouldObfuscate) {
            if (Accessorify.CONFIG.infoOverlaySettings.useObfuscationEffect.get()) {
                class_2561 obfuscatedText = class_2561.method_43470("" + class_124.field_1068 + class_124.field_1051 + "XXXXXXXX".substring(0, MC.field_1687.field_9229.method_43048(4) + 3));
                if (Accessorify.CONFIG.infoOverlaySettings.overlayFields.dayAndTime.get())
                    renderList.add(new ObjectIntImmutablePair<>(obfuscatedText, 0xffffffff));
                if (Accessorify.CONFIG.infoOverlaySettings.overlayFields.weather.get())
                    renderList.add(new ObjectIntImmutablePair<>(obfuscatedText, 0xffffffff));
                if (Accessorify.CONFIG.infoOverlaySettings.overlayFields.moonPhase.get())
                    renderList.add(new ObjectIntImmutablePair<>(obfuscatedText, 0xffffffff));
            }
        } else {
            class_2338 blockPos = MC.field_1724.method_24515();

            if (Accessorify.CONFIG.infoOverlaySettings.overlayFields.dayAndTime.get()) {
                class_5250 dayAndTime = class_2561.method_43469(
                        "gui.accessorify.day",
                        (MC.field_1687.method_8532() / 24000L) + 1
                );
                long timeOffset = (MC.field_1687.method_8532() + 6000) % 24000;
                class_2561 time = class_2561.method_43469(
                        "gui.accessorify.time",
                        timeOffset / 1000,
                        String.format("%02d", (int) ((double) (timeOffset / 10 % 100) / 100 * 60))
                );
                dayAndTime.method_27693(", ");
                dayAndTime.method_10852(time);
                renderList.add(new ObjectIntImmutablePair<>(dayAndTime, 0xffffffff));
            }

            if (Accessorify.CONFIG.infoOverlaySettings.overlayFields.weather.get()) {
                class_2561 weather;
                int weatherColor;
                if (MC.field_1687.method_8546()) {
                    weather = class_2561.method_43471("gui.accessorify.thundering");
                    weatherColor = AccessorifyClient.CONFIG.infoOverlaySettings.overlayColors.thundering.get().argb();
                } else if (MC.field_1687.method_8419()) {
                    //? if <= 1.21.1
                    class_1959.class_1963 precipitation = MC.field_1687.method_23753(blockPos).comp_349().method_48162(blockPos);
                    //? if > 1.21.1
                    //Biome.Precipitation precipitation = MC.level.getBiome(blockPos).value().getPrecipitationAt(blockPos, (int) MC.player.getY());
                    if (precipitation == class_1959.class_1963.field_9382) {
                        weather = class_2561.method_43471("gui.accessorify.raining");
                        weatherColor = AccessorifyClient.CONFIG.infoOverlaySettings.overlayColors.raining.get().argb();
                    } else if (precipitation == class_1959.class_1963.field_9383) {
                        weather = class_2561.method_43471("gui.accessorify.snowing");
                        weatherColor = AccessorifyClient.CONFIG.infoOverlaySettings.overlayColors.snowing.get().argb();
                    } else {
                        weather = class_2561.method_43471("gui.accessorify.cloudy");
                        weatherColor = AccessorifyClient.CONFIG.infoOverlaySettings.overlayColors.cloudy.get().argb();
                    }
                } else {
                    weather = class_2561.method_43471("gui.accessorify.clear");
                    weatherColor = 0xffffffff;
                }
                if (AccessorifyClient.CONFIG.infoOverlaySettings.coloredWeather.get()) {
                    renderList.add(new ObjectIntImmutablePair<>(weather, weatherColor));
                } else {
                    renderList.add(new ObjectIntImmutablePair<>(weather, 0xffffffff));
                }
            }

            if (Accessorify.CONFIG.infoOverlaySettings.overlayFields.moonPhase.get()) {
                /* Decided to flip the emojis around due to how they are displayed in-game;
                full moon is a hollow circle, new moon is a filled circle
                It doesn't feel right so I shifted them to match the MC moon more -Meep*/
                class_5250 moonPhase;
                switch (MC.field_1687.method_30273()) {
                    case 0 -> moonPhase = class_2561.method_43470("\uD83C\uDF11 ").method_10852(
                            class_2561.method_43471("gui.accessorify.full_moon"));
                    case 1 -> moonPhase = class_2561.method_43470("\uD83C\uDF18 ").method_10852(
                            class_2561.method_43471("gui.accessorify.waning_gibbous"));
                    case 2 -> moonPhase = class_2561.method_43470("\uD83C\uDF17 ").method_10852(
                            class_2561.method_43471("gui.accessorify.last_quarter"));
                    case 3 -> moonPhase = class_2561.method_43470("\uD83C\uDF16 ").method_10852(
                            class_2561.method_43471("gui.accessorify.waning_crescent"));
                    case 4 -> moonPhase = class_2561.method_43470("\uD83C\uDF15 ").method_10852(
                            class_2561.method_43471("gui.accessorify.new_moon"));
                    case 5 -> moonPhase = class_2561.method_43470("\uD83C\uDF14 ").method_10852(
                            class_2561.method_43471("gui.accessorify.waxing_crescent"));
                    case 6 -> moonPhase = class_2561.method_43470("\uD83C\uDF13 ").method_10852(
                            class_2561.method_43471("gui.accessorify.first_quarter"));
                    case 7 -> moonPhase = class_2561.method_43470("\uD83C\uDF12 ").method_10852(
                            class_2561.method_43471("gui.accessorify.waxing_gibbous"));
                    default -> moonPhase = class_2561.method_43470("\uD83D\uDCA5 ").method_10852(
                            class_2561.method_43471("gui.accessorify.moon_default"));
                }
                renderList.add(new ObjectIntImmutablePair<>(moonPhase, 0xffffffff));
            }
        }
        if (!GameplayUtil.calendarUsedForSeasonInfo()) {
            prepareSeasonString(shouldObfuscate);
        }
    }

    private static void prepareSeasonString(boolean shouldObfuscate) {
        if (shouldObfuscate && (CompatFlags.SERENE_SEASONS_LOADED || CompatFlags.FABRIC_SEASONS_LOADED)) {
            if (Accessorify.CONFIG.infoOverlaySettings.useObfuscationEffect.get()) {
                class_2561 obfuscatedText = class_2561.method_43470("" + class_124.field_1068 + class_124.field_1051 + "XXXXXXXX".substring(0, MC.field_1687.field_9229.method_43048(4) + 3));
                if (Accessorify.CONFIG.infoOverlaySettings.overlayFields.season.get())
                    renderList.add(new ObjectIntImmutablePair<>(obfuscatedText, 0xffffffff));
            }
        }
        else {
            if (Accessorify.CONFIG.infoOverlaySettings.overlayFields.season.get()) {
                ObjectIntImmutablePair<class_2561> seasonStringData = null;
                if (CompatFlags.SERENE_SEASONS_LOADED) {
                    seasonStringData = SereneSeasonsCompat.getSeasonStringData(MC.field_1687);
                }
				//? if < 1.21.10 && fabric {
				else if (CompatFlags.FABRIC_SEASONS_LOADED) {
                    seasonStringData = FabricSeasonsCompat.getSeasonStringData(MC.field_1687);
                }
				//?}
                if (seasonStringData != null) {
                    if (AccessorifyClient.CONFIG.infoOverlaySettings.coloredSeason.get()) {
                        renderList.add(seasonStringData);
                    } else {
                        renderList.add(new ObjectIntImmutablePair<>(seasonStringData.left(), 0xffffffff));
                    }
                }
            }
        }
    }

    private static void prepareRecoveryCompassOverlay() {
        if (Accessorify.CONFIG.infoOverlaySettings.overlayFields.lastDeathLocation.get()) {
            Optional<class_4208> optional = MC.field_1724.method_43122();
            if (optional.isPresent()) {
                if (optional.get().method_19442() == MC.field_1687.method_27983()) {
                    class_2338 lastDeathLocation = optional.get().method_19446();
                    class_2561 coordinates;
                    if (Accessorify.CONFIG.infoOverlaySettings.showYCoordinate.get()) {
                        coordinates = class_2561.method_43469(
                                "gui.accessorify.coordinates_xyz",
                                lastDeathLocation.method_10263(), lastDeathLocation.method_10264(), lastDeathLocation.method_10260()
                        );
                    } else {
                        coordinates = class_2561.method_43469(
                                "gui.accessorify.coordinates_xz",
                                lastDeathLocation.method_10263(), lastDeathLocation.method_10260()
                        );
                    }
                    renderList.add(new ObjectIntImmutablePair<>(
                            class_2561.method_43471("gui.accessorify.last_death_location"),
                            0xffffffff
                    ));
                    renderList.add(new ObjectIntImmutablePair<>(coordinates, 0xffffffff));
                } else {
                    renderList.add(new ObjectIntImmutablePair<>(
                            class_2561.method_43471("gui.accessorify.last_death_location_wrong_dimension"),
                            0xffffffff
                    ));
                }
            } else {
                renderList.add(new ObjectIntImmutablePair<>(
                        class_2561.method_43471("gui.accessorify.last_death_location_unavailable"),
                        0xffffffff
                ));
            }
        }
    }

    private static void renderLines(class_332 guiGraphics) {
        int y = 4;
        OverlayPosition position = AccessorifyClient.CONFIG.infoOverlaySettings.position.get();
        if (position == OverlayPosition.BOTTOM_LEFT || position == OverlayPosition.BOTTOM_RIGHT) {
            Collections.reverse(renderList);
        }
        for (ObjectIntImmutablePair<class_2561> line : renderList) {
            renderLine(guiGraphics, MC.field_1772, line.left(), y, line.rightInt());
            y += 12;
        }
    }

    private static void renderLine(class_332 guiGraphics, class_327 font, class_2561 text, int lineY, int color) {
        int width = MC.method_22683().method_4486();
        int height = MC.method_22683().method_4502();
        int offsetX = AccessorifyClient.CONFIG.infoOverlaySettings.offsetX.get();
        int offsetY = AccessorifyClient.CONFIG.infoOverlaySettings.offsetY.get();
        int raisedOffsetX = 0;
        int raisedOffsetY = 0;
        if (CompatFlags.RAISED_LOADED) {
            IntIntImmutablePair offsets = RaisedCompat.getOtherComponentOffsets();
            raisedOffsetX = offsets.leftInt();
            raisedOffsetY = offsets.rightInt();
        }

        IntIntImmutablePair position;
        switch (AccessorifyClient.CONFIG.infoOverlaySettings.position.get()) {
            case TOP_RIGHT -> position = new IntIntImmutablePair(
                    width - 4 - MC.field_1772.method_27525(text) - offsetX + raisedOffsetX,
                    lineY + offsetY + raisedOffsetY
            );
            case BOTTOM_LEFT -> position = new IntIntImmutablePair(
                    4 + offsetX + raisedOffsetX,
                    height - 8 - lineY - offsetY + raisedOffsetY
            );
            case BOTTOM_RIGHT -> position = new IntIntImmutablePair(
                    width - 4 - MC.field_1772.method_27525(text) - offsetX + raisedOffsetX,
                    height - 8 - lineY - offsetY + raisedOffsetY
            );
            default -> position = new IntIntImmutablePair(
                    4 + offsetX + raisedOffsetX,
                    lineY + offsetY + raisedOffsetY
            );
        }
        int x = position.leftInt();
        int y = position.rightInt();

        ClientUtil.startRender(guiGraphics);

        if (AccessorifyClient.CONFIG.infoOverlaySettings.textBackground.get()) {
            guiGraphics.method_25294(
                    x - 2, y - 2, x + font.method_27525(text) + 2, y + 10,
					ClientUtil.color(
							ClientUtil.as8BitChannel(AccessorifyClient.CONFIG.infoOverlaySettings.textBackgroundOpacity.get()),
                            0, 0, 0
                    )
            );
        }
        guiGraphics.method_51439(font, text, x, y, color, AccessorifyClient.CONFIG.infoOverlaySettings.textShadow.get());

		ClientUtil.stopRender(guiGraphics);
    }
}
