package me.pajic.accessorify.mixin;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.wrapmethod.WrapMethod;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import me.pajic.accessorify.Accessorify;
import me.pajic.accessorify.util.AccessoryUtil;
import me.pajic.accessorify.util.ClientUtil;
import me.pajic.accessorify.util.GameplayUtil;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(class_1309.class)
public abstract class LivingEntityMixin {

    @Shadow protected abstract void updateUsingItem(class_1799 usingItem);

    @ModifyExpressionValue(
            method = "checkTotemDeathProtection",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/world/entity/LivingEntity;getItemInHand(Lnet/minecraft/world/InteractionHand;)Lnet/minecraft/world/item/ItemStack;"
            )
    )
    private class_1799 tryConsumeTotemAccessory(class_1799 original) {
        if (Accessorify.CONFIG.accessorySettings.totemOfUndyingAccessory.get()) {
            class_1799 stack = AccessoryUtil.getAccessoryStack((class_1309) (Object) this, GameplayUtil::isTotem);
            return stack.method_7960() ? original : stack;
        }
        return original;
    }

    @WrapMethod(method = "updatingUsingItem")
    private void useSpyglassAccessory(Operation<Void> original) {
        if (ClientUtil.shouldScope) {
            updateUsingItem(new class_1799(class_1802.field_27070));
        }
        else original.call();
    }

    //? if <= 1.21.1 {
    @ModifyExpressionValue(
            method = "updateFallFlying",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/world/entity/LivingEntity;getItemBySlot(Lnet/minecraft/world/entity/EquipmentSlot;)Lnet/minecraft/world/item/ItemStack;"
            )
    )
    private class_1799 tryGetElytraAccessory(class_1799 original) {
        if (Accessorify.CONFIG.accessorySettings.elytraAccessory.get()) {
            class_1799 stack = AccessoryUtil.getAccessoryStack((class_1309) (Object) this, GameplayUtil::isElytra);
            return stack.method_7960() ? original : stack;
        }
        return original;
    }
    //?}
}
