package me.pajic.accessorify.renderer;

import io.wispforest.accessories.api.client.AccessoryRenderer;
import io.wispforest.accessories.api.client.SimpleAccessoryRenderer;
import io.wispforest.accessories.api.slot.SlotReference;
import me.pajic.accessorify.util.GameplayUtil;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_572;
import net.minecraft.class_583;

public class LanternAccessoryRenderer implements SimpleAccessoryRenderer {
	//? if <= 1.21.1 {
    @Override
    public <M extends class_1309> void render(
            class_1799 stack,
            SlotReference reference,
            class_4587 matrices,
            class_583<M> model,
            class_4597 multiBufferSource,
            int light,
            float limbSwing,
            float limbSwingAmount,
            float partialTicks,
            float ageInTicks,
            float netHeadYaw,
            float headPitch
    ) {
        align(stack, reference, model, matrices);
        class_310.method_1551().method_1541().method_3353(
                class_2248.method_9503(stack.method_7909()).method_9564(),
                matrices, multiBufferSource, light, class_4608.field_21444
        );
    }

    @Override
    public <M extends class_1309> void align(class_1799 stack, SlotReference reference, class_583<M> model, class_4587 matrices) {
        if (model instanceof class_572<? extends class_1309> humanoidModel) {
            class_243 offset = GameplayUtil.hasArmor(reference) ? new class_243(0.05f, -1.25f, 0.05f) : new class_243(-0.1f, -1.25f, -0.1f);
            AccessoryRenderer.transformToModelPart(matrices, humanoidModel.field_3391, offset.field_1352, offset.field_1351, offset.field_1350);
        }
    }
    //?} else {
	/*@Override
	public <S extends LivingEntityRenderState> void render(
			AccessoryRenderState accessoryState, S renderState, EntityModel<S> entityModel, PoseStack matrices, SubmitNodeCollector collector
	) {
		align(accessoryState, renderState, entityModel, matrices);
		collector.submitBlock(
				matrices,
				Block.byItem(accessoryState.getStateData(AccessoriesRenderStateKeys.ITEM_STACK).getItem()).defaultBlockState(),
				renderState.lightCoords,
				OverlayTexture.NO_OVERLAY,
				renderState.outlineColor
		);
	}

	@Override
	public <S extends LivingEntityRenderState> void align(
			AccessoryRenderState accessoryState, S renderState, EntityModel<S> entityModel, PoseStack poseStack
	) {
		if (entityModel instanceof HumanoidModel<? extends HumanoidRenderState> humanoidModel && renderState instanceof HumanoidRenderState humanoidRenderState) {
			Vec3 offset = !humanoidRenderState.chestEquipment.isEmpty() || !humanoidRenderState.legsEquipment.isEmpty() ?
					new Vec3(0.05f, -1.25f, 0.05f) : new Vec3(-0.1f, -1.25f, -0.1f);
			AccessoryRenderer.transformToModelPart(poseStack, humanoidModel.body, offset.x, offset.y, offset.z);
		}
	}
	*///?}
}
