package me.pajic.accessorify.util;

import com.google.common.collect.HashMultimap;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.AccessoriesContainer;
import io.wispforest.accessories.api.client.AccessoriesRendererRegistry;
import io.wispforest.accessories.api.Accessory;
import io.wispforest.accessories.api.slot.SlotEntryReference;
import io.wispforest.accessories.api.slot.SlotReference;
import io.wispforest.accessories.utils.AttributeUtils;
import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.booleans.BooleanObjectImmutablePair;
import me.pajic.accessorify.Accessorify;
import me.pajic.accessorify.renderer.LanternAccessoryRenderer;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_1770;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import io.wispforest.accessories.api.AccessoriesAPI;
//?} else {
/*import io.wispforest.accessories.api.core.AccessoryRegistry;
*///?}

import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;

public class AccessoryUtil {

	public static class_1799 getAccessoryStack(class_1309 entity, class_1792 item) {
		Optional<AccessoriesCapability> ac = AccessoriesCapability.getOptionally(entity);
		if (ac.isPresent() && ac.get().isEquipped(item)) {
			SlotEntryReference itemRef = ac.get().getFirstEquipped(item);
			if (itemRef != null) return itemRef.stack();
		}
		return class_1799.field_8037;
	}

	public static class_1799 getAccessoryStack(class_1309 entity, Predicate<class_1799> predicate) {
		Optional<AccessoriesCapability> ac = AccessoriesCapability.getOptionally(entity);
		if (ac.isPresent()) {
			List<SlotEntryReference> matchingItems = ac.get().getEquipped(predicate);
			if (!matchingItems.isEmpty()) return matchingItems.get(0).stack();
		}
		return class_1799.field_8037;
	}

	public static BooleanObjectImmutablePair<class_1799> getAccessoryStackWithRenderState(class_1309 entity, Predicate<class_1799> predicate) {
		Optional<AccessoriesCapability> ac = AccessoriesCapability.getOptionally(entity);
		if (ac.isPresent() && ac.get().isEquipped(predicate)) {
			SlotEntryReference itemRef = ac.get().getFirstEquipped(predicate);
			if (itemRef != null) {
				AccessoriesContainer container = itemRef.reference().slotContainer();
				boolean visible = true;
				if (container != null) visible = container.renderOptions().get(0);
				return new BooleanObjectImmutablePair<>(visible, itemRef.stack());
			}
		}
		return new BooleanObjectImmutablePair<>(false, class_1799.field_8037);
	}

	public static boolean isAccessoryEquipped(class_1309 entity, class_1792 item) {
		Optional<AccessoriesCapability> playerCapability = AccessoriesCapability.getOptionally(entity);
		return playerCapability.map(accessoriesCapability -> accessoriesCapability.isEquipped(item)).orElse(false);
	}

	public static boolean isAccessoryEquipped(class_1309 entity, Predicate<class_1799> predicate) {
		Optional<AccessoriesCapability> playerCapability = AccessoriesCapability.getOptionally(entity);
		return playerCapability.map(accessoriesCapability -> accessoriesCapability.isEquipped(predicate)).orElse(false);
	}

	@SuppressWarnings("ConstantConditions")
	public static boolean isAnotherEquipped(class_1799 stack, SlotReference slot, class_1792 item) {
		//? if 1.20.1
		return slot.capability().isAnotherEquipped(slot, item);
		//? if > 1.20.1
		//return slot.capability().isAnotherEquipped(stack, slot, item);
	}

	@SuppressWarnings("ConstantConditions")
	public static boolean isAnotherEquipped(class_1799 stack, SlotReference slot, Predicate<class_1799> predicate) {
		//? if 1.20.1
		return slot.capability().isAnotherEquipped(slot, predicate);
		//? if > 1.20.1
		//return slot.capability().isAnotherEquipped(stack, slot, predicate);
	}

	public static void putAddAttributeModifier(HashMultimap<String, class_1322> map, String slot, String path) {
		//? if 1.20.1 {
        Pair<String, UUID> data = AttributeUtils.getModifierData(Accessorify.id(path));
        map.put(slot, new class_1322(data.second(), data.first(), 1, operationAdd()));
        //?}
		//? if > 1.20.1
		//map.put(slot, new AttributeModifier(Accessorify.id(path), 1, operationAdd()));
	}

	public static class_1322.class_1323 operationAdd() {
		//? if 1.20.1
		return class_1322.class_1323.field_6328;
		//? if > 1.20.1
		//return AttributeModifier.Operation.ADD_VALUE;
	}

    public static void registerAccessory(class_1792 item, Accessory accessory) {
        //? if <= 1.21.1
        AccessoriesAPI.registerAccessory(item, accessory);
        //? if > 1.21.1
        //AccessoryRegistry.register(item, accessory);
    }

    public static void registerEmptyRenderer(class_1792... items) {
        for (class_1792 item : items) {
            //? if <= 1.21.1
            AccessoriesRendererRegistry.registerNoRenderer(item);
            //? if > 1.21.1
            //AccessoriesRendererRegistry.bindItemToEmptyRenderer(item);
        }
    }

    public static void bindItemToLanternRenderer(class_1792 item) {
        //? if <= 1.21.1
        AccessoriesRendererRegistry.registerRenderer(item, LanternAccessoryRenderer::new);
        //? if > 1.21.1
        //AccessoriesRendererRegistry.bindItemToRenderer(item, Accessorify.id("lantern_renderer"));
    }

	//? if <= 1.21.1 {
    public static boolean moddedElytraCheck(class_1799 stack, class_1309 livingEntity, boolean original) {
        if (
                !getAccessoryStack(livingEntity, GameplayUtil::isElytra).method_7960() &&
                !(livingEntity.method_6118(class_1304.field_6174).method_7909() instanceof class_1770)
        ) {
            return stack.method_7909() instanceof class_1770;
        }
        return original;
    }
    //?}
}
