package me.pajic.accessorify.util.compat;

//? if fabric && < 1.21.10 {

import io.github.lucaargolo.seasons.FabricSeasons;
import io.github.lucaargolo.seasons.utils.Season;
import io.github.lucaargolo.seasonsextras.FabricSeasonsExtras;
import it.unimi.dsi.fastutil.objects.ObjectIntImmutablePair;
import me.pajic.accessorify.AccessorifyClient;
import me.pajic.accessorify.util.AccessoryUtil;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2561;

public class FabricSeasonsCompat {
    public static ObjectIntImmutablePair<class_2561> getSeasonStringData(class_1937 level) {
        Season season = FabricSeasons.getCurrentSeason(level);
        return ObjectIntImmutablePair.of(
                switch (season) {
                    case SPRING -> class_2561.method_43471("gui.accessorify.spring");
                    case SUMMER -> class_2561.method_43471("gui.accessorify.summer");
                    case FALL -> class_2561.method_43471("gui.accessorify.fall");
                    case WINTER -> class_2561.method_43471("gui.accessorify.winter");
                },
                switch (season) {
                    case SPRING -> AccessorifyClient.CONFIG.infoOverlaySettings.overlayColors.spring.get().argb();
                    case SUMMER -> AccessorifyClient.CONFIG.infoOverlaySettings.overlayColors.summer.get().argb();
                    case FALL -> AccessorifyClient.CONFIG.infoOverlaySettings.overlayColors.autumn.get().argb();
                    case WINTER -> AccessorifyClient.CONFIG.infoOverlaySettings.overlayColors.winter.get().argb();
                }
        );
    }

    public static boolean calendarAccessoryEquipped(class_1309 entity) {
        return AccessoryUtil.isAccessoryEquipped(entity, FabricSeasonsExtras.SEASON_CALENDAR_ITEM);
    }
}
//?}
