package me.pajic.accessorify.accessories;

import com.google.common.collect.HashMultimap;
import io.wispforest.accessories.api.Accessory;
import io.wispforest.accessories.api.slot.SlotReference;
import me.pajic.accessorify.Accessorify;
import me.pajic.accessorify.config.SlotMode;
import me.pajic.accessorify.util.AccessoryUtil;
import net.minecraft.class_1322;
import net.minecraft.class_1799;

@SuppressWarnings("ConstantConditions")
public interface AccessoryExtension extends Accessory {
    String getAttributePath();
    String getDefaultSlot();

    @Override
    default void onEquip(class_1799 stack, SlotReference reference) {
        if (Accessorify.CONFIG.slotMode.get() == SlotMode.DEFAULT_SLOT) {
            var map = HashMultimap.<String, class_1322>create();
            AccessoryUtil.putAddAttributeModifier(map, getDefaultSlot(), getAttributePath());
            reference.capability().addPersistentSlotModifiers(map);
        }
    }

    @Override
    default void onUnequip(class_1799 stack, SlotReference reference) {
        if (Accessorify.CONFIG.slotMode.get() == SlotMode.DEFAULT_SLOT) {
            var map = HashMultimap.<String, class_1322>create();
            AccessoryUtil.putAddAttributeModifier(map, getDefaultSlot(), getAttributePath());
            reference.capability().removeSlotModifiers(map);
        }
    }
}
