package me.pajic.accessorify.accessories;

import io.wispforest.accessories.api.attributes.AccessoryAttributeBuilder;
import io.wispforest.accessories.api.slot.SlotReference;
import me.pajic.accessorify.Accessorify;
import me.pajic.accessorify.util.AccessoryUtil;
//? if 1.21.1 {
import me.pajic.accessorify.util.CompatFlags;
import me.pajic.accessorify.util.compat.AileronCompat;
import net.minecraft.class_1770;
import net.minecraft.class_1799;
import net.minecraft.class_7924;

public class ElytraAccessory implements AccessoryExtension {

    @Override
    public String getAttributePath() {
        return "add_cape";
    }

    @Override
    public String getDefaultSlot() {
        return "cape";
    }

    @Override
    public void getDynamicModifiers(class_1799 stack, SlotReference reference, AccessoryAttributeBuilder builder) {
        //? if 1.21.1
        if (CompatFlags.AILERON_LOADED) AileronCompat.addModifiers(builder, stack, reference.entity().method_37908().method_30349().method_46762(class_7924.field_41265));
    }

    @Override
    public boolean canEquip(class_1799 stack, SlotReference reference) {
        return !AccessoryUtil.isAnotherEquipped(stack, reference,
                //? if <= 1.21.1
                itemStack -> itemStack.method_7909() instanceof class_1770
                //? if > 1.21.1
                //itemStack -> itemStack.has(DataComponents.GLIDER)
        );
    }

	@Override
	public boolean canEquipFromUse(class_1799 stack, SlotReference reference) {
		return !Accessorify.CONFIG.preventElytraRightClickEquip.get() && AccessoryExtension.super.canEquipFromUse(stack, reference);
	}
}
