package me.pajic.accessorify.mixin;

import com.llamalad7.mixinextras.injector.v2.WrapWithCondition;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import dev.kikugie.fletching_table.annotation.MixinEnvironment;
import me.pajic.accessorify.keybind.ModScrollHandler;
import net.minecraft.class_1661;
import net.minecraft.class_312;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;

@MixinEnvironment(type = MixinEnvironment.Env.CLIENT)
@Mixin(class_312.class)
public class MouseHandlerMixin {

    //? if <= 1.21.1 {
    @WrapWithCondition(
            method = "onScroll",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/world/entity/player/Inventory;swapPaint(D)V"
            )
    )
    private boolean redirectScroll(class_1661 instance, double direction) {
        return ModScrollHandler.handleMouseScroll(instance, (int) Math.signum(direction));
    }
    //?} else {
    /*@WrapOperation(
            method = "onScroll",
            at = @At(
                    value = "INVOKE",
                    //? if < 1.21.10
                    target = "Lnet/minecraft/world/entity/player/Inventory;setSelectedHotbarSlot(I)V"
                    //? if >= 1.21.10
                    //target = "Lnet/minecraft/world/entity/player/Inventory;setSelectedSlot(I)V"
            )
    )
    private void redirectScroll(Inventory instance, int selectedHotbarSlot, Operation<Void> original, @Local int i) {
        if (ModScrollHandler.handleMouseScroll(instance, (int) Math.signum(i))) original.call(instance, selectedHotbarSlot);
    }
    *///?}
}
