package me.pajic.accessorify.mixin;

import me.pajic.accessorify.util.PlayerExtension;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_1657.class)
public class PlayerExtensionDataMixin implements PlayerExtension {
    @Unique private int shulkerSlot;
    @Unique private int arrowSlot;

    @Override
    public int accessorify$getShulkerSlot() {
        return shulkerSlot;
    }

    @Override
    public void accessorify$setShulkerSlot(int value) {
        shulkerSlot = value;
    }

    @Override
    public int accessorify$getArrowSlot() {
        return arrowSlot;
    }

    @Override
    public void accessorify$setArrowSlot(int value) {
        arrowSlot = value;
    }

    //? if < 1.21.10 {
    @Inject(
            method = "addAdditionalSaveData",
            at = @At("TAIL")
    )
    private void addArrowSlot(class_2487 compound, CallbackInfo ci) {
        compound.method_10569("ShulkerSlot", shulkerSlot);
        compound.method_10569("ArrowSlot", arrowSlot);
    }

    @Inject(
            method = "readAdditionalSaveData",
            at = @At("TAIL")
    )
    private void readArrowSlot(class_2487 compound, CallbackInfo ci) {
        shulkerSlot = compound.method_10550("ShulkerSlot");
        arrowSlot = compound.method_10550("ArrowSlot");
    }
    //?} else {
    /*@Inject(
            method = "addAdditionalSaveData",
            at = @At("TAIL")
    )
    private void addArrowSlot(ValueOutput output, CallbackInfo ci) {
        output.putInt("ShulkerSlot", shulkerSlot);
        output.putInt("ArrowSlot", arrowSlot);
    }

    @Inject(
            method = "readAdditionalSaveData",
            at = @At("TAIL")
    )
    private void readArrowSlot(ValueInput input, CallbackInfo ci) {
        shulkerSlot = input.getIntOr("ShulkerSlot", 0);
        arrowSlot = input.getIntOr("ArrowSlot", 0);
    }
    *///?}
}
