/*
 * Decompiled with CFR 0.152.
 */
package me.pajic.accessorify.gui;

import it.unimi.dsi.fastutil.ints.IntIntImmutablePair;
import it.unimi.dsi.fastutil.objects.ObjectIntImmutablePair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import me.fzzyhmstrs.fzzy_config.validation.misc.ValidatedColor;
import me.pajic.accessorify.ClientMain;
import me.pajic.accessorify.Main;
import me.pajic.accessorify.gui.OverlayPosition;
import me.pajic.accessorify.util.ModUtil;
import me.pajic.accessorify.util.MultiVersionUtil;
import me.pajic.accessorify.util.compat.CompatFlags;
import me.pajic.accessorify.util.compat.RaisedCompat;
import me.pajic.accessorify.util.compat.SereneSeasonsCompat;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.RenderGuiEvent;

public class InfoOverlays {
    private static final List<ObjectIntImmutablePair<Component>> renderList = new ArrayList<ObjectIntImmutablePair<Component>>();
    private static final Minecraft MC = Minecraft.getInstance();

    @SubscribeEvent
    public static void renderInfoOverlays(RenderGuiEvent.Post event) {
        GuiGraphics guiGraphics = event.getGuiGraphics();
        if (InfoOverlays.MC.player != null && InfoOverlays.MC.level != null && !InfoOverlays.MC.options.hideGui && !MultiVersionUtil.debugScreenShown()) {
            boolean shouldObfuscateClock;
            boolean shouldObfuscateCompass = (Boolean)Main.CONFIG.infoOverlaySettings.obfuscateCompassIfNotOverworld.get() != false && InfoOverlays.MC.level.dimension() != Level.OVERWORLD;
            boolean bl = shouldObfuscateClock = (Boolean)Main.CONFIG.infoOverlaySettings.obfuscateClockIfNotOverworld.get() != false && InfoOverlays.MC.level.dimension() != Level.OVERWORLD;
            if (((Boolean)Main.CONFIG.accessorySettings.compassAccessory.get()).booleanValue() && ModUtil.accessoryEquipped((LivingEntity)InfoOverlays.MC.player, Items.COMPASS)) {
                InfoOverlays.prepareCompassOverlay(shouldObfuscateCompass);
            }
            if (((Boolean)Main.CONFIG.accessorySettings.clockAccessory.get()).booleanValue() && ModUtil.accessoryEquipped((LivingEntity)InfoOverlays.MC.player, Items.CLOCK)) {
                InfoOverlays.prepareClockOverlay(shouldObfuscateClock);
            }
            if (ModUtil.calendarUsedForSeasonInfo() && ModUtil.calendarAccessoryEquipped((LivingEntity)InfoOverlays.MC.player)) {
                InfoOverlays.prepareSeasonString(shouldObfuscateClock);
            }
            if (((Boolean)Main.CONFIG.accessorySettings.recoveryCompassAccessory.get()).booleanValue() && ModUtil.accessoryEquipped((LivingEntity)InfoOverlays.MC.player, Items.RECOVERY_COMPASS)) {
                InfoOverlays.prepareRecoveryCompassOverlay();
            }
            if (!renderList.isEmpty()) {
                InfoOverlays.renderLines(guiGraphics);
                renderList.clear();
            }
        }
    }

    private static void prepareCompassOverlay(boolean shouldObfuscate) {
        if (shouldObfuscate) {
            if (((Boolean)Main.CONFIG.infoOverlaySettings.useObfuscationEffect.get()).booleanValue()) {
                MutableComponent obfuscatedText = Component.literal((String)(String.valueOf(ChatFormatting.WHITE) + String.valueOf(ChatFormatting.OBFUSCATED) + "XXXXXXXX".substring(0, InfoOverlays.MC.level.random.nextInt(4) + 3)));
                if (((Boolean)Main.CONFIG.infoOverlaySettings.overlayFields.coordinates.get()).booleanValue()) {
                    renderList.add((ObjectIntImmutablePair<Component>)new ObjectIntImmutablePair((Object)obfuscatedText, -1));
                }
                if (((Boolean)Main.CONFIG.infoOverlaySettings.overlayFields.direction.get()).booleanValue()) {
                    renderList.add((ObjectIntImmutablePair<Component>)new ObjectIntImmutablePair((Object)obfuscatedText, -1));
                }
                if (((Boolean)Main.CONFIG.infoOverlaySettings.overlayFields.biome.get()).booleanValue()) {
                    renderList.add((ObjectIntImmutablePair<Component>)new ObjectIntImmutablePair((Object)obfuscatedText, -1));
                }
            }
        } else {
            BlockPos blockPos = InfoOverlays.MC.player.blockPosition();
            if (((Boolean)Main.CONFIG.infoOverlaySettings.overlayFields.coordinates.get()).booleanValue()) {
                MutableComponent coordinates = (Boolean)Main.CONFIG.infoOverlaySettings.showYCoordinate.get() != false ? Component.translatable((String)"gui.accessorify.coordinates_xyz", (Object[])new Object[]{blockPos.getX(), blockPos.getY(), blockPos.getZ()}) : Component.translatable((String)"gui.accessorify.coordinates_xz", (Object[])new Object[]{blockPos.getX(), blockPos.getZ()});
                renderList.add((ObjectIntImmutablePair<Component>)new ObjectIntImmutablePair((Object)coordinates, -1));
            }
            if (((Boolean)Main.CONFIG.infoOverlaySettings.overlayFields.direction.get()).booleanValue()) {
                MutableComponent direction = Component.translatable((String)"gui.accessorify.facing", (Object[])new Object[]{InfoOverlays.MC.player.getDirection().getName()});
                renderList.add((ObjectIntImmutablePair<Component>)new ObjectIntImmutablePair((Object)direction, -1));
            }
            if (((Boolean)Main.CONFIG.infoOverlaySettings.overlayFields.biome.get()).booleanValue()) {
                ResourceLocation biome = (ResourceLocation)InfoOverlays.MC.player.level().getBiome(blockPos).unwrap().map(key -> key != null ? key.location() : null, unknown -> null);
                MutableComponent biomeName = Component.translatable((String)("biome." + biome.getNamespace() + "." + biome.getPath()));
                renderList.add((ObjectIntImmutablePair<Component>)new ObjectIntImmutablePair((Object)biomeName, -1));
            }
        }
    }

    private static void prepareClockOverlay(boolean shouldObfuscate) {
        if (shouldObfuscate) {
            if (((Boolean)Main.CONFIG.infoOverlaySettings.useObfuscationEffect.get()).booleanValue()) {
                MutableComponent obfuscatedText = Component.literal((String)(String.valueOf(ChatFormatting.WHITE) + String.valueOf(ChatFormatting.OBFUSCATED) + "XXXXXXXX".substring(0, InfoOverlays.MC.level.random.nextInt(4) + 3)));
                if (((Boolean)Main.CONFIG.infoOverlaySettings.overlayFields.dayAndTime.get()).booleanValue()) {
                    renderList.add((ObjectIntImmutablePair<Component>)new ObjectIntImmutablePair((Object)obfuscatedText, -1));
                }
                if (((Boolean)Main.CONFIG.infoOverlaySettings.overlayFields.weather.get()).booleanValue()) {
                    renderList.add((ObjectIntImmutablePair<Component>)new ObjectIntImmutablePair((Object)obfuscatedText, -1));
                }
                if (((Boolean)Main.CONFIG.infoOverlaySettings.overlayFields.moonPhase.get()).booleanValue()) {
                    renderList.add((ObjectIntImmutablePair<Component>)new ObjectIntImmutablePair((Object)obfuscatedText, -1));
                }
            }
        } else {
            BlockPos blockPos = InfoOverlays.MC.player.blockPosition();
            if (((Boolean)Main.CONFIG.infoOverlaySettings.overlayFields.dayAndTime.get()).booleanValue()) {
                MutableComponent dayAndTime = Component.translatable((String)"gui.accessorify.day", (Object[])new Object[]{InfoOverlays.MC.level.getDayTime() / 24000L + 1L});
                long timeOffset = (InfoOverlays.MC.level.getDayTime() + 6000L) % 24000L;
                MutableComponent time = Component.translatable((String)"gui.accessorify.time", (Object[])new Object[]{timeOffset / 1000L, String.format("%02d", (int)((double)(timeOffset / 10L % 100L) / 100.0 * 60.0))});
                dayAndTime.append(", ");
                dayAndTime.append((Component)time);
                renderList.add((ObjectIntImmutablePair<Component>)new ObjectIntImmutablePair((Object)dayAndTime, -1));
            }
            if (((Boolean)Main.CONFIG.infoOverlaySettings.overlayFields.weather.get()).booleanValue()) {
                int weatherColor;
                MutableComponent weather;
                if (InfoOverlays.MC.level.isThundering()) {
                    weather = Component.translatable((String)"gui.accessorify.thundering");
                    weatherColor = ((ValidatedColor.ColorHolder)ClientMain.CLIENT_CONFIG.infoOverlaySettings.overlayColors.thundering.get()).argb();
                } else if (InfoOverlays.MC.level.isRaining()) {
                    Biome.Precipitation precipitation = ((Biome)InfoOverlays.MC.level.getBiome(blockPos).value()).getPrecipitationAt(blockPos, (int)InfoOverlays.MC.player.getY());
                    if (precipitation == Biome.Precipitation.RAIN) {
                        weather = Component.translatable((String)"gui.accessorify.raining");
                        weatherColor = ((ValidatedColor.ColorHolder)ClientMain.CLIENT_CONFIG.infoOverlaySettings.overlayColors.raining.get()).argb();
                    } else if (precipitation == Biome.Precipitation.SNOW) {
                        weather = Component.translatable((String)"gui.accessorify.snowing");
                        weatherColor = ((ValidatedColor.ColorHolder)ClientMain.CLIENT_CONFIG.infoOverlaySettings.overlayColors.snowing.get()).argb();
                    } else {
                        weather = Component.translatable((String)"gui.accessorify.cloudy");
                        weatherColor = ((ValidatedColor.ColorHolder)ClientMain.CLIENT_CONFIG.infoOverlaySettings.overlayColors.cloudy.get()).argb();
                    }
                } else {
                    weather = Component.translatable((String)"gui.accessorify.clear");
                    weatherColor = -1;
                }
                if (((Boolean)ClientMain.CLIENT_CONFIG.infoOverlaySettings.coloredWeather.get()).booleanValue()) {
                    renderList.add((ObjectIntImmutablePair<Component>)new ObjectIntImmutablePair((Object)weather, weatherColor));
                } else {
                    renderList.add((ObjectIntImmutablePair<Component>)new ObjectIntImmutablePair((Object)weather, -1));
                }
            }
            if (((Boolean)Main.CONFIG.infoOverlaySettings.overlayFields.moonPhase.get()).booleanValue()) {
                renderList.add((ObjectIntImmutablePair<Component>)new ObjectIntImmutablePair((Object)(switch (InfoOverlays.MC.level.getMoonPhase()) {
                    case 0 -> Component.literal((String)"\ud83c\udf11 ").append((Component)Component.translatable((String)"gui.accessorify.full_moon"));
                    case 1 -> Component.literal((String)"\ud83c\udf18 ").append((Component)Component.translatable((String)"gui.accessorify.waning_gibbous"));
                    case 2 -> Component.literal((String)"\ud83c\udf17 ").append((Component)Component.translatable((String)"gui.accessorify.last_quarter"));
                    case 3 -> Component.literal((String)"\ud83c\udf16 ").append((Component)Component.translatable((String)"gui.accessorify.waning_crescent"));
                    case 4 -> Component.literal((String)"\ud83c\udf15 ").append((Component)Component.translatable((String)"gui.accessorify.new_moon"));
                    case 5 -> Component.literal((String)"\ud83c\udf14 ").append((Component)Component.translatable((String)"gui.accessorify.waxing_crescent"));
                    case 6 -> Component.literal((String)"\ud83c\udf13 ").append((Component)Component.translatable((String)"gui.accessorify.first_quarter"));
                    case 7 -> Component.literal((String)"\ud83c\udf12 ").append((Component)Component.translatable((String)"gui.accessorify.waxing_gibbous"));
                    default -> Component.literal((String)"\ud83d\udca5 ").append((Component)Component.translatable((String)"gui.accessorify.moon_default"));
                }), -1));
            }
        }
        if (!ModUtil.calendarUsedForSeasonInfo()) {
            InfoOverlays.prepareSeasonString(shouldObfuscate);
        }
    }

    private static void prepareSeasonString(boolean shouldObfuscate) {
        if (shouldObfuscate && CompatFlags.SERENE_SEASONS_LOADED) {
            if (((Boolean)Main.CONFIG.infoOverlaySettings.useObfuscationEffect.get()).booleanValue()) {
                MutableComponent obfuscatedText = Component.literal((String)(String.valueOf(ChatFormatting.WHITE) + String.valueOf(ChatFormatting.OBFUSCATED) + "XXXXXXXX".substring(0, InfoOverlays.MC.level.random.nextInt(4) + 3)));
                if (((Boolean)Main.CONFIG.infoOverlaySettings.overlayFields.season.get()).booleanValue()) {
                    renderList.add((ObjectIntImmutablePair<Component>)new ObjectIntImmutablePair((Object)obfuscatedText, -1));
                }
            }
        } else if (((Boolean)Main.CONFIG.infoOverlaySettings.overlayFields.season.get()).booleanValue()) {
            ObjectIntImmutablePair<Component> seasonStringData = null;
            if (CompatFlags.SERENE_SEASONS_LOADED) {
                seasonStringData = SereneSeasonsCompat.getSeasonStringData((Level)InfoOverlays.MC.level);
            }
            if (seasonStringData != null) {
                if (((Boolean)ClientMain.CLIENT_CONFIG.infoOverlaySettings.coloredSeason.get()).booleanValue()) {
                    renderList.add(seasonStringData);
                } else {
                    renderList.add((ObjectIntImmutablePair<Component>)new ObjectIntImmutablePair((Object)((Component)seasonStringData.left()), -1));
                }
            }
        }
    }

    private static void prepareRecoveryCompassOverlay() {
        if (((Boolean)Main.CONFIG.infoOverlaySettings.overlayFields.lastDeathLocation.get()).booleanValue()) {
            Optional optional = InfoOverlays.MC.player.getLastDeathLocation();
            if (optional.isPresent()) {
                if (((GlobalPos)optional.get()).dimension() == InfoOverlays.MC.level.dimension()) {
                    BlockPos lastDeathLocation = ((GlobalPos)optional.get()).pos();
                    MutableComponent coordinates = (Boolean)Main.CONFIG.infoOverlaySettings.showYCoordinate.get() != false ? Component.translatable((String)"gui.accessorify.coordinates_xyz", (Object[])new Object[]{lastDeathLocation.getX(), lastDeathLocation.getY(), lastDeathLocation.getZ()}) : Component.translatable((String)"gui.accessorify.coordinates_xz", (Object[])new Object[]{lastDeathLocation.getX(), lastDeathLocation.getZ()});
                    renderList.add((ObjectIntImmutablePair<Component>)new ObjectIntImmutablePair((Object)Component.translatable((String)"gui.accessorify.last_death_location"), -1));
                    renderList.add((ObjectIntImmutablePair<Component>)new ObjectIntImmutablePair((Object)coordinates, -1));
                } else {
                    renderList.add((ObjectIntImmutablePair<Component>)new ObjectIntImmutablePair((Object)Component.translatable((String)"gui.accessorify.last_death_location_wrong_dimension"), -1));
                }
            } else {
                renderList.add((ObjectIntImmutablePair<Component>)new ObjectIntImmutablePair((Object)Component.translatable((String)"gui.accessorify.last_death_location_unavailable"), -1));
            }
        }
    }

    private static void renderLines(GuiGraphics guiGraphics) {
        int y = 4;
        OverlayPosition position = (OverlayPosition)((Object)ClientMain.CLIENT_CONFIG.infoOverlaySettings.position.get());
        if (position == OverlayPosition.BOTTOM_LEFT || position == OverlayPosition.BOTTOM_RIGHT) {
            Collections.reverse(renderList);
        }
        for (ObjectIntImmutablePair<Component> line : renderList) {
            InfoOverlays.renderLine(guiGraphics, InfoOverlays.MC.font, (Component)line.left(), y, line.rightInt());
            y += 12;
        }
    }

    private static void renderLine(GuiGraphics guiGraphics, Font font, Component text, int lineY, int color) {
        int width = MC.getWindow().getGuiScaledWidth();
        int height = MC.getWindow().getGuiScaledHeight();
        int offsetX = (Integer)ClientMain.CLIENT_CONFIG.infoOverlaySettings.offsetX.get();
        int offsetY = (Integer)ClientMain.CLIENT_CONFIG.infoOverlaySettings.offsetY.get();
        int raisedOffsetX = 0;
        int raisedOffsetY = 0;
        if (CompatFlags.RAISED_LOADED) {
            IntIntImmutablePair offsets = RaisedCompat.getOtherComponentOffsets();
            raisedOffsetX = offsets.leftInt();
            raisedOffsetY = offsets.rightInt();
        }
        IntIntImmutablePair position = switch ((OverlayPosition)((Object)ClientMain.CLIENT_CONFIG.infoOverlaySettings.position.get())) {
            case OverlayPosition.TOP_RIGHT -> new IntIntImmutablePair(width - 4 - InfoOverlays.MC.font.width((FormattedText)text) - offsetX + raisedOffsetX, lineY + offsetY + raisedOffsetY);
            case OverlayPosition.BOTTOM_LEFT -> new IntIntImmutablePair(4 + offsetX + raisedOffsetX, height - 8 - lineY - offsetY + raisedOffsetY);
            case OverlayPosition.BOTTOM_RIGHT -> new IntIntImmutablePair(width - 4 - InfoOverlays.MC.font.width((FormattedText)text) - offsetX + raisedOffsetX, height - 8 - lineY - offsetY + raisedOffsetY);
            default -> new IntIntImmutablePair(4 + offsetX + raisedOffsetX, lineY + offsetY + raisedOffsetY);
        };
        int x = position.leftInt();
        int y = position.rightInt();
        MultiVersionUtil.startRender(guiGraphics);
        if (((Boolean)ClientMain.CLIENT_CONFIG.infoOverlaySettings.textBackground.get()).booleanValue()) {
            guiGraphics.fill(x - 2, y - 2, x + font.width((FormattedText)text) + 2, y + 10, MultiVersionUtil.color(MultiVersionUtil.as8BitChannel(((Float)ClientMain.CLIENT_CONFIG.infoOverlaySettings.textBackgroundOpacity.get()).floatValue()), 0, 0, 0));
        }
        guiGraphics.drawString(font, text, x, y, color, ((Boolean)ClientMain.CLIENT_CONFIG.infoOverlaySettings.textShadow.get()).booleanValue());
        MultiVersionUtil.stopRender(guiGraphics);
    }
}

