/*
 * Decompiled with CFR 0.152.
 */
package me.pajic.accessorify.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.AccessoriesContainer;
import io.wispforest.accessories.data.SlotTypeLoader;
import io.wispforest.accessories.impl.core.ExpandedContainer;
import java.util.Optional;
import me.pajic.accessorify.Main;
import net.minecraft.stats.Stats;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={ItemEntity.class})
public abstract class ItemEntityMixin
extends Entity {
    public ItemEntityMixin(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    @Shadow
    public abstract ItemStack getItem();

    @Shadow
    public abstract void setItem(ItemStack var1);

    @WrapOperation(method={"playerTouch"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Inventory;add(Lnet/minecraft/world/item/ItemStack;)Z")})
    private boolean addArrowsToAccessorySlots(Inventory instance, ItemStack itemStack, Operation<Boolean> original, @Local(argsOnly=true) Player player) {
        ExpandedContainer arrows;
        AccessoriesContainer container;
        Optional ac;
        if (itemStack.is(ItemTags.ARROWS) && ((Boolean)Main.CONFIG.accessorySettings.arrowAccessory.get()).booleanValue() && (ac = AccessoriesCapability.getOptionally((LivingEntity)player)).isPresent() && (container = ((AccessoriesCapability)ac.get()).getContainer(SlotTypeLoader.getSlotType((LivingEntity)player, (String)"arrow"))) != null && !(arrows = container.getAccessories()).getItems().stream().allMatch(ItemStack::isEmpty) && arrows.canAddItem(itemStack)) {
            ItemEntity itemEntity = (ItemEntity)this;
            int i = itemStack.getCount();
            ItemStack updated = arrows.addItem(itemStack);
            this.setItem(updated);
            player.take((Entity)itemEntity, i);
            player.awardStat(Stats.ITEM_PICKED_UP.get((Object)itemStack.getItem()), i);
            player.onItemPickup(itemEntity);
            if (updated.isEmpty()) {
                this.discard();
                return false;
            }
            return (Boolean)original.call(new Object[]{instance, updated});
        }
        return (Boolean)original.call(new Object[]{instance, itemStack});
    }
}

