/*
 * Decompiled with CFR 0.152.
 */
package me.pajic.accessorify.util;

import io.wispforest.accessories.api.slot.SlotReference;
import io.wispforest.accessories.impl.ExpandedSimpleContainer;
import java.util.List;
import me.pajic.accessorify.Accessorify;
import me.pajic.accessorify.util.CompatFlags;
import me.pajic.accessorify.util.GeneralUtil;
import me.pajic.accessorify.util.compat.SereneSeasonsCompat;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ElytraItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ProjectileWeaponItem;

public class GameplayUtil {
    public static boolean isTotem(ItemStack stack) {
        return stack.is(Items.TOTEM_OF_UNDYING);
    }

    public static boolean isLantern(ItemStack stack) {
        return stack.is(GeneralUtil.LANTERNS);
    }

    public static boolean isElytra(ItemStack stack) {
        return stack.getItem() instanceof ElytraItem;
    }

    public static boolean isHoldingProjectileWeapon(Player player) {
        for (ItemStack stack : player.getHandSlots()) {
            if (!(stack.getItem() instanceof ProjectileWeaponItem)) continue;
            return true;
        }
        return false;
    }

    public static List<ItemStack> getContainerItems(ExpandedSimpleContainer container) {
        return container.getItems();
    }

    public static boolean calendarAccessoryEquipped(LivingEntity entity) {
        if (CompatFlags.SERENE_SEASONS_LOADED) {
            return SereneSeasonsCompat.calendarAccessoryEquipped(entity);
        }
        return false;
    }

    public static boolean calendarUsedForSeasonInfo() {
        return (Boolean)Accessorify.CONFIG.accessorySettings.calendarAccessory.get() != false && (CompatFlags.SERENE_SEASONS_LOADED || CompatFlags.FABRIC_SEASONS_LOADED);
    }

    public static boolean hasArmor(SlotReference reference) {
        LivingEntity livingEntity = reference.entity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            for (ItemStack stack : player.getArmorSlots()) {
                ArmorItem armorItem;
                Item item = stack.getItem();
                if (!(item instanceof ArmorItem) || (armorItem = (ArmorItem)item).getType() != ArmorItem.Type.CHESTPLATE && armorItem.getType() != ArmorItem.Type.LEGGINGS) continue;
                return true;
            }
        }
        return false;
    }
}

