package de.keksuccino.melody.mixin.mixins.common.client;

import de.keksuccino.melody.resources.audio.MinecraftSoundSettingsObserver;
import net.minecraft.class_1140;
import net.minecraft.class_315;
import net.minecraft.class_3419;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_1140.class)
public class MixinSoundEngine {

    @Unique private static final Logger LOGGER_MELODY = LogManager.getLogger();

    @Shadow private boolean loaded;
    @Shadow @Final private class_315 options;

    @Inject(method = "updateCategoryVolume", at = @At("RETURN"))
    private void afterUpdateVolumeCategoryMelody(class_3419 source, CallbackInfo ci) {
        if (this.loaded) {
            //Notify all volume listeners of MinecraftSoundSettingsObserver
            MinecraftSoundSettingsObserver.getVolumeListeners().forEach(soundSourceFloatBiConsumer -> soundSourceFloatBiConsumer.accept(source, this.options.method_1630(source)));
        }
    }

    @Inject(method = "reload", at = @At("RETURN"))
    private void afterReloadSoundEngineMelody(CallbackInfo info) {
        //Notify all reload listeners of MinecraftSoundSettingsObserver
        MinecraftSoundSettingsObserver.getSoundEngineReloadListeners().forEach(Runnable::run);
    }

}
