package de.keksuccino.melody.resources.audio;

import org.jetbrains.annotations.NotNull;
import java.util.*;
import java.util.function.BiConsumer;
import net.minecraft.class_1140;
import net.minecraft.class_3419;

@SuppressWarnings("unused")
public class MinecraftSoundSettingsObserver {

    private static final Map<Long, BiConsumer<class_3419, Float>> VOLUME_LISTENERS = new HashMap<>();
    private static final Map<Long, Runnable> SOUND_ENGINE_RELOAD_LISTENERS = new HashMap<>();

    private static long idCountVolumeListeners = 0L;
    private static long idCountEngineReloadListeners = 0L;

    /**
     * Registers the listener and returns the ID of the listener, to be able to unregister it later.<br>
     * Volume listeners get notified after the volume of a {@link class_3419} got changed.
     */
    public static long registerVolumeListener(@NotNull BiConsumer<class_3419, Float> listener) {
        Objects.requireNonNull(listener);
        idCountVolumeListeners++;
        VOLUME_LISTENERS.put(idCountVolumeListeners, listener);
        return idCountVolumeListeners;
    }

    public static void unregisterVolumeListener(long id) {
        VOLUME_LISTENERS.remove(id);
    }

    public static List<BiConsumer<class_3419, Float>> getVolumeListeners() {
        return new ArrayList<>(VOLUME_LISTENERS.values());
    }

    /**
     * Registers the listener and returns the ID of the listener, to be able to unregister it later.<br>
     * {@link class_1140} reload listeners get notified after {@link class_1140#method_4837()} got called.
     */
    public static long registerSoundEngineReloadListener(@NotNull Runnable listener) {
        Objects.requireNonNull(listener);
        idCountEngineReloadListeners++;
        SOUND_ENGINE_RELOAD_LISTENERS.put(idCountEngineReloadListeners, listener);
        return idCountEngineReloadListeners;
    }

    public static void unregisterSoundEngineReloadListener(long id) {
        SOUND_ENGINE_RELOAD_LISTENERS.remove(id);
    }

    public static List<Runnable> getSoundEngineReloadListeners() {
        return new ArrayList<>(SOUND_ENGINE_RELOAD_LISTENERS.values());
    }

}
