package de.keksuccino.melody.resources.audio.openal;

import de.keksuccino.melody.mixin.mixins.common.client.IMixinSoundEngine;
import de.keksuccino.melody.mixin.mixins.common.client.IMixinSoundManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.openal.AL10;
import javax.sound.sampled.AudioFormat;
import net.minecraft.class_1140;
import net.minecraft.class_1144;
import net.minecraft.class_310;
import net.minecraft.class_4225;
import java.io.InputStream;
import java.nio.ByteBuffer;

@SuppressWarnings("unused")
public class ALUtils {

    private static final Logger LOGGER = LogManager.getLogger();

    /**
     * OpenAL gets initialized in {@link class_4225#method_19661(String, boolean)}, which gets called when (re-)loading the {@link class_1140},
     * so this method checks for {@link IMixinSoundEngine#getLoadedMelody()}, to see if the {@link class_1140} is loaded.
     */
    public static boolean isOpenAlReady() {
        class_1144 manager = class_310.method_1551().method_1483();
        class_1140 engine = ((IMixinSoundManager)manager).getSoundEngineMelody();
        return ((IMixinSoundEngine)engine).getLoadedMelody();
    }

    public static int getAudioFormatAsOpenAL(@NotNull AudioFormat audioFormat) throws ALException {
        AudioFormat.Encoding encoding = audioFormat.getEncoding();
        int channels = audioFormat.getChannels();
        int sampleSize = audioFormat.getSampleSizeInBits();
        if (encoding.equals(AudioFormat.Encoding.PCM_UNSIGNED) || encoding.equals(AudioFormat.Encoding.PCM_SIGNED)) {
            if (channels == 1) {
                if (sampleSize == 8) {
                    return AL10.AL_FORMAT_MONO8;
                }
                if (sampleSize == 16) {
                    return AL10.AL_FORMAT_MONO16;
                }
            } else if (channels == 2) {
                if (sampleSize == 8) {
                    return AL10.AL_FORMAT_STEREO8;
                }
                if (sampleSize == 16) {
                    return AL10.AL_FORMAT_STEREO16;
                }
            }
        }
        throw new ALException("Failed to convert AudioFormat to OpenAL! Unsupported format: " + audioFormat);
    }

    @NotNull
    public static ByteBuffer readStreamIntoBuffer(@NotNull InputStream audioInputStream) throws Exception {
        byte[] array = audioInputStream.readAllBytes();
        //It's important to allocate the buffer, because otherwise OpenAL can't read it
        ByteBuffer buffer = ByteBuffer.allocateDirect(array.length);
        buffer.put(array);
        buffer.flip();
        return buffer;
    }

}
