/*
 * Decompiled with CFR 0.152.
 */
package iquldev;

import iquldev.ConfigManager;
import iquldev.DatabaseManager;
import iquldev.GuiManager;
import iquldev.Logger;
import iquldev.MessageUtils;
import iquldev.Zone;
import iquldev.ZoneManager;
import iquldev.iqprotect;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class CommandManager
implements CommandExecutor {
    private final iqprotect plugin;
    private ZoneManager zoneManager;
    private ConfigManager configManager;

    public CommandManager(ZoneManager zoneManager, DatabaseManager databaseManager, iqprotect plugin) {
        this.zoneManager = zoneManager;
        this.plugin = plugin;
        this.configManager = plugin.getConfigManager();
    }

    public void updateManagers() {
        this.zoneManager = this.plugin.getZoneManager();
        this.configManager = this.plugin.getConfigManager();
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        String subCommand;
        if (!(sender instanceof Player)) {
            MessageUtils.sendMessage((Player)sender, this.configManager.getMessage("general.player_only"));
            Logger.warning(Logger.getLogMessage("commands.console_execute"));
            return true;
        }
        Player player = (Player)sender;
        if (args.length == 0) {
            this.sendHelpMessage(player);
            return true;
        }
        switch (subCommand = args[0].toLowerCase()) {
            case "list": {
                this.handleListCommand(player);
                break;
            }
            case "gui": {
                this.handleGuiCommand(player);
                break;
            }
            case "reload": {
                this.handleReloadCommand(player);
                break;
            }
            case "cui": {
                this.handleCuiCommand(player);
                break;
            }
            case "remove": {
                this.handleRemoveCommand(player);
                break;
            }
            default: {
                this.sendHelpMessage(player);
            }
        }
        return true;
    }

    private void sendHelpMessage(Player player) {
        if (!player.hasPermission(this.configManager.getUsePermission())) {
            MessageUtils.sendMessage(player, this.configManager.getMessage("general.no_permission"));
            return;
        }
        MessageUtils.sendMessage(player, this.configManager.getMessage("commands.help.header"));
        MessageUtils.sendMessage(player, this.configManager.getMessage("commands.help.list"));
        MessageUtils.sendMessage(player, this.configManager.getMessage("commands.help.gui"));
        MessageUtils.sendMessage(player, this.configManager.getMessage("commands.help.cui"));
        MessageUtils.sendMessage(player, this.configManager.getMessage("commands.help.reload"));
        if (player.hasPermission(this.configManager.getAdminPermission())) {
            MessageUtils.sendMessage(player, this.configManager.getMessage("commands.help.remove"));
        }
        MessageUtils.sendMessage(player, this.configManager.getMessage("commands.help.help"));
    }

    private void handleListCommand(Player player) {
        if (!player.hasPermission(this.configManager.getUsePermission())) {
            MessageUtils.sendMessage(player, this.configManager.getMessage("general.no_permission"));
            return;
        }
        Map<UUID, List<Zone>> playerZones = this.zoneManager.getPlayerZones();
        List zones = playerZones.getOrDefault(player.getUniqueId(), new ArrayList());
        if (zones.isEmpty()) {
            MessageUtils.sendMessage(player, this.configManager.getMessage("commands.list.no_zones"));
        } else {
            MessageUtils.sendMessage(player, this.configManager.getMessage("commands.list.header"));
            for (int i = 0; i < zones.size(); ++i) {
                Zone zone = (Zone)zones.get(i);
                HashMap<String, String> placeholders = new HashMap<String, String>();
                placeholders.put("zone_number", String.valueOf(i + 1));
                placeholders.put("block_count", String.valueOf(zone.getBlocks().size()));
                String coordinates = this.getZoneCoordinates(zone);
                placeholders.put("coordinates", coordinates);
                String teleportCoords = this.getTeleportCoordinates(zone);
                placeholders.put("teleport_coordinates", teleportCoords);
                MessageUtils.sendMessage(player, this.configManager.getMessage("commands.list.zone_info", placeholders));
            }
            HashMap<String, String> footerPlaceholders = new HashMap<String, String>();
            footerPlaceholders.put("total_zones", String.valueOf(zones.size()));
            MessageUtils.sendMessage(player, this.configManager.getMessage("commands.list.footer", footerPlaceholders));
        }
    }

    private String getZoneCoordinates(Zone zone) {
        List<Location> blocks = zone.getBlocks();
        if (blocks.isEmpty()) {
            return "Unknown";
        }
        double avgX = blocks.stream().mapToDouble(Location::getX).average().orElse(0.0);
        double avgY = blocks.stream().mapToDouble(Location::getY).average().orElse(0.0);
        double avgZ = blocks.stream().mapToDouble(Location::getZ).average().orElse(0.0);
        String worldName = blocks.get(0).getWorld().getName();
        return String.format("%s (%.0f, %.0f, %.0f)", worldName, avgX, avgY, avgZ);
    }

    private String getTeleportCoordinates(Zone zone) {
        List<Location> blocks = zone.getBlocks();
        if (blocks.isEmpty()) {
            return "0 64 0";
        }
        double avgX = blocks.stream().mapToDouble(Location::getX).average().orElse(0.0);
        double avgY = blocks.stream().mapToDouble(Location::getY).average().orElse(0.0);
        double avgZ = blocks.stream().mapToDouble(Location::getZ).average().orElse(0.0);
        return String.format("%.0f %.0f %.0f", avgX, avgY, avgZ);
    }

    private void handleGuiCommand(Player player) {
        if (!player.hasPermission(this.configManager.getUsePermission())) {
            MessageUtils.sendMessage(player, this.configManager.getMessage("general.no_permission"));
            return;
        }
        GuiManager.openGui(player, this.zoneManager.getPlayerZones(), this.configManager);
    }

    private void handleReloadCommand(Player player) {
        if (!player.hasPermission(this.configManager.getReloadPermission())) {
            MessageUtils.sendMessage(player, this.configManager.getMessage("commands.reload.no_permission"));
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("player_name", player.getName());
            Logger.warning(Logger.getLogMessage("commands.reload_no_permission", placeholders));
            return;
        }
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("player_name", player.getName());
        Logger.info(Logger.getLogMessage("commands.reload_start", placeholders));
        MessageUtils.sendMessage(player, this.configManager.getMessage("general.plugin_reloading"));
        this.plugin.reloadPlugin();
        this.updateManagers();
        MessageUtils.sendMessage(player, this.configManager.getMessage("commands.reload.success"));
        Logger.info(Logger.getLogMessage("commands.reload_success", placeholders));
    }

    private void handleCuiCommand(Player player) {
        if (!player.hasPermission(this.configManager.getUsePermission())) {
            MessageUtils.sendMessage(player, this.configManager.getMessage("general.no_permission"));
            return;
        }
        Map<UUID, List<Zone>> playerZones = this.zoneManager.getPlayerZones();
        List zones = playerZones.getOrDefault(player.getUniqueId(), new ArrayList());
        if (zones.isEmpty()) {
            MessageUtils.sendMessage(player, this.configManager.getMessage("commands.list.no_zones"));
            return;
        }
        MessageUtils.sendMessage(player, this.configManager.getMessage("commands.cui.showing_zones"));
        for (Zone zone : zones) {
            this.showZoneBoundaries(player, zone);
        }
    }

    private void showZoneBoundaries(Player player, Zone zone) {
        List<Location> blocks = zone.getBlocks();
        if (blocks.isEmpty()) {
            return;
        }
        int maxDistance = zone.getMaxDistance();
        for (Location block : blocks) {
            for (int x = -maxDistance; x <= maxDistance; ++x) {
                for (int y = -maxDistance; y <= maxDistance; ++y) {
                    for (int z = -maxDistance; z <= maxDistance; ++z) {
                        Location borderLoc = block.clone().add((double)x, (double)y, (double)z);
                        double distance = block.distance(borderLoc);
                        if (!(Math.abs(distance - (double)maxDistance) < 0.5)) continue;
                        player.spawnParticle(Particle.END_ROD, borderLoc, 1, 0.0, 0.0, 0.0, 0.0);
                    }
                }
            }
        }
    }

    private void handleRemoveCommand(Player player) {
        if (!player.hasPermission(this.configManager.getAdminPermission())) {
            MessageUtils.sendMessage(player, this.configManager.getMessage("commands.remove.no_permission"));
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("player_name", player.getName());
            Logger.warning(Logger.getLogMessage("commands.remove_no_permission", placeholders));
            return;
        }
        Location playerLocation = player.getLocation();
        Zone zoneToRemove = this.zoneManager.getZoneAt(playerLocation);
        if (zoneToRemove == null) {
            MessageUtils.sendMessage(player, this.configManager.getMessage("commands.remove.no_zone_at_location"));
            return;
        }
        UUID zoneOwner = zoneToRemove.getOwner();
        String ownerName = this.plugin.getServer().getOfflinePlayer(zoneOwner).getName();
        if (ownerName == null) {
            ownerName = zoneOwner.toString();
        }
        List<Location> zoneBlocks = zoneToRemove.getBlocks();
        for (Location blockLocation : zoneBlocks) {
            this.zoneManager.removeBlock(zoneOwner, blockLocation);
        }
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("owner_name", ownerName);
        placeholders.put("block_count", String.valueOf(zoneBlocks.size()));
        placeholders.put("coordinates", this.getZoneCoordinates(zoneToRemove));
        MessageUtils.sendMessage(player, this.configManager.getMessage("commands.remove.success", placeholders));
        placeholders.put("admin_name", player.getName());
        Logger.info(Logger.getLogMessage("commands.remove_success", placeholders));
        Player ownerPlayer = this.plugin.getServer().getPlayer(zoneOwner);
        if (ownerPlayer != null && ownerPlayer.isOnline()) {
            HashMap<String, String> ownerPlaceholders = new HashMap<String, String>();
            ownerPlaceholders.put("admin_name", player.getName());
            ownerPlaceholders.put("coordinates", this.getZoneCoordinates(zoneToRemove));
            MessageUtils.sendMessage(ownerPlayer, this.configManager.getMessage("commands.remove.zone_removed_by_admin", ownerPlaceholders));
        }
    }
}

