/*
 * Decompiled with CFR 0.152.
 */
package iquldev;

import iquldev.ConfigManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;

public class CommandTabCompleter
implements TabCompleter {
    private final ConfigManager configManager;

    public CommandTabCompleter(ConfigManager configManager) {
        this.configManager = configManager;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        List<String> completions = new ArrayList<String>();
        if (args.length == 1) {
            ArrayList<String> subCommands = new ArrayList<String>();
            subCommands.addAll(Arrays.asList("list", "gui", "cui", "help"));
            if (sender.hasPermission(this.configManager.getReloadPermission())) {
                subCommands.add("reload");
            }
            if (sender.hasPermission(this.configManager.getAdminPermission())) {
                subCommands.add("remove");
            }
            String input = args[0].toLowerCase();
            completions = subCommands.stream().filter(subCommand -> subCommand.toLowerCase().startsWith(input)).sorted().collect(Collectors.toList());
        }
        return completions;
    }
}

