/*
 * Decompiled with CFR 0.152.
 */
package iquldev;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public class ConfigManager {
    private final JavaPlugin plugin;
    private FileConfiguration config;

    public ConfigManager(JavaPlugin plugin) {
        this.plugin = plugin;
        this.loadConfig();
    }

    public void loadConfig() {
        this.plugin.saveDefaultConfig();
        this.plugin.reloadConfig();
        this.config = this.plugin.getConfig();
    }

    public void reloadConfig() {
        File configFile;
        if (!this.plugin.getDataFolder().exists()) {
            this.plugin.getDataFolder().mkdirs();
        }
        if (!(configFile = new File(this.plugin.getDataFolder(), "config.yml")).exists()) {
            this.plugin.saveDefaultConfig();
        }
        this.plugin.reloadConfig();
        this.config = this.plugin.getConfig();
    }

    public String getMessage(String path) {
        return this.getMessage(path, new HashMap<String, String>());
    }

    public String getMessage(String path, Map<String, String> placeholders) {
        String message = this.config.getString("messages." + path, "Message not found: " + path);
        String prefix = this.config.getString("messages.general.prefix", "<green>[<blue>iqProtect</blue>]</green>");
        message = message.replace("{prefix}", prefix);
        for (Map.Entry<String, String> entry : placeholders.entrySet()) {
            message = message.replace("{" + entry.getKey() + "}", entry.getValue());
        }
        return message;
    }

    public int getMaxZoneDistance() {
        return this.config.getInt("settings.max_zone_distance", 10);
    }

    public int getAutoSaveInterval() {
        return this.config.getInt("settings.auto_save_interval", 5);
    }

    public int getMaxZonesPerPlayer() {
        return this.config.getInt("settings.max_zones_per_player", 10);
    }

    public int getMaxBlocksPerZone() {
        return this.config.getInt("settings.max_blocks_per_zone", 1000);
    }

    public boolean isLoggingEnabled() {
        return this.config.getBoolean("settings.enable_logging", true);
    }

    public String getLogLevel() {
        return this.config.getString("settings.log_level", "WARNING");
    }

    public String getUsePermission() {
        return this.config.getString("permissions.use", "iqp.use");
    }

    public String getBypassPermission() {
        return this.config.getString("permissions.bypass", "iqprotect.bypass");
    }

    public String getReloadPermission() {
        return this.config.getString("permissions.reload", "iqprotect.reload");
    }

    public String getAdminPermission() {
        return this.config.getString("permissions.admin", "iqprotect.admin");
    }

    public boolean isLoggingEventEnabled(String event) {
        return this.config.getBoolean("logging.events." + event, true);
    }

    public String getLogTimeFormat() {
        return this.config.getString("logging.time_format", "yyyy-MM-dd HH:mm");
    }

    public int getZoneCacheTime() {
        return this.config.getInt("performance.zone_cache_time", 300);
    }

    public int getMaxCachedZones() {
        return this.config.getInt("performance.max_cached_zones", 1000);
    }

    public boolean isAsyncDataLoading() {
        return this.config.getBoolean("performance.async_data_loading", true);
    }

    public boolean isAsyncDataSaving() {
        return this.config.getBoolean("performance.async_data_saving", true);
    }

    public FileConfiguration getConfig() {
        return this.config;
    }
}

