/*
 * Decompiled with CFR 0.152.
 */
package iquldev;

import java.util.Map;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.entity.Player;

public class MessageUtils {
    private static final MiniMessage miniMessage = MiniMessage.miniMessage();

    public static Component format(String message) {
        return miniMessage.deserialize((Object)message);
    }

    public static Component format(String message, Map<String, String> placeholders) {
        TagResolver.Builder resolver = TagResolver.builder();
        for (Map.Entry<String, String> entry : placeholders.entrySet()) {
            resolver.resolver((TagResolver)Placeholder.parsed((String)entry.getKey(), (String)entry.getValue()));
        }
        return miniMessage.deserialize(message, resolver.build());
    }

    public static void sendMessage(Player player, String message) {
        Component component = MessageUtils.format(message);
        player.sendMessage(component);
    }

    public static void sendMessage(Player player, Messages message) {
        MessageUtils.sendMessage(player, message.getMessage());
    }

    public static void sendMessage(Player player, Messages message, Map<String, String> placeholders) {
        String msg = message.getMessage();
        for (Map.Entry<String, String> entry : placeholders.entrySet()) {
            msg = msg.replace("{" + entry.getKey() + "}", entry.getValue());
        }
        MessageUtils.sendMessage(player, msg);
    }

    public static void sendActionBar(Player player, String message) {
        Component component = MessageUtils.format(message);
        player.sendActionBar(component);
    }

    public static void sendActionBar(Player player, Messages message, Map<String, String> placeholders) {
        String msg = message.getMessage();
        for (Map.Entry<String, String> entry : placeholders.entrySet()) {
            msg = msg.replace("{" + entry.getKey() + "}", entry.getValue());
        }
        MessageUtils.sendActionBar(player, msg);
    }

    public static enum Messages {
        PLAYER_ONLY("<red>\u042d\u0442\u0430 \u043a\u043e\u043c\u0430\u043d\u0434\u0430 \u0434\u043e\u0441\u0442\u0443\u043f\u043d\u0430 \u0442\u043e\u043b\u044c\u043a\u043e \u0438\u0433\u0440\u043e\u043a\u0430\u043c!</red>"),
        NO_PERMISSION("<red>\u0423 \u0432\u0430\u0441 \u043d\u0435\u0442 \u043f\u0440\u0430\u0432 \u0434\u043b\u044f \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f \u044d\u0442\u043e\u0439 \u043a\u043e\u043c\u0430\u043d\u0434\u044b!</red>"),
        HELP_HEADER("<gradient:#0024FF:#5567FF>=== iqProtect - \u041f\u043e\u043c\u043e\u0449\u044c ===</gradient>"),
        HELP_LIST("<gray>/iqp list - \u041f\u043e\u043a\u0430\u0437\u0430\u0442\u044c \u0441\u043f\u0438\u0441\u043e\u043a \u0432\u0430\u0448\u0438\u0445 \u0437\u043e\u043d</gray>"),
        HELP_GUI("<gray>/iqp gui - \u041e\u0442\u043a\u0440\u044b\u0442\u044c \u0433\u0440\u0430\u0444\u0438\u0447\u0435\u0441\u043a\u0438\u0439 \u0438\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441</gray>"),
        HELP_RELOAD("<gray>/iqp reload - \u041f\u0435\u0440\u0435\u0437\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u044c \u043f\u043b\u0430\u0433\u0438\u043d</gray>"),
        NO_ZONES("<gradient:#0024FF:#5567FF>\u0423 \u0432\u0430\u0441 \u043d\u0435\u0442 \u0437\u0430\u0449\u0438\u0449\u0435\u043d\u043d\u044b\u0445 \u0437\u043e\u043d</gradient>"),
        ZONES_LIST_HEADER("<gradient:#0024FF:#5567FF>\u0412\u0430\u0448\u0438 \u0437\u043e\u043d\u044b:</gradient>"),
        ZONE_INFO("<gray>\u0417\u043e\u043d\u0430 {zone_number}: {block_count} \u0431\u043b\u043e\u043a\u043e\u0432</gray>"),
        ZONE_OWNER("<gradient:#0024FF:#5567FF>\u0412\u043b\u0430\u0434\u0435\u043b\u0435\u0446 \u0437\u043e\u043d\u044b: {owner_name}</gradient>"),
        PLUGIN_RELOADING("<gradient:#0024FF:#5567FF>\u041f\u0435\u0440\u0435\u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0430 \u043f\u043b\u0430\u0433\u0438\u043d\u0430...</gradient>"),
        PLUGIN_RELOADED("<green>\u041f\u043b\u0430\u0433\u0438\u043d \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043f\u0435\u0440\u0435\u0437\u0430\u0433\u0440\u0443\u0436\u0435\u043d!</green>");

        private final String message;

        private Messages(String message) {
            this.message = message;
        }

        public String getMessage() {
            return this.message;
        }
    }
}

