/*
 * Decompiled with CFR 0.152.
 */
package iquldev;

import iquldev.ConfigManager;
import iquldev.Logger;
import iquldev.Zone;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Location;

public class ZoneManager {
    private final Map<UUID, List<Location>> playerBlocks = new HashMap<UUID, List<Location>>();
    private final Map<UUID, List<Zone>> playerZones = new HashMap<UUID, List<Zone>>();
    private ConfigManager configManager;

    public void setConfigManager(ConfigManager configManager) {
        this.configManager = configManager;
    }

    public void setPlayerBlocks(Map<UUID, List<Location>> playerBlocks) {
        this.playerBlocks.clear();
        this.playerBlocks.putAll(playerBlocks);
        this.updateAllZones();
    }

    public Map<UUID, List<Location>> getPlayerBlocks() {
        return new HashMap<UUID, List<Location>>(this.playerBlocks);
    }

    public Map<UUID, List<Zone>> getPlayerZones() {
        return new HashMap<UUID, List<Zone>>(this.playerZones);
    }

    public void addBlock(UUID playerId, Location location) {
        List playerBlocksList = this.playerBlocks.getOrDefault(playerId, new ArrayList());
        if (this.configManager != null) {
            int maxBlocks = this.configManager.getMaxBlocksPerZone();
            if (playerBlocksList.size() >= maxBlocks) {
                HashMap<String, String> placeholders = new HashMap<String, String>();
                placeholders.put("player_id", playerId.toString());
                placeholders.put("max_blocks", String.valueOf(maxBlocks));
                Logger.warning(Logger.getLogMessage("zones.block_limit_reached", placeholders));
                return;
            }
        }
        playerBlocksList.add(location);
        this.playerBlocks.put(playerId, playerBlocksList);
        this.updateZones(playerId);
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("player_id", playerId.toString());
        placeholders.put("block_count", String.valueOf(playerBlocksList.size()));
        Logger.info(Logger.getLogMessage("zones.block_added", placeholders));
    }

    public void removeBlock(UUID playerId, Location location) {
        List playerBlocksList = this.playerBlocks.getOrDefault(playerId, new ArrayList());
        boolean removed = playerBlocksList.remove(location);
        if (removed) {
            this.playerBlocks.put(playerId, playerBlocksList);
            this.updateZones(playerId);
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("player_id", playerId.toString());
            placeholders.put("block_count", String.valueOf(playerBlocksList.size()));
            Logger.info(Logger.getLogMessage("zones.block_removed", placeholders));
        }
    }

    public Zone getZoneAt(Location location) {
        for (Map.Entry<UUID, List<Zone>> entry : this.playerZones.entrySet()) {
            for (Zone zone : entry.getValue()) {
                for (Location block : zone.getBlocks()) {
                    if (!block.getWorld().equals((Object)location.getWorld()) || !(block.distance(location) <= (double)zone.getMaxDistance())) continue;
                    return zone;
                }
            }
        }
        return null;
    }

    public boolean canInteract(UUID playerUUID, Location location, boolean hasBypass) {
        if (hasBypass) {
            return true;
        }
        Zone zone = this.getZoneAt(location);
        if (zone == null) {
            return true;
        }
        UUID zoneOwner = zone.getOwner();
        boolean canInteract = playerUUID.equals(zoneOwner);
        if (!canInteract) {
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("player_uuid", playerUUID.toString());
            placeholders.put("zone_owner", zoneOwner.toString());
            placeholders.put("location", this.locationToString(location));
            Logger.warning(Logger.getLogMessage("zones.violation_attempt", placeholders));
        }
        return canInteract;
    }

    private void updateAllZones() {
        for (UUID playerId : this.playerBlocks.keySet()) {
            this.updateZones(playerId);
        }
    }

    private void updateZones(UUID playerId) {
        List<Location> blocks = this.playerBlocks.get(playerId);
        if (blocks == null || blocks.isEmpty()) {
            this.playerZones.put(playerId, new ArrayList());
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("player_id", playerId.toString());
            Logger.info(Logger.getLogMessage("zones.zones_cleared", placeholders));
            return;
        }
        ArrayList<Zone> newZones = new ArrayList<Zone>();
        int maxDistance = this.configManager != null ? this.configManager.getMaxZoneDistance() : 10;
        newZones.add(new Zone(playerId, new ArrayList<Location>(blocks), maxDistance));
        this.playerZones.put(playerId, newZones);
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("player_id", playerId.toString());
        placeholders.put("zone_count", String.valueOf(newZones.size()));
        placeholders.put("block_count", String.valueOf(blocks.size()));
        Logger.info(Logger.getLogMessage("zones.zones_updated", placeholders));
    }

    private String locationToString(Location location) {
        return location.getWorld().getName() + " (" + location.getBlockX() + ", " + location.getBlockY() + ", " + location.getBlockZ() + ")";
    }
}

