/*
 * Decompiled with CFR 0.152.
 */
package iquldev;

import iquldev.CommandManager;
import iquldev.CommandTabCompleter;
import iquldev.ConfigManager;
import iquldev.DatabaseManager;
import iquldev.EventManager;
import iquldev.Logger;
import iquldev.ZoneManager;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class iqprotect
extends JavaPlugin {
    private ZoneManager zoneManager;
    private DatabaseManager databaseManager;
    private EventManager eventManager;
    private CommandManager commandManager;
    private ConfigManager configManager;

    public void onEnable() {
        this.configManager = new ConfigManager(this);
        Logger.setConfigManager(this.configManager);
        this.databaseManager = new DatabaseManager(this);
        try {
            this.databaseManager.initDatabase();
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("plugin_name", this.getName());
            Logger.info(Logger.getLogMessage("system.plugin_enabled", placeholders));
        }
        catch (Exception e) {
            this.getLogger().severe("Failed to initialize database: " + e.getMessage());
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("error", e.getMessage());
            Logger.error(Logger.getLogMessage("system.database_init_error", placeholders));
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.zoneManager = new ZoneManager();
        this.zoneManager.setConfigManager(this.configManager);
        Map<UUID, List<Location>> loadedData = this.databaseManager.loadData();
        this.zoneManager.setPlayerBlocks(loadedData);
        this.eventManager = new EventManager(this.zoneManager, this.databaseManager, this.configManager);
        this.commandManager = new CommandManager(this.zoneManager, this.databaseManager, this);
        this.getServer().getPluginManager().registerEvents((Listener)this.eventManager, (Plugin)this);
        this.getCommand("iqp").setExecutor((CommandExecutor)this.commandManager);
        this.getCommand("iqp").setTabCompleter((TabCompleter)new CommandTabCompleter(this.configManager));
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("plugin_name", this.getName());
        placeholders.put("version", this.getPluginMeta().getVersion());
        Logger.info(Logger.getLogMessage("system.plugin_loaded", placeholders));
    }

    public void onDisable() {
        if (this.zoneManager != null && this.databaseManager != null) {
            this.databaseManager.saveData(this.zoneManager.getPlayerBlocks());
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("plugin_name", this.getName());
            Logger.info(Logger.getLogMessage("system.plugin_disabled", placeholders));
        }
        if (this.databaseManager != null) {
            this.databaseManager.closeConnection();
        }
    }

    public void reloadPlugin() {
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("plugin_name", this.getName());
        Logger.info(Logger.getLogMessage("system.plugin_reload_start", placeholders));
        this.configManager.reloadConfig();
        Logger.setConfigManager(this.configManager);
        this.zoneManager.setConfigManager(this.configManager);
        if (this.commandManager != null) {
            this.commandManager.updateManagers();
        }
        Logger.info(Logger.getLogMessage("system.plugin_reload_complete", placeholders));
    }

    public ZoneManager getZoneManager() {
        return this.zoneManager;
    }

    public DatabaseManager getDatabaseManager() {
        return this.databaseManager;
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }
}

