/*
 * Decompiled with CFR 0.152.
 */
package de.pnku.lolmsv.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import de.pnku.lolmsv.MoreShieldVariants;
import de.pnku.lolmsv.config.MoreShieldVariantsConfig;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class MoreShieldVariantsConfigJsonHelper {
    private static final File folder = new File("config");
    private static File moreshieldvariantsConfig;
    public static Gson configGson;

    public static void init() {
        MoreShieldVariantsConfigJsonHelper.createConfig();
        MoreShieldVariantsConfigJsonHelper.readFromConfig();
        MoreShieldVariantsConfigJsonHelper.writeToConfig();
    }

    public static void createConfig() {
        if (!folder.exists()) {
            folder.mkdir();
        }
        if (folder.isDirectory()) {
            boolean seemsValid;
            moreshieldvariantsConfig = new File(folder, "moreshieldvariants.json");
            if (moreshieldvariantsConfig.exists()) {
                try {
                    String moreshieldvariantsConfigJson = Files.readString(Path.of(moreshieldvariantsConfig.getPath(), new String[0]));
                    seemsValid = moreshieldvariantsConfigJson.trim().startsWith("{");
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            } else {
                seemsValid = true;
            }
            if (!moreshieldvariantsConfig.exists() || !seemsValid) {
                if (!seemsValid) {
                    MoreShieldVariants.LOGGER.info("Found invalid config file, creating new config file at './config/moreshieldvariants.json'.");
                }
                try {
                    moreshieldvariantsConfig.createNewFile();
                    String json = configGson.toJson((Object)MoreShieldVariantsConfig.getInstance());
                    FileWriter writer = new FileWriter(moreshieldvariantsConfig);
                    writer.write(json);
                    writer.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public static void readFromConfig() {
        try {
            MoreShieldVariantsConfig config = (MoreShieldVariantsConfig)configGson.fromJson((Reader)new FileReader(moreshieldvariantsConfig), MoreShieldVariantsConfig.class);
            MoreShieldVariantsConfig.getInstance().updateConfigs(config);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static void writeToConfig() {
        try {
            String json = configGson.toJson((Object)MoreShieldVariantsConfig.getInstance());
            FileWriter writer = new FileWriter(moreshieldvariantsConfig, false);
            writer.write(json);
            writer.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        configGson = new GsonBuilder().setPrettyPrinting().create();
    }
}

