/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.gjeb.asm.integration.sodium;

import com.mojang.logging.LogUtils;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.slf4j.Logger;

public class SodiumGameOptionPagesAsm {
    private static Logger LOGGER = LogUtils.getLogger();
    private static final String SODIUM_CONTROLL_PACKAGE = "net/caffeinemc/mods/sodium/client/gui/options/control/";
    private static final String EMBEDDIUM_CONTROLL_PACKAGE = "org/embeddedt/embeddium/api/options/control/";

    public static void asm(ClassNode targetClass) {
        for (MethodNode method : targetClass.methods) {
            for (AbstractInsnNode ins : method.instructions) {
                MethodInsnNode methodIns;
                if (!(ins instanceof MethodInsnNode) || !SodiumGameOptionPagesAsm.isBrightnessCall(methodIns = (MethodInsnNode)ins, SODIUM_CONTROLL_PACKAGE) && !SodiumGameOptionPagesAsm.isBrightnessCall(methodIns, EMBEDDIUM_CONTROLL_PACKAGE)) continue;
                AbstractInsnNode node = ins.getPrevious().getPrevious();
                if (node instanceof IntInsnNode) {
                    IntInsnNode intInsNode = (IntInsnNode)node;
                    intInsNode.setOpcode(17);
                    intInsNode.operand = 1000;
                    LOGGER.debug("Inject gjeb into sodium guis");
                    continue;
                }
                LOGGER.warn("Cannot make sodium compatible with gjeb");
            }
        }
    }

    private static boolean isBrightnessCall(MethodInsnNode methodIns, String basePackage) {
        return methodIns.getOpcode() == 184 && methodIns.owner.equals(basePackage + "ControlValueFormatter") && methodIns.name.equals("brightness") && methodIns.desc.equals("()L" + basePackage + "ControlValueFormatter;");
    }
}

