/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.gjeb.mixin;

import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import java.util.Optional;
import net.minecraft.client.OptionInstance;
import net.minecraft.client.Options;
import net.minecraft.network.chat.Component;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={Options.class})
abstract class OptionsMixin {
    @Shadow
    @Final
    @Mutable
    public OptionInstance<Double> gamma;

    OptionsMixin() {
    }

    @Redirect(method={"<init>"}, at=@At(value="FIELD", target="Lnet/minecraft/client/Options;gamma:Lnet/minecraft/client/OptionInstance;", opcode=181))
    private void gjeb_replaceGammaOption(Options options, OptionInstance<?> instance) {
        this.gamma = new OptionInstance("options.gamma", OptionInstance.noTooltip(), (component, value) -> {
            int intValue = (int)(value * 100.0);
            if (intValue == 0) {
                return Options.genericValueLabel((Component)component, (Component)Component.translatable((String)"options.gamma.min"));
            }
            if (intValue == 50) {
                return Options.genericValueLabel((Component)component, (Component)Component.translatable((String)"options.gamma.default"));
            }
            return intValue == 1000 ? Options.genericValueLabel((Component)component, (Component)Component.translatable((String)"options.gamma.max")) : Options.genericValueLabel((Component)component, (int)intValue);
        }, (OptionInstance.ValueSet)new OptionInstance.SliderableValueSet<Double>(this){

            public Optional<Double> validateValue(Double value) {
                return value >= 0.0 && value <= 10.0 ? Optional.of(value) : Optional.empty();
            }

            public double toSliderValue(Double value) {
                return value / 10.0;
            }

            public Double fromSliderValue(double sliderValue) {
                return sliderValue * 10.0;
            }

            public Codec<Double> codec() {
                return Codec.either((Codec)Codec.doubleRange((double)0.0, (double)10.0), (Codec)Codec.BOOL).xmap(either -> (Double)either.map(value -> value, leftRight -> leftRight != false ? 10.0 : 0.0), Either::left);
            }
        }, (Object)0.5, onValueUpdate -> {});
    }
}

