/*
 * Decompiled with CFR 0.152.
 */
package ru.octol1ttle.flightassistant.impl.alert.autoflight;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.jetbrains.annotations.NotNull;
import ru.octol1ttle.flightassistant.api.alert.Alert;
import ru.octol1ttle.flightassistant.api.alert.AlertData;
import ru.octol1ttle.flightassistant.api.alert.ECAMAlert;
import ru.octol1ttle.flightassistant.api.computer.ComputerBus;
import ru.octol1ttle.flightassistant.api.util.FATickCounter;
import ru.octol1ttle.flightassistant.api.util.extensions.GuiGraphicsExtensionsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u000f\u001a\u00020\u000eH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J(\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\fH\u0016R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lru/octol1ttle/flightassistant/impl/alert/autoflight/AutopilotOffAlert;", "Lru/octol1ttle/flightassistant/api/alert/Alert;", "Lru/octol1ttle/flightassistant/api/alert/ECAMAlert;", "computers", "Lru/octol1ttle/flightassistant/api/computer/ComputerBus;", "<init>", "(Lru/octol1ttle/flightassistant/api/computer/ComputerBus;)V", "data", "Lru/octol1ttle/flightassistant/api/alert/AlertData;", "getData", "()Lru/octol1ttle/flightassistant/api/alert/AlertData;", "age", "", "wasAutopilot", "", "shouldActivate", "onHide", "", "render", "guiGraphics", "Lnet/minecraft/client/gui/GuiGraphics;", "firstLineX", "otherLinesX", "firstLineY", "flightassistant-forge"})
public final class AutopilotOffAlert
extends Alert
implements ECAMAlert {
    private int age;
    private boolean wasAutopilot;

    public AutopilotOffAlert(@NotNull ComputerBus computers) {
        Intrinsics.checkNotNullParameter((Object)computers, (String)"computers");
        super(computers);
    }

    @Override
    @NotNull
    public AlertData getData() {
        return this.getComputers().getAutoflight().getAutopilotAlert() ? AlertData.Companion.getFORCE_AUTOPILOT_OFF() : AlertData.Companion.getPLAYER_AUTOPILOT_OFF();
    }

    @Override
    public boolean shouldActivate() {
        boolean autopilotOff;
        if (this.getComputers().getAutoflight().getAutopilotAlert() || this.age > 80) {
            this.wasAutopilot = false;
            this.age = 0;
            return this.getComputers().getAutoflight().getAutopilotAlert();
        }
        if (this.getComputers().getAutoflight().getAutopilot()) {
            this.wasAutopilot = true;
        }
        boolean bl = autopilotOff = this.wasAutopilot && !this.getComputers().getAutoflight().getAutopilot();
        if (autopilotOff) {
            this.age += FATickCounter.INSTANCE.getTicksPassed();
        }
        return autopilotOff;
    }

    @Override
    public void onHide() {
        this.getComputers().getAutoflight().setAutopilotAlert(false);
    }

    @Override
    public int render(@NotNull GuiGraphics guiGraphics, int firstLineX, int otherLinesX, int firstLineY) {
        Intrinsics.checkNotNullParameter((Object)guiGraphics, (String)"guiGraphics");
        MutableComponent mutableComponent = Component.m_237115_((String)"alert.flightassistant.autoflight.autopilot_off");
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"translatable(...)");
        int i = GuiGraphicsExtensionsKt.drawString$default(guiGraphics, (Component)mutableComponent, firstLineX, firstLineY, GuiGraphicsExtensionsKt.getWarningColor(), false, 16, null);
        if (this.getComputers().getAutoflight().getAutopilotAlert()) {
            MutableComponent mutableComponent2 = Component.m_237115_((String)"alert.flightassistant.autoflight.autopilot_off.push_to_silence");
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent2, (String)"translatable(...)");
            i += GuiGraphicsExtensionsKt.drawString$default(guiGraphics, (Component)mutableComponent2, otherLinesX, firstLineY + 11, GuiGraphicsExtensionsKt.getPrimaryAdvisoryColor(), false, 16, null);
        }
        return i;
    }
}

