/*
 * Decompiled with CFR 0.152.
 */
package ru.octol1ttle.flightassistant.impl.alert.fault.computer;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.octol1ttle.flightassistant.api.alert.Alert;
import ru.octol1ttle.flightassistant.api.alert.AlertData;
import ru.octol1ttle.flightassistant.api.alert.ECAMAlert;
import ru.octol1ttle.flightassistant.api.computer.ComputerBus;
import ru.octol1ttle.flightassistant.api.util.extensions.GuiGraphicsExtensionsKt;
import ru.octol1ttle.flightassistant.impl.computer.ComputerHost;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u00012\u00020\u0002B;\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0010\b\u0002\u0010\t\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\b\u0010\u0015\u001a\u00020\u0016H\u0016J(\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u0012H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u0012X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001d"}, d2={"Lru/octol1ttle/flightassistant/impl/alert/fault/computer/ComputerFaultAlert;", "Lru/octol1ttle/flightassistant/api/alert/Alert;", "Lru/octol1ttle/flightassistant/api/alert/ECAMAlert;", "computers", "Lru/octol1ttle/flightassistant/api/computer/ComputerBus;", "identifier", "Lnet/minecraft/resources/ResourceLocation;", "alertText", "Lnet/minecraft/network/chat/Component;", "extraTexts", "", "data", "Lru/octol1ttle/flightassistant/api/alert/AlertData;", "<init>", "(Lru/octol1ttle/flightassistant/api/computer/ComputerBus;Lnet/minecraft/resources/ResourceLocation;Lnet/minecraft/network/chat/Component;Ljava/util/Collection;Lru/octol1ttle/flightassistant/api/alert/AlertData;)V", "getData", "()Lru/octol1ttle/flightassistant/api/alert/AlertData;", "priorityOffset", "", "getPriorityOffset", "()I", "shouldActivate", "", "render", "guiGraphics", "Lnet/minecraft/client/gui/GuiGraphics;", "firstLineX", "otherLinesX", "firstLineY", "flightassistant-forge"})
public final class ComputerFaultAlert
extends Alert
implements ECAMAlert {
    @NotNull
    private final ResourceLocation identifier;
    @NotNull
    private final Component alertText;
    @Nullable
    private final Collection<Component> extraTexts;
    @NotNull
    private final AlertData data;
    private final int priorityOffset;

    public ComputerFaultAlert(@NotNull ComputerBus computers, @NotNull ResourceLocation identifier, @NotNull Component alertText, @Nullable Collection<? extends Component> extraTexts, @NotNull AlertData data) {
        Intrinsics.checkNotNullParameter((Object)computers, (String)"computers");
        Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
        Intrinsics.checkNotNullParameter((Object)alertText, (String)"alertText");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        super(computers);
        this.identifier = identifier;
        this.alertText = alertText;
        this.extraTexts = extraTexts;
        this.data = data;
        this.priorityOffset = 25;
    }

    public /* synthetic */ ComputerFaultAlert(ComputerBus computerBus, ResourceLocation resourceLocation, Component component, Collection collection, AlertData alertData, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            collection = null;
        }
        if ((n & 0x10) != 0) {
            alertData = AlertData.Companion.getMASTER_CAUTION();
        }
        this(computerBus, resourceLocation, component, collection, alertData);
    }

    @Override
    @NotNull
    public AlertData getData() {
        return this.data;
    }

    @Override
    public int getPriorityOffset() {
        return this.priorityOffset;
    }

    @Override
    public boolean shouldActivate() {
        return ComputerHost.INSTANCE.isFaulted(this.identifier);
    }

    @Override
    public int render(@NotNull GuiGraphics guiGraphics, int firstLineX, int otherLinesX, int firstLineY) {
        int n;
        Intrinsics.checkNotNullParameter((Object)guiGraphics, (String)"guiGraphics");
        int color = ((Number)this.getData().getColorSupplier().invoke()).intValue();
        int i = 0;
        i += GuiGraphicsExtensionsKt.drawString$default(guiGraphics, this.alertText, firstLineX, firstLineY, color, false, 16, null);
        int y = firstLineY + 11;
        if (this.extraTexts != null) {
            for (Component text : this.extraTexts) {
                i += GuiGraphicsExtensionsKt.drawString$default(guiGraphics, text, otherLinesX, y, GuiGraphicsExtensionsKt.getPrimaryAdvisoryColor(), false, 16, null);
                y += 10;
            }
        }
        if (ComputerHost.INSTANCE.getFaultCount(this.identifier) == 1) {
            MutableComponent mutableComponent = Component.m_237115_((String)"alert.flightassistant.fault.computer.reset");
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"translatable(...)");
            n = GuiGraphicsExtensionsKt.drawString$default(guiGraphics, (Component)mutableComponent, otherLinesX, y, GuiGraphicsExtensionsKt.getPrimaryAdvisoryColor(), false, 16, null);
        } else {
            n = 0;
        }
        return i += n;
    }
}

