/*
 * Decompiled with CFR 0.152.
 */
package ru.octol1ttle.flightassistant.impl.alert.flight_plan;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.level.levelgen.Heightmap;
import org.jetbrains.annotations.NotNull;
import ru.octol1ttle.flightassistant.api.alert.Alert;
import ru.octol1ttle.flightassistant.api.alert.AlertData;
import ru.octol1ttle.flightassistant.api.alert.ECAMAlert;
import ru.octol1ttle.flightassistant.api.computer.ComputerBus;
import ru.octol1ttle.flightassistant.api.util.extensions.GuiGraphicsExtensionsKt;
import ru.octol1ttle.flightassistant.impl.computer.autoflight.FlightPlanComputer;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u000b\u001a\u00020\fH\u0016J(\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u000eH\u0016R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lru/octol1ttle/flightassistant/impl/alert/flight_plan/ArrivalElevationDisagreeAlert;", "Lru/octol1ttle/flightassistant/api/alert/Alert;", "Lru/octol1ttle/flightassistant/api/alert/ECAMAlert;", "computers", "Lru/octol1ttle/flightassistant/api/computer/ComputerBus;", "<init>", "(Lru/octol1ttle/flightassistant/api/computer/ComputerBus;)V", "data", "Lru/octol1ttle/flightassistant/api/alert/AlertData;", "getData", "()Lru/octol1ttle/flightassistant/api/alert/AlertData;", "shouldActivate", "", "render", "", "guiGraphics", "Lnet/minecraft/client/gui/GuiGraphics;", "firstLineX", "otherLinesX", "firstLineY", "flightassistant-forge"})
public final class ArrivalElevationDisagreeAlert
extends Alert
implements ECAMAlert {
    @NotNull
    private final AlertData data;

    public ArrivalElevationDisagreeAlert(@NotNull ComputerBus computers) {
        Intrinsics.checkNotNullParameter((Object)computers, (String)"computers");
        super(computers);
        this.data = AlertData.Companion.getMASTER_CAUTION();
    }

    @Override
    @NotNull
    public AlertData getData() {
        return this.data;
    }

    @Override
    public boolean shouldActivate() {
        if (this.getComputers().getPlan().getCurrentPhase().compareTo((Enum)FlightPlanComputer.FlightPhase.APPROACH) < 0) {
            return false;
        }
        int x = this.getComputers().getPlan().getArrivalData().getCoordinatesX();
        int z = this.getComputers().getPlan().getArrivalData().getCoordinatesZ();
        if (!this.getComputers().getChunk().isLoaded(x, z)) {
            return false;
        }
        int actualElevation = this.getComputers().getData().getLevel().m_6924_(Heightmap.Types.MOTION_BLOCKING, x, z);
        return Math.abs(actualElevation - this.getComputers().getPlan().getArrivalData().getElevation()) > 2;
    }

    @Override
    public int render(@NotNull GuiGraphics guiGraphics, int firstLineX, int otherLinesX, int firstLineY) {
        Intrinsics.checkNotNullParameter((Object)guiGraphics, (String)"guiGraphics");
        int i = 0;
        MutableComponent mutableComponent = Component.m_237115_((String)"alert.flightassistant.flight_plan.arrival_elevation_disagree");
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"translatable(...)");
        i += GuiGraphicsExtensionsKt.drawString$default(guiGraphics, (Component)mutableComponent, firstLineX, firstLineY, GuiGraphicsExtensionsKt.getCautionColor(), false, 16, null);
        int y = firstLineY + 1;
        MutableComponent mutableComponent2 = Component.m_237115_((String)"alert.flightassistant.flight_plan.arrival_elevation_disagree.glide_slope_unreliable");
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent2, (String)"translatable(...)");
        i += GuiGraphicsExtensionsKt.drawString$default(guiGraphics, (Component)mutableComponent2, otherLinesX, y += 10, GuiGraphicsExtensionsKt.getPrimaryAdvisoryColor(), false, 16, null);
        MutableComponent mutableComponent3 = Component.m_237115_((String)"alert.flightassistant.flight_plan.arrival_elevation_disagree.autopilot_do_not_use");
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent3, (String)"translatable(...)");
        return i += GuiGraphicsExtensionsKt.drawString$default(guiGraphics, (Component)mutableComponent3, otherLinesX, y += 10, GuiGraphicsExtensionsKt.getPrimaryAdvisoryColor(), false, 16, null);
    }
}

