/*
 * Decompiled with CFR 0.152.
 */
package ru.octol1ttle.flightassistant.impl.computer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.octol1ttle.flightassistant.FlightAssistant;
import ru.octol1ttle.flightassistant.api.ModuleController;
import ru.octol1ttle.flightassistant.api.computer.Computer;
import ru.octol1ttle.flightassistant.api.computer.ComputerBus;
import ru.octol1ttle.flightassistant.api.computer.ComputerEvent;
import ru.octol1ttle.flightassistant.api.computer.ComputerQuery;
import ru.octol1ttle.flightassistant.api.computer.ComputerRegistrationCallback;
import ru.octol1ttle.flightassistant.api.util.FATickCounter;
import ru.octol1ttle.flightassistant.config.FAConfig;
import ru.octol1ttle.flightassistant.impl.computer.autoflight.AutoFlightComputer;
import ru.octol1ttle.flightassistant.impl.computer.autoflight.FireworkComputer;
import ru.octol1ttle.flightassistant.impl.computer.autoflight.FlightPlanComputer;
import ru.octol1ttle.flightassistant.impl.computer.autoflight.base.HeadingComputer;
import ru.octol1ttle.flightassistant.impl.computer.autoflight.base.PitchComputer;
import ru.octol1ttle.flightassistant.impl.computer.autoflight.base.RollComputer;
import ru.octol1ttle.flightassistant.impl.computer.autoflight.base.ThrustComputer;
import ru.octol1ttle.flightassistant.impl.computer.data.AirDataComputer;
import ru.octol1ttle.flightassistant.impl.computer.data.HudDisplayDataComputer;
import ru.octol1ttle.flightassistant.impl.computer.safety.AlertComputer;
import ru.octol1ttle.flightassistant.impl.computer.safety.ChunkStatusComputer;
import ru.octol1ttle.flightassistant.impl.computer.safety.ElytraStatusComputer;
import ru.octol1ttle.flightassistant.impl.computer.safety.FlightProtectionsComputer;
import ru.octol1ttle.flightassistant.impl.computer.safety.GroundProximityComputer;
import ru.octol1ttle.flightassistant.impl.computer.safety.StallComputer;
import ru.octol1ttle.flightassistant.impl.computer.safety.VoidProximityComputer;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0007\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\bH\u0016J\u0010\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\bH\u0016J\u0018\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\nH\u0016J\u0010\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\bH\u0016J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\bJ\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\u0002H\u0002J\b\u0010\u001a\u001a\u00020\u0018H\u0002J\r\u0010\u001b\u001a\u00020\u0018H\u0000\u00a2\u0006\u0002\b\u001cJ\b\u0010\u001d\u001a\u00020\u0018H\u0002J\u0015\u0010\u001e\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020 H\u0000\u00a2\u0006\u0002\b!J7\u0010\"\u001a\u0004\u0018\u0001H#\"\u0004\b\u0000\u0010$\"\u0004\b\u0001\u0010#2\u0006\u0010%\u001a\u0002H$2\u0012\u0010&\u001a\u000e\u0012\u0004\u0012\u0002H$\u0012\u0004\u0012\u0002H#0'H\u0017\u00a2\u0006\u0002\u0010(J\u001f\u0010)\u001a\u00020\u0018\"\b\b\u0000\u0010**\u00020+2\u0006\u0010,\u001a\u0002H*H\u0016\u00a2\u0006\u0002\u0010-J\"\u0010.\u001a\b\u0012\u0004\u0012\u0002H00/\"\u0004\b\u0000\u001002\f\u00101\u001a\b\u0012\u0004\u0012\u0002H002H\u0016J\u0010\u00103\u001a\u00020\u00182\u0006\u0010%\u001a\u00020\u0002H\u0002R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\nX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u00064"}, d2={"Lru/octol1ttle/flightassistant/impl/computer/ComputerHost;", "Lru/octol1ttle/flightassistant/api/ModuleController;", "Lru/octol1ttle/flightassistant/api/computer/Computer;", "Lru/octol1ttle/flightassistant/api/computer/ComputerBus;", "<init>", "()V", "computers", "", "Lnet/minecraft/resources/ResourceLocation;", "modulesResettable", "", "getModulesResettable", "()Z", "identifiers", "", "get", "identifier", "isEnabled", "setEnabled", "enabled", "isFaulted", "getFaultCount", "", "register", "", "module", "registerBuiltin", "sendRegistrationEvent", "sendRegistrationEvent$flightassistant_forge", "logRegisterComplete", "tick", "partialTick", "", "tick$flightassistant_forge", "guardedCall", "T", "C", "computer", "call", "Lkotlin/Function1;", "(Ljava/lang/Object;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "dispatchEvent", "Event", "Lru/octol1ttle/flightassistant/api/computer/ComputerEvent;", "event", "(Lru/octol1ttle/flightassistant/api/computer/ComputerEvent;)V", "dispatchQuery", "", "Response", "query", "Lru/octol1ttle/flightassistant/api/computer/ComputerQuery;", "onComputerFault", "flightassistant-forge"})
@SourceDebugExtension(value={"SMAP\nComputerHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ComputerHost.kt\nru/octol1ttle/flightassistant/impl/computer/ComputerHost\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,180:1\n1869#2,2:181\n1869#2,2:183\n*S KotlinDebug\n*F\n+ 1 ComputerHost.kt\nru/octol1ttle/flightassistant/impl/computer/ComputerHost\n*L\n95#1:181,2\n96#1:183,2\n*E\n"})
public final class ComputerHost
implements ModuleController<Computer>,
ComputerBus {
    @NotNull
    public static final ComputerHost INSTANCE = new ComputerHost();
    @NotNull
    private static final Map<ResourceLocation, Computer> computers = new LinkedHashMap();
    private static final boolean modulesResettable = true;

    private ComputerHost() {
    }

    @Override
    public boolean getModulesResettable() {
        return modulesResettable;
    }

    @NotNull
    public Set<ResourceLocation> identifiers() {
        return computers.keySet();
    }

    @Override
    @NotNull
    public Computer get(@NotNull ResourceLocation identifier) {
        Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
        Computer computer = computers.get(identifier);
        if (computer == null) {
            throw new IllegalArgumentException("No computer registered with ID: " + identifier);
        }
        return computer;
    }

    @Override
    public boolean isEnabled(@NotNull ResourceLocation identifier) {
        Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
        return this.get(identifier).getEnabled();
    }

    @Override
    public boolean setEnabled(@NotNull ResourceLocation identifier, boolean enabled) {
        Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
        Computer computer = this.get(identifier);
        boolean oldEnabled = computer.getEnabled();
        computer.setEnabled$flightassistant_forge(enabled);
        computer.reset();
        if (!computer.getEnabled()) {
            computer.setFaulted$flightassistant_forge(false);
        }
        return oldEnabled;
    }

    @Override
    public boolean isFaulted(@NotNull ResourceLocation identifier) {
        Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
        return this.get(identifier).getFaulted();
    }

    public final int getFaultCount(@NotNull ResourceLocation identifier) {
        Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
        return this.get(identifier).getFaultCount();
    }

    private final void register(ResourceLocation identifier, Computer module) {
        if (FlightAssistant.INSTANCE.getInitComplete$flightassistant_forge()) {
            throw new IllegalStateException("Initialization is already complete, but trying to register a computer with identifier: " + identifier);
        }
        if (computers.containsKey(identifier)) {
            throw new IllegalArgumentException("Already registered computer with identifier: " + identifier);
        }
        computers.put(identifier, module);
    }

    private final void registerBuiltin() {
        this.register(AirDataComputer.Companion.getID(), new AirDataComputer(this, FlightAssistant.INSTANCE.getMc$flightassistant_forge()));
        this.register(HudDisplayDataComputer.Companion.getID(), new HudDisplayDataComputer(this, FlightAssistant.INSTANCE.getMc$flightassistant_forge()));
        this.register(FlightProtectionsComputer.Companion.getID(), new FlightProtectionsComputer(this));
        this.register(StallComputer.Companion.getID(), new StallComputer(this));
        this.register(VoidProximityComputer.Companion.getID(), new VoidProximityComputer(this));
        this.register(GroundProximityComputer.Companion.getID(), new GroundProximityComputer(this));
        this.register(ElytraStatusComputer.Companion.getID(), new ElytraStatusComputer(this));
        this.register(ChunkStatusComputer.Companion.getID(), new ChunkStatusComputer(this));
        this.register(FlightPlanComputer.Companion.getID(), new FlightPlanComputer(this));
        this.register(AutoFlightComputer.Companion.getID(), new AutoFlightComputer(this));
        this.register(FireworkComputer.Companion.getID(), new FireworkComputer(this, FlightAssistant.INSTANCE.getMc$flightassistant_forge()));
        this.register(PitchComputer.Companion.getID(), new PitchComputer(this));
        this.register(HeadingComputer.Companion.getID(), new HeadingComputer(this));
        this.register(RollComputer.Companion.getID(), new RollComputer(this));
        this.register(ThrustComputer.Companion.getID(), new ThrustComputer(this));
        ResourceLocation resourceLocation = AlertComputer.Companion.getID();
        ComputerBus computerBus = this;
        SoundManager soundManager = FlightAssistant.INSTANCE.getMc$flightassistant_forge().m_91106_();
        Intrinsics.checkNotNullExpressionValue((Object)soundManager, (String)"getSoundManager(...)");
        this.register(resourceLocation, new AlertComputer(computerBus, soundManager));
    }

    public final void sendRegistrationEvent$flightassistant_forge() {
        Computer p0;
        this.registerBuiltin();
        ((ComputerRegistrationCallback)ComputerRegistrationCallback.EVENT.invoker()).register(this, this::register);
        Iterable $this$forEach$iv = computers.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            p0 = (Computer)element$iv;
            boolean bl = false;
            p0.subscribeToEvents();
        }
        $this$forEach$iv = computers.values();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            p0 = (Computer)element$iv;
            boolean bl = false;
            p0.invokeEvents();
        }
        this.logRegisterComplete();
    }

    private final void logRegisterComplete() {
        ArrayList<String> namespaces = new ArrayList<String>();
        for (ResourceLocation id : computers.keySet()) {
            if (namespaces.contains(id.m_135827_())) continue;
            namespaces.add(id.m_135827_());
        }
        FlightAssistant.INSTANCE.getLogger$flightassistant_forge().info("Registered {} computers from mods: {}", (Object)computers.size(), (Object)CollectionsKt.joinToString$default((Iterable)namespaces, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null));
    }

    public final void tick$flightassistant_forge(float partialTick) {
        boolean paused = FlightAssistant.INSTANCE.getMc$flightassistant_forge().m_91104_();
        LocalPlayer localPlayer = FlightAssistant.INSTANCE.getMc$flightassistant_forge().f_91074_;
        Intrinsics.checkNotNull((Object)localPlayer);
        FATickCounter.INSTANCE.tick(localPlayer, partialTick, paused);
        if (paused || FATickCounter.INSTANCE.getTicksSinceWorldLoad() < FATickCounter.INSTANCE.getWorldLoadWaitTime() || !FAConfig.INSTANCE.getGlobal$flightassistant_forge().getModEnabled$flightassistant_forge()) {
            return;
        }
        FlightAssistant.INSTANCE.getProfiler$flightassistant_forge().m_6180_("flightassistant:computer_host");
        for (Map.Entry<ResourceLocation, Computer> entry : computers.entrySet()) {
            ResourceLocation id = entry.getKey();
            Computer computer = entry.getValue();
            FlightAssistant.INSTANCE.getProfiler$flightassistant_forge().m_6180_(id.toString());
            if (!computer.isDisabledOrFaulted()) {
                try {
                    int n = FATickCounter.INSTANCE.getTicksPassed();
                    int n2 = 0;
                    while (n2 < n) {
                        int it = n2++;
                        boolean bl = false;
                        computer.tick();
                    }
                    computer.renderTick();
                }
                catch (Throwable t) {
                    this.onComputerFault(computer);
                    FlightAssistant.INSTANCE.getLogger$flightassistant_forge().error("Exception ticking computer with identifier: " + id, t);
                }
            }
            FlightAssistant.INSTANCE.getProfiler$flightassistant_forge().m_7238_();
        }
        FlightAssistant.INSTANCE.getProfiler$flightassistant_forge().m_7238_();
    }

    @Override
    @Deprecated(message="Will be private")
    @Nullable
    public <C, T> T guardedCall(C computer, @NotNull Function1<? super C, ? extends T> call) {
        Intrinsics.checkNotNullParameter(call, (String)"call");
        try {
            return (T)call.invoke(computer);
        }
        catch (Throwable t) {
            if (!(computer instanceof Computer)) {
                return null;
            }
            this.onComputerFault((Computer)computer);
            FlightAssistant.INSTANCE.getLogger$flightassistant_forge().error("Exception invoking guarded call", t);
            return null;
        }
    }

    @Override
    public <Event extends ComputerEvent> void dispatchEvent(@NotNull Event event) {
        Intrinsics.checkNotNullParameter(event, (String)"event");
        for (Computer computer : computers.values()) {
            if (computer.isDisabledOrFaulted()) continue;
            this.guardedCall(computer, arg_0 -> ComputerHost.dispatchEvent$lambda$2(event, arg_0));
        }
    }

    @Override
    @NotNull
    public <Response> Collection<Response> dispatchQuery(@NotNull ComputerQuery<Response> query) {
        Intrinsics.checkNotNullParameter(query, (String)"query");
        for (Computer computer : computers.values()) {
            if (computer.isDisabledOrFaulted()) continue;
            this.guardedCall(computer, arg_0 -> ComputerHost.dispatchQuery$lambda$3(query, arg_0));
        }
        return query.getResponses$flightassistant_forge();
    }

    private final void onComputerFault(Computer computer) {
        computer.setFaulted$flightassistant_forge(true);
        int n = computer.getFaultCount();
        computer.setFaultCount$flightassistant_forge(n + 1);
        computer.reset();
    }

    @Override
    public boolean toggleEnabled(@NotNull ResourceLocation identifier) {
        return ModuleController.super.toggleEnabled(identifier);
    }

    @Override
    @NotNull
    public AirDataComputer getData() {
        return ComputerBus.super.getData();
    }

    @Override
    @NotNull
    public HudDisplayDataComputer getHudData() {
        return ComputerBus.super.getHudData();
    }

    @Override
    @NotNull
    public AutoFlightComputer getAutoflight() {
        return ComputerBus.super.getAutoflight();
    }

    @Override
    @NotNull
    public FireworkComputer getFirework() {
        return ComputerBus.super.getFirework();
    }

    @Override
    @NotNull
    public FlightPlanComputer getPlan() {
        return ComputerBus.super.getPlan();
    }

    @Override
    @NotNull
    public HeadingComputer getHeading() {
        return ComputerBus.super.getHeading();
    }

    @Override
    @NotNull
    public PitchComputer getPitch() {
        return ComputerBus.super.getPitch();
    }

    @Override
    @NotNull
    public RollComputer getRoll() {
        return ComputerBus.super.getRoll();
    }

    @Override
    @NotNull
    public ThrustComputer getThrust() {
        return ComputerBus.super.getThrust();
    }

    @Override
    @NotNull
    public AlertComputer getAlert() {
        return ComputerBus.super.getAlert();
    }

    @Override
    @NotNull
    public ChunkStatusComputer getChunk() {
        return ComputerBus.super.getChunk();
    }

    @Override
    @NotNull
    public ElytraStatusComputer getElytra() {
        return ComputerBus.super.getElytra();
    }

    @Override
    @NotNull
    public FlightProtectionsComputer getProtections() {
        return ComputerBus.super.getProtections();
    }

    @Override
    @NotNull
    public GroundProximityComputer getGpws() {
        return ComputerBus.super.getGpws();
    }

    @Override
    @NotNull
    public StallComputer getStall() {
        return ComputerBus.super.getStall();
    }

    @Override
    @NotNull
    public VoidProximityComputer getVoidProximity() {
        return ComputerBus.super.getVoidProximity();
    }

    private static final Unit dispatchEvent$lambda$2(ComputerEvent $event, Computer it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.handleEvent($event);
        return Unit.INSTANCE;
    }

    private static final Unit dispatchQuery$lambda$3(ComputerQuery $query, Computer it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.handleQuery($query);
        return Unit.INSTANCE;
    }
}

