/*
 * Decompiled with CFR 0.152.
 */
package ru.octol1ttle.flightassistant.impl.computer.data;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.ClosedFloatingPointRange;
import kotlin.ranges.RangesKt;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import ru.octol1ttle.flightassistant.FlightAssistant;
import ru.octol1ttle.flightassistant.api.computer.Computer;
import ru.octol1ttle.flightassistant.api.computer.ComputerBus;
import ru.octol1ttle.flightassistant.api.util.FATickCounter;
import ru.octol1ttle.flightassistant.api.util.MathHelperKt;
import ru.octol1ttle.flightassistant.api.util.RenderMatrices;
import ru.octol1ttle.flightassistant.api.util.extensions.ClientPlayerExtensionsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 #2\u00020\u0001:\u0001#B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010 \u001a\u00020!H\u0016J\b\u0010\"\u001a\u00020!H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u000eR\u001e\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u0010@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001e\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u0010@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0013R\u001e\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u0010@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0013R\u0011\u0010\u0018\u001a\u00020\u00198F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u001c\u001a\u00020\u001d8F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006$"}, d2={"Lru/octol1ttle/flightassistant/impl/computer/data/HudDisplayDataComputer;", "Lru/octol1ttle/flightassistant/api/computer/Computer;", "computers", "Lru/octol1ttle/flightassistant/api/computer/ComputerBus;", "mc", "Lnet/minecraft/client/Minecraft;", "<init>", "(Lru/octol1ttle/flightassistant/api/computer/ComputerBus;Lnet/minecraft/client/Minecraft;)V", "player", "Lnet/minecraft/client/player/LocalPlayer;", "getPlayer", "()Lnet/minecraft/client/player/LocalPlayer;", "isViewMirrored", "", "()Z", "value", "Lnet/minecraft/world/phys/Vec3;", "lerpedPosition", "getLerpedPosition", "()Lnet/minecraft/world/phys/Vec3;", "lerpedVelocity", "getLerpedVelocity", "lerpedForwardVelocity", "getLerpedForwardVelocity", "lerpedAltitude", "", "getLerpedAltitude", "()D", "roll", "", "getRoll", "()F", "renderTick", "", "reset", "Companion", "flightassistant-forge"})
public final class HudDisplayDataComputer
extends Computer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Minecraft mc;
    @NotNull
    private Vec3 lerpedPosition;
    @NotNull
    private Vec3 lerpedVelocity;
    @NotNull
    private Vec3 lerpedForwardVelocity;
    @NotNull
    private static final ResourceLocation ID = FlightAssistant.INSTANCE.id$flightassistant_forge("hud_display_data");

    public HudDisplayDataComputer(@NotNull ComputerBus computers, @NotNull Minecraft mc) {
        Intrinsics.checkNotNullParameter((Object)computers, (String)"computers");
        Intrinsics.checkNotNullParameter((Object)mc, (String)"mc");
        super(computers);
        this.mc = mc;
        Vec3 vec3 = Vec3.f_82478_;
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"ZERO");
        this.lerpedPosition = vec3;
        Vec3 vec32 = Vec3.f_82478_;
        Intrinsics.checkNotNullExpressionValue((Object)vec32, (String)"ZERO");
        this.lerpedVelocity = vec32;
        Vec3 vec33 = Vec3.f_82478_;
        Intrinsics.checkNotNullExpressionValue((Object)vec33, (String)"ZERO");
        this.lerpedForwardVelocity = vec33;
    }

    @NotNull
    public final LocalPlayer getPlayer() {
        LocalPlayer localPlayer = this.mc.f_91074_;
        if (localPlayer == null) {
            String string = "Required value was null.";
            throw new IllegalStateException(string.toString());
        }
        return localPlayer;
    }

    public final boolean isViewMirrored() {
        return this.mc.f_91066_.m_92176_().m_90613_();
    }

    @NotNull
    public final Vec3 getLerpedPosition() {
        return this.lerpedPosition;
    }

    @NotNull
    public final Vec3 getLerpedVelocity() {
        return this.lerpedVelocity;
    }

    @NotNull
    public final Vec3 getLerpedForwardVelocity() {
        return this.lerpedForwardVelocity;
    }

    public final double getLerpedAltitude() {
        return this.lerpedPosition.f_82480_;
    }

    public final float getRoll() {
        return MathHelperKt.throwIfNotInRange(MathHelperKt.degrees((float)Math.atan2(-RenderMatrices.INSTANCE.getWorldSpaceMatrix().m10(), RenderMatrices.INSTANCE.getWorldSpaceMatrix().m11())), (ClosedFloatingPointRange<Float>)RangesKt.rangeTo((float)-180.0f, (float)180.0f));
    }

    @Override
    public void renderTick() {
        Vec3 vec3 = this.getPlayer().m_20318_(FATickCounter.INSTANCE.getPartialTick());
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"getPosition(...)");
        this.lerpedPosition = vec3;
        this.lerpedVelocity = ClientPlayerExtensionsKt.getLerpedDeltaMovement((AbstractClientPlayer)this.getPlayer(), FATickCounter.INSTANCE.getPartialTick());
        this.lerpedForwardVelocity = this.getComputers().getData().computeForwardVector(this.lerpedVelocity);
    }

    @Override
    public void reset() {
        Vec3 vec3 = Vec3.f_82478_;
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"ZERO");
        this.lerpedPosition = vec3;
        Vec3 vec32 = Vec3.f_82478_;
        Intrinsics.checkNotNullExpressionValue((Object)vec32, (String)"ZERO");
        this.lerpedVelocity = vec32;
        Vec3 vec33 = Vec3.f_82478_;
        Intrinsics.checkNotNullExpressionValue((Object)vec33, (String)"ZERO");
        this.lerpedForwardVelocity = vec33;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lru/octol1ttle/flightassistant/impl/computer/data/HudDisplayDataComputer$Companion;", "", "<init>", "()V", "ID", "Lnet/minecraft/resources/ResourceLocation;", "getID", "()Lnet/minecraft/resources/ResourceLocation;", "flightassistant-forge"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ResourceLocation getID() {
            return ID;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

