/*
 * Decompiled with CFR 0.152.
 */
package ru.octol1ttle.flightassistant.impl.computer.safety;

import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;
import ru.octol1ttle.flightassistant.FlightAssistant;
import ru.octol1ttle.flightassistant.api.alert.Alert;
import ru.octol1ttle.flightassistant.api.alert.AlertCategory;
import ru.octol1ttle.flightassistant.api.alert.AlertCategoryRegistrationCallback;
import ru.octol1ttle.flightassistant.api.alert.AlertData;
import ru.octol1ttle.flightassistant.api.computer.Computer;
import ru.octol1ttle.flightassistant.api.computer.ComputerBus;
import ru.octol1ttle.flightassistant.api.util.ChangeTrackingArrayList;
import ru.octol1ttle.flightassistant.api.util.FATickCounter;
import ru.octol1ttle.flightassistant.api.util.extensions.CollectionExtensionsKt;
import ru.octol1ttle.flightassistant.api.util.extensions.SoundManagerExtensionsKt;
import ru.octol1ttle.flightassistant.impl.alert.AlertSoundInstance;
import ru.octol1ttle.flightassistant.impl.alert.autoflight.AutoThrustOffAlert;
import ru.octol1ttle.flightassistant.impl.alert.autoflight.AutopilotOffAlert;
import ru.octol1ttle.flightassistant.impl.alert.elytra.ElytraDurabilityCriticalAlert;
import ru.octol1ttle.flightassistant.impl.alert.elytra.ElytraDurabilityLowAlert;
import ru.octol1ttle.flightassistant.impl.alert.fault.DisplayFaultAlert;
import ru.octol1ttle.flightassistant.impl.alert.fault.computer.AlertComputerFaultAlert;
import ru.octol1ttle.flightassistant.impl.alert.fault.computer.ComputerFaultAlert;
import ru.octol1ttle.flightassistant.impl.alert.firework.FireworkExplosiveAlert;
import ru.octol1ttle.flightassistant.impl.alert.firework.FireworkNoResponseAlert;
import ru.octol1ttle.flightassistant.impl.alert.firework.FireworkSlowResponseAlert;
import ru.octol1ttle.flightassistant.impl.alert.flight_controls.ProtectionsLostAlert;
import ru.octol1ttle.flightassistant.impl.alert.flight_plan.ArrivalElevationDisagreeAlert;
import ru.octol1ttle.flightassistant.impl.alert.flight_plan.DepartureElevationDisagreeAlert;
import ru.octol1ttle.flightassistant.impl.alert.flight_plan.DescentTooSteepAlert;
import ru.octol1ttle.flightassistant.impl.alert.flight_plan.ObstaclesOnPathAlert;
import ru.octol1ttle.flightassistant.impl.alert.gpws.BelowGlideSlopeAlert;
import ru.octol1ttle.flightassistant.impl.alert.gpws.BelowGlideSlopeWarningAlert;
import ru.octol1ttle.flightassistant.impl.alert.gpws.DontSinkAlert;
import ru.octol1ttle.flightassistant.impl.alert.gpws.MinimumsReachedAlert;
import ru.octol1ttle.flightassistant.impl.alert.gpws.PullUpAlert;
import ru.octol1ttle.flightassistant.impl.alert.gpws.SinkRateAlert;
import ru.octol1ttle.flightassistant.impl.alert.gpws.TerrainAheadAlert;
import ru.octol1ttle.flightassistant.impl.alert.navigation.ApproachingVoidDamageAltitudeAlert;
import ru.octol1ttle.flightassistant.impl.alert.navigation.NoChunksLoadedAlert;
import ru.octol1ttle.flightassistant.impl.alert.navigation.ReachedVoidDamageAltitudeAlert;
import ru.octol1ttle.flightassistant.impl.alert.navigation.SlowChunkLoadingAlert;
import ru.octol1ttle.flightassistant.impl.alert.stall.ApproachingStallAlert;
import ru.octol1ttle.flightassistant.impl.alert.stall.FullStallAlert;
import ru.octol1ttle.flightassistant.impl.alert.thrust.NoThrustSourceAlert;
import ru.octol1ttle.flightassistant.impl.alert.thrust.ReverseThrustNotSupportedAlert;
import ru.octol1ttle.flightassistant.impl.alert.thrust.ThrustLockedAlert;
import ru.octol1ttle.flightassistant.impl.computer.autoflight.AutoFlightComputer;
import ru.octol1ttle.flightassistant.impl.computer.autoflight.FireworkComputer;
import ru.octol1ttle.flightassistant.impl.computer.autoflight.FlightPlanComputer;
import ru.octol1ttle.flightassistant.impl.computer.autoflight.base.HeadingComputer;
import ru.octol1ttle.flightassistant.impl.computer.autoflight.base.PitchComputer;
import ru.octol1ttle.flightassistant.impl.computer.autoflight.base.RollComputer;
import ru.octol1ttle.flightassistant.impl.computer.autoflight.base.ThrustComputer;
import ru.octol1ttle.flightassistant.impl.computer.data.AirDataComputer;
import ru.octol1ttle.flightassistant.impl.computer.data.HudDisplayDataComputer;
import ru.octol1ttle.flightassistant.impl.computer.safety.ChunkStatusComputer;
import ru.octol1ttle.flightassistant.impl.computer.safety.ElytraStatusComputer;
import ru.octol1ttle.flightassistant.impl.computer.safety.GroundProximityComputer;
import ru.octol1ttle.flightassistant.impl.computer.safety.StallComputer;
import ru.octol1ttle.flightassistant.impl.computer.safety.VoidProximityComputer;
import ru.octol1ttle.flightassistant.impl.display.HudDisplayHost;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000e\u0018\u0000 )2\u00020\u0001:\u0001)B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u001cH\u0002J\u000e\u0010\u001e\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020\u0010J\u0006\u0010 \u001a\u00020\u001cJ\u0006\u0010!\u001a\u00020\u001cJ\b\u0010\"\u001a\u00020\u001cH\u0016J\b\u0010#\u001a\u00020\u001cH\u0002J\u0012\u0010$\u001a\u00020\u001c2\b\b\u0002\u0010%\u001a\u00020\tH\u0002J\b\u0010&\u001a\u00020\u001cH\u0002J\b\u0010'\u001a\u00020\u001cH\u0002J\b\u0010(\u001a\u00020\u001cH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u00020\tX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R6\u0010\u0013\u001a*\u0012\u0004\u0012\u00020\u0015\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170\u00160\u0014j\u0014\u0012\u0004\u0012\u00020\u0015\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170\u0016`\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0019\u001a\u001e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u001a0\u0014j\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u001a`\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lru/octol1ttle/flightassistant/impl/computer/safety/AlertComputer;", "Lru/octol1ttle/flightassistant/api/computer/Computer;", "computers", "Lru/octol1ttle/flightassistant/api/computer/ComputerBus;", "soundManager", "Lnet/minecraft/client/sounds/SoundManager;", "<init>", "(Lru/octol1ttle/flightassistant/api/computer/ComputerBus;Lnet/minecraft/client/sounds/SoundManager;)V", "alertsFaulted", "", "getAlertsFaulted$flightassistant_forge", "()Z", "setAlertsFaulted$flightassistant_forge", "(Z)V", "categories", "", "Lru/octol1ttle/flightassistant/api/alert/AlertCategory;", "getCategories", "()Ljava/util/List;", "alertLists", "Ljava/util/HashMap;", "Lru/octol1ttle/flightassistant/api/alert/AlertData;", "Lru/octol1ttle/flightassistant/api/util/ChangeTrackingArrayList;", "Lru/octol1ttle/flightassistant/api/alert/Alert;", "Lkotlin/collections/HashMap;", "sounds", "Lru/octol1ttle/flightassistant/impl/alert/AlertSoundInstance;", "invokeEvents", "", "registerBuiltin", "register", "category", "hideCurrentAlert", "showHiddenAlert", "tick", "updateAlerts", "tickSoundsAndStopInactive", "force", "startNewSounds", "stopOutPrioritizedAlerts", "reset", "Companion", "flightassistant-forge"})
@SourceDebugExtension(value={"SMAP\nAlertComputer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AlertComputer.kt\nru/octol1ttle/flightassistant/impl/computer/safety/AlertComputer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,291:1\n1563#2:292\n1634#2,3:293\n1011#2,2:296\n1869#2,2:298\n1374#2:300\n1460#2,5:301\n1761#2,3:309\n1056#2:316\n2423#2,14:317\n1056#2:331\n1869#2,2:332\n1869#2,2:334\n1869#2,2:336\n504#3,3:306\n507#3,4:312\n*S KotlinDebug\n*F\n+ 1 AlertComputer.kt\nru/octol1ttle/flightassistant/impl/computer/safety/AlertComputer\n*L\n91#1:292\n91#1:293,3\n200#1:296,2\n202#1:298,2\n204#1:300\n204#1:301,5\n229#1:309,3\n229#1:316\n231#1:317,14\n262#1:331\n281#1:332,2\n282#1:334,2\n283#1:336,2\n229#1:306,3\n229#1:312,4\n*E\n"})
public final class AlertComputer
extends Computer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SoundManager soundManager;
    private boolean alertsFaulted;
    @NotNull
    private final List<AlertCategory> categories;
    @NotNull
    private final HashMap<AlertData, ChangeTrackingArrayList<Alert>> alertLists;
    @NotNull
    private final HashMap<AlertData, AlertSoundInstance> sounds;
    @NotNull
    private static final ResourceLocation ID = FlightAssistant.INSTANCE.id$flightassistant_forge("alert");

    public AlertComputer(@NotNull ComputerBus computers, @NotNull SoundManager soundManager) {
        Intrinsics.checkNotNullParameter((Object)computers, (String)"computers");
        Intrinsics.checkNotNullParameter((Object)soundManager, (String)"soundManager");
        super(computers);
        this.soundManager = soundManager;
        this.categories = new ArrayList();
        this.alertLists = new HashMap();
        this.sounds = new HashMap();
    }

    public final boolean getAlertsFaulted$flightassistant_forge() {
        return this.alertsFaulted;
    }

    public final void setAlertsFaulted$flightassistant_forge(boolean bl) {
        this.alertsFaulted = bl;
    }

    @NotNull
    public final List<AlertCategory> getCategories() {
        return this.categories;
    }

    @Override
    public void invokeEvents() {
        this.registerBuiltin();
        ((AlertCategoryRegistrationCallback)AlertCategoryRegistrationCallback.EVENT.invoker()).register(this.getComputers(), this::register);
    }

    /*
     * WARNING - void declaration
     */
    private final void registerBuiltin() {
        Collection<DisplayFaultAlert> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        MutableComponent mutableComponent = Component.m_237115_((String)"alert.flightassistant.alert");
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"translatable(...)");
        this.register(new AlertCategory((Component)mutableComponent).add(new AlertComputerFaultAlert(this.getComputers())));
        MutableComponent mutableComponent2 = Component.m_237115_((String)"alert.flightassistant.autoflight");
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent2, (String)"translatable(...)");
        AlertCategory alertCategory = new AlertCategory((Component)mutableComponent2);
        ComputerBus computerBus = this.getComputers();
        ResourceLocation resourceLocation = AutoFlightComputer.Companion.getID();
        MutableComponent mutableComponent3 = Component.m_237115_((String)"alert.flightassistant.autoflight.fault");
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent3, (String)"translatable(...)");
        AlertCategory alertCategory2 = alertCategory.add(new ComputerFaultAlert(computerBus, resourceLocation, (Component)mutableComponent3, null, null, 24, null));
        ComputerBus computerBus2 = this.getComputers();
        ResourceLocation resourceLocation2 = PitchComputer.Companion.getID();
        MutableComponent mutableComponent4 = Component.m_237115_((String)"alert.flightassistant.autoflight.pitch_fault");
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent4, (String)"translatable(...)");
        AlertCategory alertCategory3 = alertCategory2.add(new ComputerFaultAlert(computerBus2, resourceLocation2, (Component)mutableComponent4, null, null, 24, null));
        ComputerBus computerBus3 = this.getComputers();
        ResourceLocation resourceLocation3 = HeadingComputer.Companion.getID();
        MutableComponent mutableComponent5 = Component.m_237115_((String)"alert.flightassistant.autoflight.heading_fault");
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent5, (String)"translatable(...)");
        AlertCategory alertCategory4 = alertCategory3.add(new ComputerFaultAlert(computerBus3, resourceLocation3, (Component)mutableComponent5, null, null, 24, null));
        ComputerBus computerBus4 = this.getComputers();
        ResourceLocation resourceLocation4 = RollComputer.Companion.getID();
        MutableComponent mutableComponent6 = Component.m_237115_((String)"alert.flightassistant.autoflight.roll_fault");
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent6, (String)"translatable(...)");
        this.register(alertCategory4.add(new ComputerFaultAlert(computerBus4, resourceLocation4, (Component)mutableComponent6, null, null, 24, null)).add(new AutopilotOffAlert(this.getComputers())).add(new AutoThrustOffAlert(this.getComputers())));
        MutableComponent mutableComponent7 = Component.m_237115_((String)"alert.flightassistant.elytra");
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent7, (String)"translatable(...)");
        AlertCategory alertCategory5 = new AlertCategory((Component)mutableComponent7);
        ComputerBus computerBus5 = this.getComputers();
        ResourceLocation resourceLocation5 = ElytraStatusComputer.Companion.getID();
        MutableComponent mutableComponent8 = Component.m_237115_((String)"alert.flightassistant.elytra.fault");
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent8, (String)"translatable(...)");
        this.register(alertCategory5.add(new ComputerFaultAlert(computerBus5, resourceLocation5, (Component)mutableComponent8, null, null, 24, null)).add(new ElytraDurabilityCriticalAlert(this.getComputers())).add(new ElytraDurabilityLowAlert(this.getComputers())));
        MutableComponent mutableComponent9 = Component.m_237115_((String)"alert.flightassistant.fault.hud");
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent9, (String)"translatable(...)");
        AlertCategory alertCategory6 = new AlertCategory((Component)mutableComponent9);
        ComputerBus computerBus6 = this.getComputers();
        ResourceLocation resourceLocation6 = HudDisplayDataComputer.Companion.getID();
        MutableComponent mutableComponent10 = Component.m_237115_((String)"alert.flightassistant.fault.hud.data");
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent10, (String)"translatable(...)");
        Iterable iterable = HudDisplayHost.INSTANCE.identifiers();
        AlertCategory alertCategory7 = alertCategory6.add(new ComputerFaultAlert(computerBus6, resourceLocation6, (Component)mutableComponent10, null, null, 24, null));
        AlertComputer alertComputer = this;
        boolean $i$f$map = false;
        void var3_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ResourceLocation resourceLocation7 = (ResourceLocation)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new DisplayFaultAlert(this.getComputers(), (ResourceLocation)it));
        }
        collection = (List)destination$iv$iv;
        alertComputer.register(alertCategory7.addAll((Collection<? extends Alert>)collection));
        MutableComponent mutableComponent11 = Component.m_237115_((String)"alert.flightassistant.firework");
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent11, (String)"translatable(...)");
        AlertCategory alertCategory8 = new AlertCategory((Component)mutableComponent11);
        ComputerBus computerBus7 = this.getComputers();
        ResourceLocation resourceLocation8 = FireworkComputer.Companion.getID();
        MutableComponent mutableComponent12 = Component.m_237115_((String)"alert.flightassistant.firework.fault");
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent12, (String)"translatable(...)");
        this.register(alertCategory8.add(new ComputerFaultAlert(computerBus7, resourceLocation8, (Component)mutableComponent12, null, null, 24, null)).add(new FireworkExplosiveAlert(this.getComputers(), InteractionHand.MAIN_HAND)).add(new FireworkExplosiveAlert(this.getComputers(), InteractionHand.OFF_HAND)).add(new FireworkNoResponseAlert(this.getComputers())).add(new FireworkSlowResponseAlert(this.getComputers())));
        MutableComponent mutableComponent13 = Component.m_237115_((String)"alert.flightassistant.flight_controls");
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent13, (String)"translatable(...)");
        AlertCategory alertCategory9 = new AlertCategory((Component)mutableComponent13);
        ComputerBus computerBus8 = this.getComputers();
        ResourceLocation resourceLocation9 = PitchComputer.Companion.getID();
        MutableComponent mutableComponent14 = Component.m_237115_((String)"alert.flightassistant.flight_controls.pitch_fault");
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent14, (String)"translatable(...)");
        this.register(alertCategory9.add(new ComputerFaultAlert(computerBus8, resourceLocation9, (Component)mutableComponent14, CollectionsKt.listOf((Object)Component.m_237115_((String)"alert.flightassistant.flight_controls.pitch_fault.use_automation_override")), null, 16, null)).add(new ProtectionsLostAlert(this.getComputers())));
        MutableComponent mutableComponent15 = Component.m_237115_((String)"alert.flightassistant.flight_plan");
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent15, (String)"translatable(...)");
        AlertCategory alertCategory10 = new AlertCategory((Component)mutableComponent15);
        ComputerBus computerBus9 = this.getComputers();
        ResourceLocation resourceLocation10 = FlightPlanComputer.Companion.getID();
        MutableComponent mutableComponent16 = Component.m_237115_((String)"alert.flightassistant.flight_plan.fault");
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent16, (String)"translatable(...)");
        this.register(alertCategory10.add(new ComputerFaultAlert(computerBus9, resourceLocation10, (Component)mutableComponent16, null, null, 24, null)).add(new ArrivalElevationDisagreeAlert(this.getComputers())).add(new DepartureElevationDisagreeAlert(this.getComputers())).add(new ObstaclesOnPathAlert(this.getComputers())).add(new DescentTooSteepAlert(this.getComputers())));
        MutableComponent mutableComponent17 = Component.m_237115_((String)"alert.flightassistant.gpws");
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent17, (String)"translatable(...)");
        AlertCategory alertCategory11 = new AlertCategory((Component)mutableComponent17);
        ComputerBus computerBus10 = this.getComputers();
        ResourceLocation resourceLocation11 = GroundProximityComputer.Companion.getID();
        MutableComponent mutableComponent18 = Component.m_237115_((String)"alert.flightassistant.gpws.fault");
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent18, (String)"translatable(...)");
        this.register(alertCategory11.add(new ComputerFaultAlert(computerBus10, resourceLocation11, (Component)mutableComponent18, null, null, 24, null)).add(new PullUpAlert(this.getComputers())).add(new BelowGlideSlopeWarningAlert(this.getComputers())).add(new SinkRateAlert(this.getComputers())).add(new TerrainAheadAlert(this.getComputers())).add(new BelowGlideSlopeAlert(this.getComputers())).add(new DontSinkAlert(this.getComputers())).add(new MinimumsReachedAlert(this.getComputers())));
        MutableComponent mutableComponent19 = Component.m_237115_((String)"alert.flightassistant.navigation");
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent19, (String)"translatable(...)");
        AlertCategory alertCategory12 = new AlertCategory((Component)mutableComponent19);
        ComputerBus computerBus11 = this.getComputers();
        ResourceLocation resourceLocation12 = AirDataComputer.Companion.getID();
        MutableComponent mutableComponent20 = Component.m_237115_((String)"alert.flightassistant.navigation.air_data_fault");
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent20, (String)"translatable(...)");
        AlertCategory alertCategory13 = alertCategory12.add(new ComputerFaultAlert(computerBus11, resourceLocation12, (Component)mutableComponent20, null, AlertData.Companion.getMASTER_WARNING(), 8, null));
        ComputerBus computerBus12 = this.getComputers();
        ResourceLocation resourceLocation13 = ChunkStatusComputer.Companion.getID();
        MutableComponent mutableComponent21 = Component.m_237115_((String)"alert.flightassistant.navigation.chunk_status_fault");
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent21, (String)"translatable(...)");
        AlertCategory alertCategory14 = alertCategory13.add(new ComputerFaultAlert(computerBus12, resourceLocation13, (Component)mutableComponent21, null, null, 24, null));
        ComputerBus computerBus13 = this.getComputers();
        ResourceLocation resourceLocation14 = VoidProximityComputer.Companion.getID();
        MutableComponent mutableComponent22 = Component.m_237115_((String)"alert.flightassistant.navigation.void_proximity_fault");
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent22, (String)"translatable(...)");
        this.register(alertCategory14.add(new ComputerFaultAlert(computerBus13, resourceLocation14, (Component)mutableComponent22, null, null, 24, null)).add(new ReachedVoidDamageAltitudeAlert(this.getComputers())).add(new ApproachingVoidDamageAltitudeAlert(this.getComputers())).add(new NoChunksLoadedAlert(this.getComputers())).add(new SlowChunkLoadingAlert(this.getComputers())));
        MutableComponent mutableComponent23 = Component.m_237115_((String)"alert.flightassistant.stall");
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent23, (String)"translatable(...)");
        AlertCategory alertCategory15 = new AlertCategory((Component)mutableComponent23);
        ComputerBus computerBus14 = this.getComputers();
        ResourceLocation resourceLocation15 = StallComputer.Companion.getID();
        MutableComponent mutableComponent24 = Component.m_237115_((String)"alert.flightassistant.stall.detection_fault");
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent24, (String)"translatable(...)");
        this.register(alertCategory15.add(new ComputerFaultAlert(computerBus14, resourceLocation15, (Component)mutableComponent24, null, null, 24, null)).add(new FullStallAlert(this.getComputers())).add(new ApproachingStallAlert(this.getComputers())));
        MutableComponent mutableComponent25 = Component.m_237115_((String)"alert.flightassistant.thrust");
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent25, (String)"translatable(...)");
        AlertCategory alertCategory16 = new AlertCategory((Component)mutableComponent25);
        ComputerBus computerBus15 = this.getComputers();
        ResourceLocation resourceLocation16 = ThrustComputer.Companion.getID();
        MutableComponent mutableComponent26 = Component.m_237115_((String)"alert.flightassistant.thrust.fault");
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent26, (String)"translatable(...)");
        this.register(alertCategory16.add(new ComputerFaultAlert(computerBus15, resourceLocation16, (Component)mutableComponent26, null, null, 24, null)).add(new ThrustLockedAlert(this.getComputers())).add(new NoThrustSourceAlert(this.getComputers())).add(new ReverseThrustNotSupportedAlert(this.getComputers())));
    }

    public final void register(@NotNull AlertCategory category) {
        Intrinsics.checkNotNullParameter((Object)category, (String)"category");
        if (this.categories.contains(category)) {
            throw new IllegalArgumentException("Already registered alert category: " + category.getCategoryText().getString());
        }
        this.categories.add(category);
    }

    public final void hideCurrentAlert() {
        for (AlertCategory category : this.categories) {
            if (category.getActiveAlerts().isEmpty()) continue;
            Alert alert = category.getActiveAlerts().remove(0);
            category.getIgnoredAlerts().add(alert);
            alert.onHide();
            break;
        }
    }

    public final void showHiddenAlert() {
        for (AlertCategory category : this.categories) {
            if (category.getIgnoredAlerts().isEmpty()) continue;
            category.getIgnoredAlerts().remove(0);
            break;
        }
    }

    @Override
    public void tick() {
        this.updateAlerts();
        if (this.getComputers().getData().getPlayer().m_21224_() || !this.getComputers().getData().getFlying()) {
            this.tickSoundsAndStopInactive(true);
            return;
        }
        AlertComputer.tickSoundsAndStopInactive$default(this, false, 1, null);
        this.startNewSounds();
        this.stopOutPrioritizedAlerts();
    }

    /*
     * WARNING - void declaration
     */
    private final void updateAlerts() {
        void $this$flatMapTo$iv$iv;
        Object element$iv2;
        for (AlertCategory category : this.categories) {
            category.updateActiveAlerts(this.getComputers());
        }
        List<AlertCategory> $this$sortBy$iv = this.categories;
        boolean $i$f$sortBy = false;
        if ($this$sortBy$iv.size() > 1) {
            CollectionsKt.sortWith($this$sortBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    AlertCategory it = (AlertCategory)a;
                    boolean bl = false;
                    Integer n = it.getHighestPriority();
                    it = (AlertCategory)b;
                    Comparable comparable = Integer.valueOf(n != null ? n : Integer.MAX_VALUE);
                    bl = false;
                    Integer n2 = it.getHighestPriority();
                    return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)Integer.valueOf(n2 != null ? n2 : Integer.MAX_VALUE));
                }
            });
        }
        Collection<ChangeTrackingArrayList<Alert>> collection = this.alertLists.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv2 : $this$forEach$iv) {
            ChangeTrackingArrayList p0 = (ChangeTrackingArrayList)element$iv2;
            boolean bl = false;
            p0.startTracking();
        }
        Iterable $this$flatMap$iv = this.categories;
        boolean $i$f$flatMap = false;
        element$iv2 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            AlertCategory it = (AlertCategory)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.getActiveAlerts();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        for (Alert alert : (List)destination$iv$iv) {
            this.alertLists.computeIfAbsent(alert.getData(), arg_0 -> AlertComputer.updateAlerts$lambda$4(AlertComputer::updateAlerts$lambda$3, arg_0)).add(alert);
        }
    }

    private final void tickSoundsAndStopInactive(boolean force) {
        Iterator<Map.Entry<AlertData, AlertSoundInstance>> iterator = this.sounds.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<AlertData, AlertSoundInstance> entry;
            Intrinsics.checkNotNullExpressionValue(iterator.next(), (String)"next(...)");
            int n = FATickCounter.INSTANCE.getTicksPassed();
            int n2 = 0;
            while (n2 < n) {
                int it = n2++;
                boolean bl = false;
                entry.getValue().tick();
                AlertSoundInstance alertSoundInstance = entry.getValue();
                Intrinsics.checkNotNullExpressionValue((Object)((Object)alertSoundInstance), (String)"<get-value>(...)");
                SoundManagerExtensionsKt.applyVolume(this.soundManager, (SoundInstance)alertSoundInstance);
            }
            if (!force) {
                ChangeTrackingArrayList<Alert> changeTrackingArrayList = this.alertLists.get(entry.getKey());
                if (changeTrackingArrayList != null ? !changeTrackingArrayList.isEmpty() : false) continue;
            }
            entry.getValue().setLooping(false, this.soundManager);
            if (entry.getValue().fadeOut(FATickCounter.INSTANCE.getTicksPassed())) {
                iterator.remove();
            }
            AlertSoundInstance alertSoundInstance = entry.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)((Object)alertSoundInstance), (String)"<get-value>(...)");
            SoundManagerExtensionsKt.applyVolume(this.soundManager, (SoundInstance)alertSoundInstance);
        }
    }

    static /* synthetic */ void tickSoundsAndStopInactive$default(AlertComputer alertComputer, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        alertComputer.tickSoundsAndStopInactive(bl);
    }

    /*
     * Unable to fully structure code
     */
    private final void startNewSounds() {
        $this$filterValues$iv = this.alertLists;
        $i$f$filterValues = false;
        result$iv = new LinkedHashMap<K, V>();
        for (Map.Entry<K, V> entry$iv : $this$filterValues$iv.entrySet()) {
            block16: {
                list = (ChangeTrackingArrayList)entry$iv.getValue();
                $i$a$-filterValues-AlertComputer$startNewSounds$newDatas$1 = false;
                if (list.hasNewElements((Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, startNewSounds$lambda$8$lambda$6(ru.octol1ttle.flightassistant.api.alert.Alert ), (Lru/octol1ttle/flightassistant/api/alert/Alert;)Ljava/lang/Boolean;)())) ** GOTO lbl-1000
                $this$any$iv = list;
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    v0 = false;
                } else {
                    for (T element$iv : $this$any$iv) {
                        it = (Alert)element$iv;
                        $i$a$-any-AlertComputer$startNewSounds$newDatas$1$2 = false;
                        if (!(this.sounds.containsKey(it.getData()) == false && it.getAlertMethod().audio() != false)) continue;
                        v0 = true;
                        break block16;
                    }
                    v0 = false;
                }
            }
            if (v0) lbl-1000:
            // 2 sources

            {
                v1 = true;
            } else {
                v1 = false;
            }
            if (!v1) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        $this$sortedBy$iv = ((Map)result$iv).keySet();
        $i$f$sortedBy = false;
        newDatas = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                AlertData it = (AlertData)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getPriority());
                it = (AlertData)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getPriority()));
            }
        });
        newHighestPriorityDatas = CollectionExtensionsKt.getHighestPriority(newDatas);
        v2 = this.sounds.keySet();
        Intrinsics.checkNotNullExpressionValue(v2, (String)"<get-keys>(...)");
        $this$minByOrNull$iv = v2;
        $i$f$minByOrNull = false;
        iterator$iv = $this$minByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v3 = null;
        } else {
            minElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v3 = minElem$iv;
            } else {
                it = (AlertData)minElem$iv;
                $i$a$-minByOrNull-AlertComputer$startNewSounds$activeHighestPriority$1 = false;
                minValue$iv = it.getPriority();
                do {
                    e$iv = iterator$iv.next();
                    it = (AlertData)e$iv;
                    $i$a$-minByOrNull-AlertComputer$startNewSounds$activeHighestPriority$1 = false;
                    v$iv = it.getPriority();
                    if (minValue$iv <= v$iv) continue;
                    minElem$iv = e$iv;
                    minValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v3 = minElem$iv;
            }
        }
        v4 = v3;
        activeHighestPriority = v4 != null ? v4.getPriority() : 0x7FFFFFFF;
        anyStartedThisTick = false;
        var5_5 = newHighestPriorityDatas.iterator();
        while (var5_5.hasNext() && (data = (AlertData)var5_5.next()).getPriority() <= activeHighestPriority) {
            existing = this.sounds.get(data);
            if (existing != null && (existing.m_7775_() || existing.getAge() <= 60)) continue;
            if (existing != null) {
                this.soundManager.m_120399_((SoundInstance)existing);
            }
            instance = new AlertSoundInstance((Player)this.getComputers().getData().getPlayer(), data);
            ((Map)this.sounds).put(data, instance);
            if (!anyStartedThisTick) {
                this.soundManager.m_120367_((SoundInstance)instance);
            } else if (instance.m_7775_()) {
                instance.silence();
                this.soundManager.m_120367_((SoundInstance)instance);
                SoundManagerExtensionsKt.pause(this.soundManager, (SoundInstance)instance);
            }
            anyStartedThisTick = true;
        }
    }

    private final void stopOutPrioritizedAlerts() {
        boolean interrupt = false;
        Set<Map.Entry<AlertData, AlertSoundInstance>> set = this.sounds.entrySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"<get-entries>(...)");
        Iterable $this$sortedBy$iv = set;
        boolean $i$f$sortedBy = false;
        for (Object e : CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Map.Entry it = (Map.Entry)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(((AlertData)it.getKey()).getPriority());
                it = (Map.Entry)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(((AlertData)it.getKey()).getPriority()));
            }
        })) {
            Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
            Map.Entry entry = (Map.Entry)e;
            if (!interrupt) {
                interrupt = true;
                if (!((AlertSoundInstance)((Object)entry.getValue())).m_7775_()) continue;
                Object v = entry.getValue();
                Intrinsics.checkNotNullExpressionValue(v, (String)"<get-value>(...)");
                SoundManagerExtensionsKt.unpause(this.soundManager, (SoundInstance)v);
                continue;
            }
            if (((AlertSoundInstance)((Object)entry.getValue())).m_7775_()) {
                Object v = entry.getValue();
                Intrinsics.checkNotNullExpressionValue(v, (String)"<get-value>(...)");
                SoundManagerExtensionsKt.pause(this.soundManager, (SoundInstance)v);
                continue;
            }
            ((AlertSoundInstance)((Object)entry.getValue())).fadeOut(FATickCounter.INSTANCE.getTicksPassed());
        }
    }

    @Override
    public void reset() {
        Object it;
        this.alertsFaulted = false;
        Iterable $this$forEach$iv = this.categories;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (AlertCategory)element$iv;
            boolean bl = false;
            it.getActiveAlerts().clear();
        }
        $this$forEach$iv = this.categories;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (AlertCategory)element$iv;
            boolean bl = false;
            it.getIgnoredAlerts().clear();
        }
        Collection<AlertSoundInstance> collection = this.sounds.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        $this$forEach$iv = collection;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (AlertSoundInstance)((Object)element$iv);
            boolean bl = false;
            this.soundManager.m_120399_((SoundInstance)it);
        }
        this.sounds.clear();
    }

    private static final ChangeTrackingArrayList updateAlerts$lambda$3(AlertData it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new ChangeTrackingArrayList();
    }

    private static final ChangeTrackingArrayList updateAlerts$lambda$4(Function1 $tmp0, Object p0) {
        return (ChangeTrackingArrayList)$tmp0.invoke(p0);
    }

    private static final boolean startNewSounds$lambda$8$lambda$6(Alert it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getAlertMethod().audio();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lru/octol1ttle/flightassistant/impl/computer/safety/AlertComputer$Companion;", "", "<init>", "()V", "ID", "Lnet/minecraft/resources/ResourceLocation;", "getID", "()Lnet/minecraft/resources/ResourceLocation;", "flightassistant-forge"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ResourceLocation getID() {
            return ID;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

