/*
 * Decompiled with CFR 0.152.
 */
package ru.octol1ttle.flightassistant.impl.computer.safety;

import java.time.Duration;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerboundPlayerCommandPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ElytraItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.octol1ttle.flightassistant.FlightAssistant;
import ru.octol1ttle.flightassistant.api.computer.Computer;
import ru.octol1ttle.flightassistant.api.computer.ComputerBus;
import ru.octol1ttle.flightassistant.api.util.extensions.BlockStateExtensionsKt;
import ru.octol1ttle.flightassistant.api.util.extensions.StringExtensionsKt;
import ru.octol1ttle.flightassistant.config.FAConfig;
import ru.octol1ttle.flightassistant.config.options.DisplayOptions;
import ru.octol1ttle.flightassistant.impl.computer.data.AirDataComputer;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0018\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u0012J\u0015\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\u0002\u0010\u0019J\b\u0010\u001a\u001a\u00020\fH\u0016R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\n\u00a8\u0006\u001c"}, d2={"Lru/octol1ttle/flightassistant/impl/computer/safety/ElytraStatusComputer;", "Lru/octol1ttle/flightassistant/api/computer/Computer;", "computers", "Lru/octol1ttle/flightassistant/api/computer/ComputerBus;", "<init>", "(Lru/octol1ttle/flightassistant/api/computer/ComputerBus;)V", "activeElytra", "Lnet/minecraft/world/item/ItemStack;", "syncedFlyingState", "", "Ljava/lang/Boolean;", "tick", "", "sendSwitchState", "data", "Lru/octol1ttle/flightassistant/impl/computer/data/AirDataComputer;", "findActiveElytra", "player", "Lnet/minecraft/world/entity/player/Player;", "formatDurability", "Lnet/minecraft/network/chat/Component;", "units", "Lru/octol1ttle/flightassistant/config/options/DisplayOptions$DurabilityUnits;", "getRemainingFlightTime", "", "(Lnet/minecraft/world/entity/player/Player;)Ljava/lang/Integer;", "reset", "Companion", "flightassistant-forge"})
public final class ElytraStatusComputer
extends Computer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private ItemStack activeElytra;
    @Nullable
    private Boolean syncedFlyingState;
    @NotNull
    private static final ResourceLocation ID = FlightAssistant.INSTANCE.id$flightassistant_forge("elytra_status");

    public ElytraStatusComputer(@NotNull ComputerBus computers) {
        Intrinsics.checkNotNullParameter((Object)computers, (String)"computers");
        super(computers);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void tick() {
        data = this.getComputers().getData();
        this.activeElytra = this.findActiveElytra((Player)data.getPlayer());
        if (this.activeElytra == null || data.getPlayer().m_20096_()) {
            this.syncedFlyingState = null;
            return;
        }
        if (this.syncedFlyingState != null) {
            if (!Intrinsics.areEqual((Object)this.syncedFlyingState, (Object)data.getFlying())) {
                this.syncedFlyingState = null;
            }
            return;
        }
        if (!data.automationsAllowed(false)) {
            return;
        }
        if (FAConfig.INSTANCE.getSafety().getElytraCloseUnderwater() && data.getFlying() && data.getPlayer().m_5842_()) {
            this.sendSwitchState(data);
        }
        flying = data.getFlying() != false || data.getPlayer().m_150110_().f_35936_ != false;
        v0 = data.getPlayer().m_6168_();
        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getArmorSlots(...)");
        if (!CollectionsKt.contains((Iterable)v0, (Object)this.activeElytra)) ** GOTO lbl-1000
        v1 = this.activeElytra;
        Intrinsics.checkNotNull((Object)v1);
        if (ElytraItem.m_41140_((ItemStack)v1)) {
            v2 = true;
        } else lbl-1000:
        // 2 sources

        {
            v2 = false;
        }
        hasUsableElytra = v2;
        v3 = data.getPlayer().m_20075_();
        Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"getBlockStateOn(...)");
        if (!BlockStateExtensionsKt.notClimbable(v3, (Entity)data.getPlayer())) ** GOTO lbl-1000
        v4 = data.getPlayer().m_146900_();
        Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"getFeetBlockState(...)");
        if (BlockStateExtensionsKt.notClimbable(v4, (Entity)data.getPlayer())) {
            v5 = true;
        } else lbl-1000:
        // 2 sources

        {
            v5 = false;
        }
        noneClimbable = v5;
        v6 = lookingToClutch = data.getPitch() <= -70.0f;
        if (FAConfig.INSTANCE.getSafety().getElytraAutoOpen() && !flying && !data.getFallDistanceSafe() && hasUsableElytra && noneClimbable && !lookingToClutch) {
            this.sendSwitchState(data);
        }
    }

    private final void sendSwitchState(AirDataComputer data) {
        this.syncedFlyingState = data.getFlying();
        data.getPlayer().f_108617_.m_104955_((Packet)new ServerboundPlayerCommandPacket((Entity)data.getPlayer(), ServerboundPlayerCommandPacket.Action.START_FALL_FLYING));
    }

    private final ItemStack findActiveElytra(Player player) {
        ItemStack stack;
        for (Object t : player.m_6168_()) {
            Intrinsics.checkNotNullExpressionValue(t, (String)"next(...)");
            stack = (ItemStack)t;
            if (!(stack.m_41720_() instanceof ElytraItem)) continue;
            return stack;
        }
        for (Object t : player.m_6167_()) {
            Intrinsics.checkNotNullExpressionValue(t, (String)"next(...)");
            stack = (ItemStack)t;
            if (!(stack.m_41720_() instanceof ElytraItem)) continue;
            return stack;
        }
        return null;
    }

    @Nullable
    public final Component formatDurability(@NotNull DisplayOptions.DurabilityUnits units, @NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)((Object)units), (String)"units");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        ItemStack itemStack = this.activeElytra;
        if (itemStack == null) {
            return null;
        }
        ItemStack active = itemStack;
        if (!active.m_41763_()) {
            return (Component)Component.m_237115_((String)"short.flightassistant.infinite");
        }
        int unbreakingLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44986_, (ItemStack)active);
        return switch (WhenMappings.$EnumSwitchMapping$0[units.ordinal()]) {
            case 1 -> (Component)Component.m_237113_((String)String.valueOf(active.m_41776_() - active.m_41773_()));
            case 2 -> (Component)Component.m_237113_((String)(MathKt.roundToInt((float)((float)Math.rint((float)((active.m_41776_() - active.m_41773_() - 1) * 100) / (float)active.m_41776_()))) + "%"));
            case 3 -> {
                Integer v2 = this.getRemainingFlightTime(player);
                Intrinsics.checkNotNull((Object)v2);
                Duration v3 = Duration.ofSeconds(v2.intValue());
                Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"ofSeconds(...)");
                Duration duration = v3;
                int v4 = switch (unbreakingLevel) {
                    case 0 -> duration.toSecondsPart();
                    case 1 -> Mth.m_184628_((double)duration.toSecondsPart(), (int)5);
                    case 2 -> Mth.m_184628_((double)duration.toSecondsPart(), (int)15);
                    default -> Mth.m_184628_((double)duration.toSecondsPart(), (int)30);
                };
                int seconds = v4;
                Object[] var7_7 = new Object[]{seconds};
                yield (Component)Component.m_237113_((String)(duration.toMinutesPart() + ":" + StringExtensionsKt.formatRoot("%02d", var7_7)));
            }
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @Nullable
    public final Integer getRemainingFlightTime(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        ItemStack itemStack = this.activeElytra;
        if (itemStack == null) {
            return null;
        }
        ItemStack active = itemStack;
        if (!active.m_41763_()) {
            return Integer.MAX_VALUE;
        }
        int unbreakingLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44986_, (ItemStack)active);
        return (active.m_41776_() - active.m_41773_() - 1) * (unbreakingLevel + 1);
    }

    @Override
    public void reset() {
        this.activeElytra = null;
        this.syncedFlyingState = null;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lru/octol1ttle/flightassistant/impl/computer/safety/ElytraStatusComputer$Companion;", "", "<init>", "()V", "ID", "Lnet/minecraft/resources/ResourceLocation;", "getID", "()Lnet/minecraft/resources/ResourceLocation;", "flightassistant-forge"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ResourceLocation getID() {
            return ID;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DisplayOptions.DurabilityUnits.values().length];
            try {
                nArray[DisplayOptions.DurabilityUnits.RAW.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DisplayOptions.DurabilityUnits.PERCENTAGE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DisplayOptions.DurabilityUnits.TIME.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

